/*
 * Decompiled with CFR 0.152.
 */
package net.algart.additions.arrays;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;

public final class ArrayMinMaxFinder {
    private final boolean multithreading;
    private final ExtendedMinMaxInfo[] threadMinMax;
    private final ExtendedMinMaxInfo resultMinMax;
    private final long[] splitters;

    private ArrayMinMaxFinder(boolean multithreading) {
        int cpuCount = Arrays.SystemSettings.cpuCount();
        int numberOfTasks = !multithreading || cpuCount == 1 ? 1 : 4 * cpuCount;
        this.multithreading = numberOfTasks > 1;
        this.resultMinMax = new ExtendedMinMaxInfo();
        this.threadMinMax = new ExtendedMinMaxInfo[numberOfTasks];
        if (numberOfTasks == 1) {
            this.threadMinMax[0] = this.resultMinMax;
        } else {
            Arrays.setAll(this.threadMinMax, k -> new ExtendedMinMaxInfo());
        }
        this.splitters = new long[numberOfTasks + 1];
    }

    public static ArrayMinMaxFinder newInstance(boolean multithreading) {
        return new ArrayMinMaxFinder(multithreading);
    }

    public Min getMinFinder() {
        return new Min(){

            @Override
            public boolean isMinFound() {
                return ArrayMinMaxFinder.this.resultMinMax().isMinFound();
            }

            @Override
            public long indexOfMin() {
                return ArrayMinMaxFinder.this.resultMinMax().getIndexOfMin();
            }

            @Override
            public long indexOfMin(Supplier<? extends RuntimeException> exceptionSupplierWhenNotFound) {
                return ArrayMinMaxFinder.throwForNegative(this.indexOfMin(), exceptionSupplierWhenNotFound);
            }

            @Override
            public double min() {
                return ArrayMinMaxFinder.this.resultMinMax().getMin();
            }

            @Override
            public long exactMin() {
                return ArrayMinMaxFinder.this.resultMinMax().getExactMin();
            }

            @Override
            public Min find(PArray data) {
                ArrayMinMaxFinder.this.doFind(data, true, false);
                return this;
            }

            @Override
            public Min find(Matrix<? extends PArray> matrix) {
                ArrayMinMaxFinder.this.doFind(matrix, true, false);
                return this;
            }
        };
    }

    public Max getMaxFinder() {
        return new Max(){

            @Override
            public boolean isMaxFound() {
                return ArrayMinMaxFinder.this.resultMinMax().isMaxFound();
            }

            @Override
            public long indexOfMax() {
                return ArrayMinMaxFinder.this.resultMinMax().getIndexOfMax();
            }

            @Override
            public long indexOfMax(Supplier<? extends RuntimeException> exceptionSupplierWhenNotFound) {
                return ArrayMinMaxFinder.throwForNegative(this.indexOfMax(), exceptionSupplierWhenNotFound);
            }

            @Override
            public double max() {
                return ArrayMinMaxFinder.this.resultMinMax().getMax();
            }

            @Override
            public long exactMax() {
                return ArrayMinMaxFinder.this.resultMinMax().getExactMax();
            }

            @Override
            public Max find(PArray data) {
                ArrayMinMaxFinder.this.doFind(data, false, true);
                return this;
            }

            @Override
            public Max find(Matrix<? extends PArray> matrix) {
                ArrayMinMaxFinder.this.doFind(matrix, false, true);
                return this;
            }
        };
    }

    public MinMax getMinMaxFinder() {
        return new MinMax(){

            @Override
            public boolean isMinFound() {
                return ArrayMinMaxFinder.this.resultMinMax().isMinFound();
            }

            @Override
            public long indexOfMin() {
                return ArrayMinMaxFinder.this.resultMinMax().getIndexOfMin();
            }

            @Override
            public long indexOfMin(Supplier<? extends RuntimeException> exceptionSupplierWhenNotFound) {
                return ArrayMinMaxFinder.throwForNegative(this.indexOfMin(), exceptionSupplierWhenNotFound);
            }

            @Override
            public double min() {
                return ArrayMinMaxFinder.this.resultMinMax().getMin();
            }

            @Override
            public long exactMin() {
                return ArrayMinMaxFinder.this.resultMinMax().getExactMin();
            }

            @Override
            public boolean isMaxFound() {
                return ArrayMinMaxFinder.this.resultMinMax().isMaxFound();
            }

            @Override
            public long indexOfMax() {
                return ArrayMinMaxFinder.this.resultMinMax().getIndexOfMax();
            }

            @Override
            public long indexOfMax(Supplier<? extends RuntimeException> exceptionSupplierWhenNotFound) {
                return ArrayMinMaxFinder.throwForNegative(this.indexOfMax(), exceptionSupplierWhenNotFound);
            }

            @Override
            public double max() {
                return ArrayMinMaxFinder.this.resultMinMax().getMax();
            }

            @Override
            public long exactMax() {
                return ArrayMinMaxFinder.this.resultMinMax().getExactMax();
            }

            @Override
            public MinMax find(PArray data) {
                ArrayMinMaxFinder.this.doFind(data, true, true);
                return this;
            }

            @Override
            public MinMax find(Matrix<? extends PArray> matrix) {
                ArrayMinMaxFinder.this.doFind(matrix, true, true);
                return this;
            }
        };
    }

    private void doFind(PArray data, boolean needMin, boolean needMax) {
        Objects.requireNonNull(data, "Null data");
        if (!needMin && !needMax) {
            throw new AssertionError((Object)"At least one of needMin/needMax must be set");
        }
        net.algart.arrays.Arrays.splitToRanges((long[])this.splitters, (long)data.length());
        Class elementType = data.elementType();
        if (elementType == Boolean.TYPE) {
            Arrays.MinMaxInfo mm = new Arrays.MinMaxInfo();
            net.algart.arrays.Arrays.rangeOf((PArray)data, (Arrays.MinMaxInfo)mm);
            this.resultMinMax.setElementType(elementType).setExactAll(mm.indexOfMin(), (int)mm.min(), mm.indexOfMax(), (int)mm.max());
            return;
        }
        IntStream stream = IntStream.range(0, this.splitters.length - 1);
        if (this.multithreading) {
            stream = stream.parallel();
        }
        if (elementType == Character.TYPE) {
            CharArray array = (CharArray)data;
            stream.forEach(rangeIndex -> this.minMaxForChars(array, rangeIndex, needMin, needMax));
        } else if (elementType == Byte.TYPE) {
            ByteArray array = (ByteArray)data;
            stream.forEach(rangeIndex -> this.minMaxForBytes(array, rangeIndex, needMin, needMax));
        } else if (elementType == Short.TYPE) {
            ShortArray array = (ShortArray)data;
            stream.forEach(rangeIndex -> this.minMaxForShorts(array, rangeIndex, needMin, needMax));
        } else if (elementType == Integer.TYPE) {
            IntArray array = (IntArray)data;
            stream.forEach(rangeIndex -> this.minMaxForInts(array, rangeIndex, needMin, needMax));
        } else if (elementType == Long.TYPE) {
            LongArray array = (LongArray)data;
            stream.forEach(rangeIndex -> this.minMaxForLongs(array, rangeIndex, needMin, needMax));
        } else if (elementType == Float.TYPE) {
            FloatArray array = (FloatArray)data;
            stream.forEach(rangeIndex -> this.minMaxForFloats(array, rangeIndex, needMin, needMax));
        } else if (elementType == Double.TYPE) {
            DoubleArray array = (DoubleArray)data;
            stream.forEach(rangeIndex -> this.minMaxForDoubles(array, rangeIndex, needMin, needMax));
        } else {
            throw new AssertionError((Object)("Impossible element type " + String.valueOf(elementType)));
        }
        this.completeResult(needMin, needMax);
    }

    private void doFind(Matrix<? extends PArray> matrix, boolean needMin, boolean needMax) {
        Objects.requireNonNull(matrix, "Null data matrix");
        this.doFind((PArray)matrix.array(), needMin, needMax);
    }

    private void completeResult(boolean needMin, boolean needMax) {
        if (this.threadMinMax.length == 1) {
            return;
        }
        this.resultMinMax.copyFrom(this.threadMinMax[0]);
        for (int k = 1; k < this.threadMinMax.length; ++k) {
            if (needMin) {
                this.resultMinMax.updateMin(this.threadMinMax[k]);
            }
            if (!needMax) continue;
            this.resultMinMax.updateMax(this.threadMinMax[k]);
        }
    }

    private ExtendedMinMaxInfo resultMinMax() {
        this.checkReady();
        return this.resultMinMax;
    }

    private static long throwForNegative(long index, Supplier<? extends RuntimeException> exceptionSupplierForNegativeIndex) {
        if (index < 0L) {
            throw exceptionSupplierForNegativeIndex.get();
        }
        return index;
    }

    private void checkReady() {
        if (!this.resultMinMax.isReady()) {
            throw new IllegalStateException("Minimum/maximum are not found yet");
        }
    }

    private void minMaxForChars(CharArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Character.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            char[] array = (char[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.charRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.charRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.charRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.charRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.charRangeMax(data, minMax, from, to - from);
        } else {
            this.charRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void charRangeMin(CharArray data, ExtendedMinMaxInfo result, long p, long length) {
        char c;
        int n = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            char v = data.getChar(i);
            if (v >= c) continue;
            c = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, c);
    }

    private void charRangeMax(CharArray data, ExtendedMinMaxInfo result, long p, long length) {
        char c;
        int n = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            char v = data.getChar(i);
            if (v <= c) continue;
            c = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, c);
    }

    private void charRangeMinMax(CharArray data, ExtendedMinMaxInfo result, long p, long length) {
        char c;
        char c2;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            char v = data.getChar(i);
            if (v < c2) {
                c2 = v;
                indexOfMin = i;
            }
            if (v <= c) continue;
            c = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, c2, indexOfMax, c);
    }

    private void charRangeMin(char[] data, ExtendedMinMaxInfo result, int p, int length) {
        char c;
        int n = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            char v = data[i];
            if (v >= c) continue;
            c = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, c);
    }

    private void charRangeMax(char[] data, ExtendedMinMaxInfo result, int p, int length) {
        char c;
        int n = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            char v = data[i];
            if (v <= c) continue;
            c = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, c);
    }

    private void charRangeMinMax(char[] data, ExtendedMinMaxInfo result, int p, int length) {
        char c;
        char c2;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            char v = data[i];
            if (v < c2) {
                c2 = v;
                indexOfMin = i;
            }
            if (v <= c) continue;
            c = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, c2, indexOfMax, c);
    }

    private void minMaxForBytes(ByteArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Byte.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            byte[] array = (byte[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.byteRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.byteRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.byteRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.byteRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.byteRangeMax(data, minMax, from, to - from);
        } else {
            this.byteRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void byteRangeMin(ByteArray data, ExtendedMinMaxInfo result, long p, long length) {
        int min = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getByte(i) & 0xFF;
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void byteRangeMax(ByteArray data, ExtendedMinMaxInfo result, long p, long length) {
        int max = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getByte(i) & 0xFF;
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void byteRangeMinMax(ByteArray data, ExtendedMinMaxInfo result, long p, long length) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getByte(i) & 0xFF;
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void byteRangeMin(byte[] data, ExtendedMinMaxInfo result, int p, int length) {
        int min = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i] & 0xFF;
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void byteRangeMax(byte[] data, ExtendedMinMaxInfo result, int p, int length) {
        int max = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i] & 0xFF;
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void byteRangeMinMax(byte[] data, ExtendedMinMaxInfo result, int p, int length) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i] & 0xFF;
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void minMaxForShorts(ShortArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Short.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            short[] array = (short[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.shortRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.shortRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.shortRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.shortRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.shortRangeMax(data, minMax, from, to - from);
        } else {
            this.shortRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void shortRangeMin(ShortArray data, ExtendedMinMaxInfo result, long p, long length) {
        int min = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getShort(i) & 0xFFFF;
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void shortRangeMax(ShortArray data, ExtendedMinMaxInfo result, long p, long length) {
        int max = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getShort(i) & 0xFFFF;
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void shortRangeMinMax(ShortArray data, ExtendedMinMaxInfo result, long p, long length) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getShort(i) & 0xFFFF;
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void shortRangeMin(short[] data, ExtendedMinMaxInfo result, int p, int length) {
        int min = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i] & 0xFFFF;
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void shortRangeMax(short[] data, ExtendedMinMaxInfo result, int p, int length) {
        int max = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i] & 0xFFFF;
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void shortRangeMinMax(short[] data, ExtendedMinMaxInfo result, int p, int length) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i] & 0xFFFF;
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void minMaxForInts(IntArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Integer.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            int[] array = (int[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.intRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.intRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.intRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.intRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.intRangeMax(data, minMax, from, to - from);
        } else {
            this.intRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void intRangeMin(IntArray data, ExtendedMinMaxInfo result, long p, long length) {
        int min = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getInt(i);
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void intRangeMax(IntArray data, ExtendedMinMaxInfo result, long p, long length) {
        int max = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getInt(i);
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void intRangeMinMax(IntArray data, ExtendedMinMaxInfo result, long p, long length) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            int v = data.getInt(i);
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void intRangeMin(int[] data, ExtendedMinMaxInfo result, int p, int length) {
        int min = Integer.MAX_VALUE;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i];
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void intRangeMax(int[] data, ExtendedMinMaxInfo result, int p, int length) {
        int max = Integer.MIN_VALUE;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i];
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void intRangeMinMax(int[] data, ExtendedMinMaxInfo result, int p, int length) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            int v = data[i];
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void minMaxForLongs(LongArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Long.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            long[] array = (long[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.longRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.longRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.longRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.longRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.longRangeMax(data, minMax, from, to - from);
        } else {
            this.longRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void longRangeMin(LongArray data, ExtendedMinMaxInfo result, long p, long length) {
        long min = Long.MAX_VALUE;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            long v = data.getLong(i);
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void longRangeMax(LongArray data, ExtendedMinMaxInfo result, long p, long length) {
        long max = Long.MIN_VALUE;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            long v = data.getLong(i);
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void longRangeMinMax(LongArray data, ExtendedMinMaxInfo result, long p, long length) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            long v = data.getLong(i);
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void longRangeMin(long[] data, ExtendedMinMaxInfo result, int p, int length) {
        long min = Long.MAX_VALUE;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            long v = data[i];
            if (v >= min) continue;
            min = v;
            indexOfMin = i;
        }
        result.setExactMin(indexOfMin, min);
    }

    private void longRangeMax(long[] data, ExtendedMinMaxInfo result, int p, int length) {
        long max = Long.MIN_VALUE;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            long v = data[i];
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactMax(indexOfMax, max);
    }

    private void longRangeMinMax(long[] data, ExtendedMinMaxInfo result, int p, int length) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            long v = data[i];
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (v <= max) continue;
            max = v;
            indexOfMax = i;
        }
        result.setExactAll(indexOfMin, min, indexOfMax, max);
    }

    private void minMaxForFloats(FloatArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Float.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            float[] array = (float[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.floatRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.floatRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.floatRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.floatRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.floatRangeMax(data, minMax, from, to - from);
        } else {
            this.floatRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void floatRangeMin(FloatArray data, ExtendedMinMaxInfo result, long p, long length) {
        float min = Float.POSITIVE_INFINITY;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            float v = data.getFloat(i);
            if (!(v < min)) continue;
            min = v;
            indexOfMin = i;
        }
        result.setMin(indexOfMin, min);
    }

    private void floatRangeMax(FloatArray data, ExtendedMinMaxInfo result, long p, long length) {
        float max = Float.NEGATIVE_INFINITY;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            float v = data.getFloat(i);
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setMax(indexOfMax, max);
    }

    private void floatRangeMinMax(FloatArray data, ExtendedMinMaxInfo result, long p, long length) {
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            float v = data.getFloat(i);
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setAll(indexOfMin, min, indexOfMax, max);
    }

    private void floatRangeMin(float[] data, ExtendedMinMaxInfo result, int p, int length) {
        float min = Float.POSITIVE_INFINITY;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            float v = data[i];
            if (!(v < min)) continue;
            min = v;
            indexOfMin = i;
        }
        result.setMin(indexOfMin, min);
    }

    private void floatRangeMax(float[] data, ExtendedMinMaxInfo result, int p, int length) {
        float max = Float.NEGATIVE_INFINITY;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            float v = data[i];
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setMax(indexOfMax, max);
    }

    private void floatRangeMinMax(float[] data, ExtendedMinMaxInfo result, int p, int length) {
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            float v = data[i];
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setAll(indexOfMin, min, indexOfMax, max);
    }

    private void minMaxForDoubles(DoubleArray data, int rangeIndex, boolean needMin, boolean needMax) {
        DirectAccessible da;
        long from = this.splitters[rangeIndex];
        long to = this.splitters[rangeIndex + 1];
        ExtendedMinMaxInfo minMax = this.threadMinMax[rangeIndex];
        minMax.setElementType(Double.TYPE);
        if (data instanceof DirectAccessible && (da = (DirectAccessible)data).hasJavaArray()) {
            int offset = da.javaArrayOffset();
            double[] array = (double[])da.javaArray();
            int intTo = (int)to;
            int intFrom = (int)from;
            assert ((long)intFrom == from && (long)intTo == to);
            if (!needMax) {
                assert (needMin);
                this.doubleRangeMin(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
            } else if (!needMin) {
                this.doubleRangeMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMax -= (long)offset;
            } else {
                this.doubleRangeMinMax(array, minMax, offset + intFrom, intTo - intFrom);
                minMax.indexOfMin -= (long)offset;
                minMax.indexOfMax -= (long)offset;
            }
        } else if (!needMax) {
            assert (needMin);
            this.doubleRangeMin(data, minMax, from, to - from);
        } else if (!needMin) {
            this.doubleRangeMax(data, minMax, from, to - from);
        } else {
            this.doubleRangeMinMax(data, minMax, from, to - from);
        }
    }

    private void doubleRangeMin(DoubleArray data, ExtendedMinMaxInfo result, long p, long length) {
        double min = Double.POSITIVE_INFINITY;
        long indexOfMin = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            double v = data.getDouble(i);
            if (!(v < min)) continue;
            min = v;
            indexOfMin = i;
        }
        result.setMin(indexOfMin, min);
    }

    private void doubleRangeMax(DoubleArray data, ExtendedMinMaxInfo result, long p, long length) {
        double max = Double.NEGATIVE_INFINITY;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            double v = data.getDouble(i);
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setMax(indexOfMax, max);
    }

    private void doubleRangeMinMax(DoubleArray data, ExtendedMinMaxInfo result, long p, long length) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        long to = p + length;
        for (long i = p; i < to; ++i) {
            double v = data.getDouble(i);
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setAll(indexOfMin, min, indexOfMax, max);
    }

    private void doubleRangeMin(double[] data, ExtendedMinMaxInfo result, int p, int length) {
        double min = Double.POSITIVE_INFINITY;
        long indexOfMin = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            double v = data[i];
            if (!(v < min)) continue;
            min = v;
            indexOfMin = i;
        }
        result.setMin(indexOfMin, min);
    }

    private void doubleRangeMax(double[] data, ExtendedMinMaxInfo result, int p, int length) {
        double max = Double.NEGATIVE_INFINITY;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            double v = data[i];
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setMax(indexOfMax, max);
    }

    private void doubleRangeMinMax(double[] data, ExtendedMinMaxInfo result, int p, int length) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        long indexOfMin = -1L;
        long indexOfMax = -1L;
        int to = p + length;
        for (int i = p; i < to; ++i) {
            double v = data[i];
            if (v < min) {
                min = v;
                indexOfMin = i;
            }
            if (!(v > max)) continue;
            max = v;
            indexOfMax = i;
        }
        result.setAll(indexOfMin, min, indexOfMax, max);
    }

    private static class ExtendedMinMaxInfo {
        private Class<?> elementType = null;
        private boolean floatingPoint;
        private double min;
        private double max;
        private long exactMin;
        private long exactMax;
        long indexOfMin = -157L;
        long indexOfMax = -157L;

        private ExtendedMinMaxInfo() {
        }

        public boolean isReady() {
            return this.elementType != null;
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public ExtendedMinMaxInfo setElementType(Class<?> elementType) {
            this.elementType = Objects.requireNonNull(elementType, "Null elementType");
            this.floatingPoint = elementType == Float.TYPE || elementType == Double.TYPE;
            return this;
        }

        public boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public boolean isMinFound() {
            return this.indexOfMin >= 0L;
        }

        public long getIndexOfMin() {
            return this.indexOfMin;
        }

        public double getMin() {
            return this.min;
        }

        public ExtendedMinMaxInfo setMin(long indexOfMin, double min) {
            this.indexOfMin = indexOfMin;
            this.min = min;
            this.exactMin = (long)min;
            return this;
        }

        public long getIndexOfMax() {
            return this.indexOfMax;
        }

        public boolean isMaxFound() {
            return this.indexOfMax >= 0L;
        }

        public double getMax() {
            return this.max;
        }

        public ExtendedMinMaxInfo setMax(long indexOfMax, double max) {
            this.indexOfMax = indexOfMax;
            this.max = max;
            this.exactMax = (long)max;
            return this;
        }

        public ExtendedMinMaxInfo setAll(long indexOfMin, double min, long indexOfMax, double max) {
            return this.setMin(indexOfMin, min).setMax(indexOfMax, max);
        }

        public long getExactMin() {
            this.checkFloatingPoint();
            return this.exactMin;
        }

        public long getExactMax() {
            this.checkFloatingPoint();
            return this.exactMax;
        }

        public ExtendedMinMaxInfo setExactMin(long indexOfMin, long min) {
            this.checkFloatingPoint();
            this.indexOfMin = indexOfMin;
            this.exactMin = min;
            this.min = min;
            return this;
        }

        public ExtendedMinMaxInfo setExactMax(long indexOfMax, long max) {
            this.checkFloatingPoint();
            this.indexOfMax = indexOfMax;
            this.exactMax = max;
            this.max = max;
            return this;
        }

        public ExtendedMinMaxInfo setExactAll(long indexOfMin, long min, long indexOfMax, long max) {
            return this.setExactMin(indexOfMin, min).setExactMax(indexOfMax, max);
        }

        public void copyFrom(ExtendedMinMaxInfo other) {
            this.setElementType(other.elementType);
            this.indexOfMin = other.indexOfMin;
            this.indexOfMax = other.indexOfMax;
            this.min = other.min;
            this.max = other.max;
            this.exactMin = other.exactMin;
            this.exactMax = other.exactMax;
        }

        public void updateMin(ExtendedMinMaxInfo other) {
            boolean better;
            boolean bl = this.floatingPoint ? other.min < this.min || other.min == this.min && other.indexOfMin < this.indexOfMin : (better = other.exactMin < this.exactMin || other.exactMin == this.exactMin && other.indexOfMin < this.indexOfMin);
            if (better) {
                this.indexOfMin = other.indexOfMin;
                this.min = other.min;
                this.exactMin = other.exactMin;
            }
        }

        public void updateMax(ExtendedMinMaxInfo other) {
            boolean better;
            boolean bl = this.floatingPoint ? other.max > this.max || other.max == this.max && other.indexOfMax < this.indexOfMax : (better = other.exactMax > this.exactMax || other.exactMax == this.exactMax && other.indexOfMax < this.indexOfMax);
            if (better) {
                this.indexOfMax = other.indexOfMax;
                this.max = other.max;
                this.exactMax = other.exactMax;
            }
        }

        private void checkFloatingPoint() {
            if (this.floatingPoint) {
                throw new IllegalStateException("Exact minimum/maximum are not allowed for " + this.elementType.getSimpleName() + "[]");
            }
        }
    }

    public static interface MinMax
    extends Min,
    Max {
        @Override
        public MinMax find(PArray var1);

        @Override
        public MinMax find(Matrix<? extends PArray> var1);
    }

    public static interface Max {
        public boolean isMaxFound();

        public long indexOfMax();

        public long indexOfMax(Supplier<? extends RuntimeException> var1);

        public double max();

        public long exactMax();

        public Max find(PArray var1);

        public Max find(Matrix<? extends PArray> var1);
    }

    public static interface Min {
        public boolean isMinFound();

        public long indexOfMin();

        public long indexOfMin(Supplier<? extends RuntimeException> var1);

        public double min();

        public long exactMin();

        public Min find(PArray var1);

        public Min find(Matrix<? extends PArray> var1);
    }
}

