/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import java.util.Optional;
import net.algart.executors.api.data.Port;

public enum ChainPortType {
    INPUT_PORT(1, Port.Type.INPUT, true),
    OUTPUT_PORT(2, Port.Type.OUTPUT, true),
    INPUT_PARAMETER_AS_PORT(3, Port.Type.INPUT, false),
    OUTPUT_PARAMETER_AS_PORT(4, Port.Type.OUTPUT, false);

    private final int code;
    private final Port.Type actualPortType;
    private final boolean actual;

    private ChainPortType(int code, Port.Type actualPortType, boolean actual) {
        this.code = code;
        this.actualPortType = actualPortType;
        this.actual = actual;
    }

    public int code() {
        return this.code;
    }

    public static Optional<ChainPortType> fromCode(int code) {
        for (ChainPortType portType : ChainPortType.values()) {
            if (portType.code != code) continue;
            return Optional.of(portType);
        }
        return Optional.empty();
    }

    public boolean isActual() {
        return this.actual;
    }

    public boolean isVirtual() {
        return !this.actual;
    }

    public Port.Type actualPortType() {
        return this.actualPortType;
    }
}

