/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SMat;
import net.algart.multimatrix.MultiMatrix;

public class ConvertibleMultiMatrix
extends SMat.Convertible {
    final MultiMatrix multiMatrix;
    final SMat.ChannelOrder channelOrder;

    public ConvertibleMultiMatrix(MultiMatrix multiMatrix) {
        this(multiMatrix, SMat.ChannelOrder.STANDARD);
    }

    ConvertibleMultiMatrix(MultiMatrix multiMatrix, SMat.ChannelOrder channelOrder) {
        this.multiMatrix = Objects.requireNonNull(multiMatrix, "Null multiMatrix");
        this.channelOrder = Objects.requireNonNull(channelOrder, "Null channelOrder");
    }

    @Override
    public SMat.Convertible copy() {
        return this;
    }

    @Override
    public SMat.Convertible copyToMemoryAndDisposePrevious() {
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer(SMat thisMatrix) {
        Matrix interleaved = Matrices.interleave((ArrayContext)ArrayContext.getSimpleContext((MemoryModel)BufferMemoryModel.getInstance(), (boolean)false), this.channelOrder == SMat.ChannelOrder.ORDER_IN_PACKED_BYTE_BUFFER ? this.multiMatrix.allChannels() : this.multiMatrix.allChannelsInBGRAOrder());
        return ConvertibleMultiMatrix.toByteBuffer((Matrix<? extends PArray>)interleaved);
    }

    @Override
    public byte[] toByteArray(SMat thisMatrix) {
        if (thisMatrix.getDepth().elementType() != Byte.TYPE) {
            return super.toByteArray(thisMatrix);
        }
        if (this.multiMatrix.numberOfChannels() == 1) {
            return (byte[])((PArray)this.multiMatrix.channel(0).array()).ja();
        }
        Matrix interleave = Matrices.interleave((ArrayContext)ArrayContext.getSimpleContext((MemoryModel)Arrays.SMM, (boolean)false), this.channelOrder == SMat.ChannelOrder.ORDER_IN_PACKED_BYTE_BUFFER ? this.multiMatrix.allChannels() : this.multiMatrix.allChannelsInBGRAOrder());
        return (byte[])((PArray)interleave.array()).ja();
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return "reference to " + String.valueOf(this.multiMatrix);
    }

    public static ByteBuffer toByteBuffer(Matrix<? extends PArray> interleavedChannels) {
        Objects.requireNonNull(interleavedChannels, "Null BGR[A] matrix");
        int dimCount = interleavedChannels.dimCount();
        if (dimCount < 2) {
            throw new IllegalArgumentException("Packed BGR[A] matrix cannot be 1-dimensional: " + String.valueOf(interleavedChannels) + " (the 1st dimension is used to store channels)");
        }
        if (interleavedChannels.dim(0) > 512L) {
            throw new IllegalArgumentException("Number of channels cannot be >512: " + String.valueOf(interleavedChannels));
        }
        Array array = interleavedChannels.array();
        if (!BufferMemoryModel.isBufferArray((Array)array) || BufferMemoryModel.getBufferOffset((Array)array) != 0L) {
            array = array.updatableClone((MemoryModel)BufferMemoryModel.getInstance());
        }
        assert (BufferMemoryModel.isBufferArray((Array)array));
        return BufferMemoryModel.getByteBuffer((Array)array);
    }

    @Override
    MultiMatrix getCachedMultiMatrix(SMat thisMat, boolean autoConvertUnsupportedDepth, SMat.ChannelOrder channelOrder) {
        if (channelOrder == this.channelOrder) {
            return this.multiMatrix;
        }
        return super.getCachedMultiMatrix(thisMat, autoConvertUnsupportedDepth, channelOrder);
    }
}

