/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.contours.Contours;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.SScalar;
import net.algart.external.UsedForExternalCommunication;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.RectangularArea;

public final class SNumbers
extends Data
implements Cloneable {
    public static List<Class<?>> SUPPORTED_ELEMENT_TYPES = List.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    @UsedForExternalCommunication
    private Object array = null;
    @UsedForExternalCommunication
    private int blockLength = 1;
    private static final int PARALLEL_LOG = 8;
    private static final int PARALLEL_BUNDLE = 256;
    private static final char[][] SPACES = new char[64][];

    public static boolean isJavaArraySupported(Object javaArray) {
        return javaArray instanceof byte[] || javaArray instanceof short[] || javaArray instanceof int[] || javaArray instanceof long[] || javaArray instanceof float[] || javaArray instanceof double[];
    }

    public static boolean isElementTypeSupported(Class<?> elementType) {
        return elementType == Byte.TYPE || elementType == Short.TYPE || elementType == Integer.TYPE || elementType == Long.TYPE || elementType == Float.TYPE || elementType == Double.TYPE;
    }

    public static Object convertToArray(Collection<?> numbers) {
        Object[] result = null;
        byte[] bytes = null;
        short[] shorts = null;
        int[] ints = null;
        long[] longs = null;
        float[] floats = null;
        double[] doubles = null;
        int size = numbers.size();
        int k = 0;
        for (Object e : numbers) {
            if (e == null) {
                throw new IllegalArgumentException("Null elements #" + k + " in a collection of numbers");
            }
            if (e instanceof Byte) {
                Byte v = (Byte)e;
                if (bytes == null) {
                    SNumbers.checkChangingElementType(result, bytes, k, e);
                    result = bytes = new byte[size];
                }
                bytes[k++] = v;
                continue;
            }
            if (e instanceof Short) {
                Short v = (Short)e;
                if (shorts == null) {
                    SNumbers.checkChangingElementType(result, shorts, k, e);
                    shorts = new short[size];
                    result = shorts;
                }
                shorts[k++] = v;
                continue;
            }
            if (e instanceof Integer) {
                Integer v = (Integer)e;
                if (ints == null) {
                    SNumbers.checkChangingElementType(result, ints, k, e);
                    ints = new int[size];
                    result = ints;
                }
                ints[k++] = v;
                continue;
            }
            if (e instanceof Long) {
                Long v = (Long)e;
                if (longs == null) {
                    SNumbers.checkChangingElementType(result, longs, k, e);
                    longs = new long[size];
                    result = longs;
                }
                longs[k++] = v;
                continue;
            }
            if (e instanceof Float) {
                Float v = (Float)e;
                if (floats == null) {
                    SNumbers.checkChangingElementType(result, floats, k, e);
                    floats = new float[size];
                    result = floats;
                }
                floats[k++] = v.floatValue();
                continue;
            }
            if (e instanceof Double) {
                Double v = (Double)e;
                if (doubles == null) {
                    SNumbers.checkChangingElementType(result, doubles, k, e);
                    doubles = new double[size];
                    result = doubles;
                }
                doubles[k++] = v;
                continue;
            }
            throw new IllegalArgumentException("Illegal non-numeric type of elements #" + k + " in the collection of numbers: " + String.valueOf(e.getClass()));
        }
        return result;
    }

    private static void checkChangingElementType(Object result, Object expected, int k, Object e) {
        if (result != null && result != expected) {
            throw new IllegalArgumentException("Collection of numbers contain elements of different types: element #" + k + " (" + String.valueOf(e) + ") has another type for storing in " + result.getClass().getCanonicalName());
        }
    }

    public static Class<?> elementType(String primitiveElementTypeName) {
        Objects.requireNonNull(primitiveElementTypeName, "Null element type name");
        return switch (primitiveElementTypeName) {
            case "byte" -> Byte.TYPE;
            case "short" -> Short.TYPE;
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            default -> throw new IllegalArgumentException("Illegal or unsupported element type: " + primitiveElementTypeName);
        };
    }

    @UsedForExternalCommunication
    public SNumbers() {
    }

    @UsedForExternalCommunication
    public Object getArray() {
        return SNumbers.cloneJavaArray(this.array);
    }

    public Object arrayReference() {
        return this.array;
    }

    public int[] toIntArrayOrReference() {
        return this.isIntArray() ? (int[])this.array : this.toIntArray();
    }

    public int getArrayLength() {
        return this.array == null ? 0 : Array.getLength(this.array);
    }

    @UsedForExternalCommunication
    public int getBlockLength() {
        return this.blockLength;
    }

    @UsedForExternalCommunication
    public void setBlockLength(int blockLength) {
        if (blockLength <= 0) {
            throw new IllegalArgumentException("Block length " + blockLength + " is not positive");
        }
        this.blockLength = blockLength;
    }

    public int blockLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot call blockLength(): numbers array is not initialized. You may use getBlockLength() or blockLengthOrZero() instead.");
        }
        return this.blockLength;
    }

    public int blockLengthOrZero() {
        return this.isInitialized() ? this.blockLength : 0;
    }

    public Class<?> elementType() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot get element type: numbers array is not initialized");
        }
        return this.array.getClass().getComponentType();
    }

    public int n() {
        return this.array == null ? 0 : Array.getLength(this.array) / this.blockLength;
    }

    public boolean isEmpty() {
        return this.getArrayLength() == 0;
    }

    public boolean isUnsigned() {
        return this.isByteArray() || this.isShortArray();
    }

    public double getValue(int blockIndex, int indexInBlock) {
        this.checkGetSetIndex(blockIndex, indexInBlock, 1);
        int indexInArray = blockIndex * this.blockLength + indexInBlock;
        if (this.isByteArray()) {
            return ((byte[])this.array)[indexInArray] & 0xFF;
        }
        if (this.isShortArray()) {
            return ((short[])this.array)[indexInArray] & 0xFFFF;
        }
        if (this.isIntArray()) {
            return ((int[])this.array)[indexInArray];
        }
        if (this.isLongArray()) {
            return ((long[])this.array)[indexInArray];
        }
        if (this.isFloatArray()) {
            return ((float[])this.array)[indexInArray];
        }
        if (this.isDoubleArray()) {
            return ((double[])this.array)[indexInArray];
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public void setValue(int blockIndex, int indexInBlock, double value) {
        this.checkGetSetIndex(blockIndex, indexInBlock, 1);
        int indexInArray = blockIndex * this.blockLength + indexInBlock;
        if (this.isByteArray()) {
            ((byte[])this.array)[indexInArray] = (byte)value;
        } else if (this.isShortArray()) {
            ((short[])this.array)[indexInArray] = (short)value;
        } else if (this.isIntArray()) {
            ((int[])this.array)[indexInArray] = (int)value;
        } else if (this.isLongArray()) {
            ((long[])this.array)[indexInArray] = (long)value;
        } else if (this.isFloatArray()) {
            ((float[])this.array)[indexInArray] = (float)value;
        } else if (this.isDoubleArray()) {
            ((double[])this.array)[indexInArray] = value;
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
    }

    public double getValue(int indexInArray) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (this.isByteArray()) {
            return ((byte[])this.array)[indexInArray] & 0xFF;
        }
        if (this.isShortArray()) {
            return ((short[])this.array)[indexInArray] & 0xFFFF;
        }
        if (this.isIntArray()) {
            return ((int[])this.array)[indexInArray];
        }
        if (this.isLongArray()) {
            return ((long[])this.array)[indexInArray];
        }
        if (this.isFloatArray()) {
            return ((float[])this.array)[indexInArray];
        }
        if (this.isDoubleArray()) {
            return ((double[])this.array)[indexInArray];
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public void setValue(int indexInArray, double value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (this.isByteArray()) {
            ((byte[])this.array)[indexInArray] = (byte)value;
        } else if (this.isShortArray()) {
            ((short[])this.array)[indexInArray] = (short)value;
        } else if (this.isIntArray()) {
            ((int[])this.array)[indexInArray] = (int)value;
        } else if (this.isLongArray()) {
            ((long[])this.array)[indexInArray] = (long)value;
        } else if (this.isFloatArray()) {
            ((float[])this.array)[indexInArray] = (float)value;
        } else if (this.isDoubleArray()) {
            ((double[])this.array)[indexInArray] = value;
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
    }

    public long getLongValue(int blockIndex, int indexInBlock) {
        this.checkGetSetIndex(blockIndex, indexInBlock, 1);
        int indexInArray = blockIndex * this.blockLength + indexInBlock;
        if (this.isByteArray()) {
            return ((byte[])this.array)[indexInArray] & 0xFF;
        }
        if (this.isShortArray()) {
            return ((short[])this.array)[indexInArray] & 0xFFFF;
        }
        if (this.isIntArray()) {
            return ((int[])this.array)[indexInArray];
        }
        if (this.isLongArray()) {
            return ((long[])this.array)[indexInArray];
        }
        if (this.isFloatArray()) {
            return (long)((float[])this.array)[indexInArray];
        }
        if (this.isDoubleArray()) {
            return (long)((double[])this.array)[indexInArray];
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public void setLongValue(int blockIndex, int indexInBlock, long value) {
        this.checkGetSetIndex(blockIndex, indexInBlock, 1);
        int indexInArray = blockIndex * this.blockLength + indexInBlock;
        if (this.isByteArray()) {
            ((byte[])this.array)[indexInArray] = (byte)value;
        } else if (this.isShortArray()) {
            ((short[])this.array)[indexInArray] = (short)value;
        } else if (this.isIntArray()) {
            ((int[])this.array)[indexInArray] = (int)value;
        } else if (this.isLongArray()) {
            ((long[])this.array)[indexInArray] = value;
        } else if (this.isFloatArray()) {
            ((float[])this.array)[indexInArray] = value;
        } else if (this.isDoubleArray()) {
            ((double[])this.array)[indexInArray] = value;
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
    }

    public long getLongValue(int indexInArray) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (this.isByteArray()) {
            return ((byte[])this.array)[indexInArray] & 0xFF;
        }
        if (this.isShortArray()) {
            return ((short[])this.array)[indexInArray] & 0xFFFF;
        }
        if (this.isIntArray()) {
            return ((int[])this.array)[indexInArray];
        }
        if (this.isLongArray()) {
            return ((long[])this.array)[indexInArray];
        }
        if (this.isFloatArray()) {
            return (long)((float[])this.array)[indexInArray];
        }
        if (this.isDoubleArray()) {
            return (long)((double[])this.array)[indexInArray];
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public void setLongValue(int indexInArray, long value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (this.isByteArray()) {
            ((byte[])this.array)[indexInArray] = (byte)value;
        } else if (this.isShortArray()) {
            ((short[])this.array)[indexInArray] = (short)value;
        } else if (this.isIntArray()) {
            ((int[])this.array)[indexInArray] = (int)value;
        } else if (this.isLongArray()) {
            ((long[])this.array)[indexInArray] = value;
        } else if (this.isFloatArray()) {
            ((float[])this.array)[indexInArray] = value;
        } else if (this.isDoubleArray()) {
            ((double[])this.array)[indexInArray] = value;
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
    }

    public SNumbers fillValue(double value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (this.isByteArray()) {
            Arrays.fill((byte[])this.array, (byte)value);
        } else if (this.isShortArray()) {
            Arrays.fill((short[])this.array, (short)value);
        } else if (this.isIntArray()) {
            Arrays.fill((int[])this.array, (int)value);
        } else if (this.isLongArray()) {
            Arrays.fill((long[])this.array, (long)value);
        } else if (this.isFloatArray()) {
            Arrays.fill((float[])this.array, (float)value);
        } else if (this.isDoubleArray()) {
            Arrays.fill((double[])this.array, value);
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
        return this;
    }

    public SNumbers fillLongValue(long value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (this.isByteArray()) {
            Arrays.fill((byte[])this.array, (byte)value);
        } else if (this.isShortArray()) {
            Arrays.fill((short[])this.array, (short)value);
        } else if (this.isIntArray()) {
            Arrays.fill((int[])this.array, (int)value);
        } else if (this.isLongArray()) {
            Arrays.fill((long[])this.array, value);
        } else if (this.isFloatArray()) {
            Arrays.fill((float[])this.array, (float)value);
        } else if (this.isDoubleArray()) {
            Arrays.fill((double[])this.array, (double)value);
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
        return this;
    }

    public double[] getBlockDoubleValues(int blockIndex, double[] result) {
        return this.getBlockDoubleValues(blockIndex, 0, this.blockLength, result);
    }

    public double[] getBlockDoubleValues(int blockIndex, int indexInBlock, int lengthInBlock, double[] result) {
        this.checkGetSetIndex(blockIndex, indexInBlock, lengthInBlock);
        return this.getDoubleValues(blockIndex * this.blockLength + indexInBlock, lengthInBlock, result);
    }

    public void setBlockDoubleValues(int blockIndex, double ... values) {
        this.setBlockDoubleValues(blockIndex, 0, this.blockLength, values);
    }

    public void setBlockDoubleValues(int blockIndex, int indexInBlock, int lengthInBlock, double[] values) {
        this.checkGetSetIndex(blockIndex, indexInBlock, lengthInBlock);
        this.setDoubleValues(blockIndex * this.blockLength + indexInBlock, lengthInBlock, values);
    }

    public Object getBlockValues(int blockIndex, Object resultJavaArray) {
        return this.getBlockValues(blockIndex, 0, this.blockLength, resultJavaArray);
    }

    public Object getBlockValues(int blockIndex, int indexInBlock, int lengthInBlock, Object resultJavaArray) {
        this.checkGetSetIndex(blockIndex, indexInBlock, lengthInBlock);
        return this.getValues(blockIndex * this.blockLength + indexInBlock, lengthInBlock, resultJavaArray);
    }

    public void setBlockValues(int blockIndex, Object valuesJavaArray) {
        this.setBlockValues(blockIndex, 0, this.blockLength, valuesJavaArray);
    }

    public void setBlockValues(int blockIndex, int indexInBlock, int lengthInBlock, Object valuesJavaArray) {
        this.checkGetSetIndex(blockIndex, indexInBlock, lengthInBlock);
        this.setValues(blockIndex * this.blockLength + indexInBlock, lengthInBlock, valuesJavaArray);
    }

    public Object getValues(int indexInArray, int length, Object resultJavaArray) {
        if (resultJavaArray == null) {
            resultJavaArray = this.newCompatibleJavaArray(length);
        }
        System.arraycopy(this.array, indexInArray, resultJavaArray, 0, length);
        return resultJavaArray;
    }

    public void setValues(int indexInArray, int length, Object valuesJavaArray) {
        Objects.requireNonNull(valuesJavaArray, "Null values array");
        System.arraycopy(valuesJavaArray, 0, this.array, indexInArray, length);
    }

    public double[] getDoubleValues(int indexInArray, int length, double[] result) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative length = " + length);
        }
        if (result == null) {
            result = new double[length];
        }
        if (this.isByteArray()) {
            byte[] array = (byte[])this.array;
            for (int k = 0; k < length; ++k) {
                result[k] = array[indexInArray++] & 0xFF;
            }
        } else if (this.isShortArray()) {
            short[] array = (short[])this.array;
            for (int k = 0; k < length; ++k) {
                result[k] = array[indexInArray++] & 0xFFFF;
            }
        } else if (this.isIntArray()) {
            int[] array = (int[])this.array;
            for (int k = 0; k < length; ++k) {
                result[k] = array[indexInArray++];
            }
        } else if (this.isLongArray()) {
            long[] array = (long[])this.array;
            for (int k = 0; k < length; ++k) {
                result[k] = array[indexInArray++];
            }
        } else if (this.isFloatArray()) {
            float[] array = (float[])this.array;
            for (int k = 0; k < length; ++k) {
                result[k] = array[indexInArray++];
            }
        } else if (this.isDoubleArray()) {
            System.arraycopy(this.array, indexInArray, result, 0, length);
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
        return result;
    }

    public void setDoubleValues(int indexInArray, int length, double[] values) {
        Objects.requireNonNull(values, "Null values array");
        if (this.isByteArray()) {
            byte[] array = (byte[])this.array;
            for (int k = 0; k < length; ++k) {
                array[indexInArray++] = (byte)values[k];
            }
        } else if (this.isShortArray()) {
            short[] array = (short[])this.array;
            for (int k = 0; k < length; ++k) {
                array[indexInArray++] = (short)values[k];
            }
        } else if (this.isIntArray()) {
            int[] array = (int[])this.array;
            for (int k = 0; k < length; ++k) {
                array[indexInArray++] = (int)values[k];
            }
        } else if (this.isLongArray()) {
            long[] array = (long[])this.array;
            for (int k = 0; k < length; ++k) {
                array[indexInArray++] = (long)values[k];
            }
        } else if (this.isFloatArray()) {
            float[] array = (float[])this.array;
            for (int k = 0; k < length; ++k) {
                array[indexInArray++] = (float)values[k];
            }
        } else if (this.isDoubleArray()) {
            System.arraycopy(values, 0, this.array, indexInArray, length);
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
        }
    }

    @UsedForExternalCommunication
    public boolean isByteArray() {
        return this.array instanceof byte[];
    }

    public byte[] toByteArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isByteArray()) {
            return (byte[])((byte[])this.array).clone();
        }
        if (this.isShortArray()) {
            short[] a = (short[])this.array;
            byte[] result = new byte[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (byte)(a[k] < 0 ? 0 : (a[k] > 255 ? 255 : a[k]));
            }
            return result;
        }
        if (this.isIntArray()) {
            int[] a = (int[])this.array;
            byte[] result = new byte[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (byte)(a[k] < 0 ? 0 : (a[k] > 255 ? 255 : a[k]));
            }
            return result;
        }
        if (this.isLongArray()) {
            long[] a = (long[])this.array;
            byte[] result = new byte[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (byte)(a[k] < 0L ? 0L : (a[k] > 255L ? 255L : a[k]));
            }
            return result;
        }
        if (this.isFloatArray()) {
            float[] a = (float[])this.array;
            byte[] result = new byte[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (byte)(a[k] < 0.0f ? 0 : (a[k] > 255.0f ? 255 : (int)a[k]));
            }
            return result;
        }
        if (this.isDoubleArray()) {
            double[] a = (double[])this.array;
            byte[] result = new byte[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (byte)(a[k] < 0.0 ? 0 : (a[k] > 255.0 ? 255 : (int)a[k]));
            }
            return result;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    @UsedForExternalCommunication
    public boolean isShortArray() {
        return this.array instanceof short[];
    }

    public short[] toShortArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isShortArray()) {
            return (short[])((short[])this.array).clone();
        }
        if (this.isByteArray()) {
            byte[] a = (byte[])this.array;
            short[] result = new short[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (short)(a[k] & 0xFF);
            }
            return result;
        }
        if (this.isIntArray()) {
            int[] a = (int[])this.array;
            short[] result = new short[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (short)(a[k] < 0 ? 0 : (a[k] > 65535 ? 65535 : a[k]));
            }
            return result;
        }
        if (this.isLongArray()) {
            long[] a = (long[])this.array;
            short[] result = new short[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (short)(a[k] < 0L ? 0L : (a[k] > 65535L ? 65535L : a[k]));
            }
            return result;
        }
        if (this.isFloatArray()) {
            float[] a = (float[])this.array;
            short[] result = new short[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (short)(a[k] < 0.0f ? 0.0f : (a[k] > 65535.0f ? 65535.0f : a[k]));
            }
            return result;
        }
        if (this.isDoubleArray()) {
            double[] a = (double[])this.array;
            short[] result = new short[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (short)(a[k] < 0.0 ? 0.0 : (a[k] > 65535.0 ? 65535.0 : a[k]));
            }
            return result;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    @UsedForExternalCommunication
    public boolean isIntArray() {
        return this.array instanceof int[];
    }

    public int[] toIntArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isIntArray()) {
            return (int[])((int[])this.array).clone();
        }
        if (this.isByteArray()) {
            byte[] a = (byte[])this.array;
            int[] result = new int[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFF;
            }
            return result;
        }
        if (this.isShortArray()) {
            short[] a = (short[])this.array;
            int[] result = new int[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFFFF;
            }
            return result;
        }
        if (this.isLongArray()) {
            long[] a = (long[])this.array;
            int[] result = new int[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] < Integer.MIN_VALUE ? Integer.MIN_VALUE : (a[k] > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)a[k]);
            }
            return result;
        }
        if (this.isFloatArray()) {
            float[] a = (float[])this.array;
            int[] result = new int[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (int)a[k];
            }
            return result;
        }
        if (this.isDoubleArray()) {
            double[] a = (double[])this.array;
            int[] result = new int[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (int)a[k];
            }
            return result;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    @UsedForExternalCommunication
    public boolean isLongArray() {
        return this.array instanceof long[];
    }

    public long[] toLongArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isLongArray()) {
            return (long[])((long[])this.array).clone();
        }
        if (this.isByteArray()) {
            byte[] a = (byte[])this.array;
            long[] result = new long[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFF;
            }
            return result;
        }
        if (this.isShortArray()) {
            short[] a = (short[])this.array;
            long[] result = new long[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFFFF;
            }
            return result;
        }
        if (this.isIntArray()) {
            int[] a = (int[])this.array;
            long[] result = new long[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k];
            }
            return result;
        }
        if (this.isFloatArray()) {
            float[] a = (float[])this.array;
            long[] result = new long[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (long)a[k];
            }
            return result;
        }
        if (this.isDoubleArray()) {
            double[] a = (double[])this.array;
            long[] result = new long[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (long)a[k];
            }
            return result;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    @UsedForExternalCommunication
    public boolean isFloatArray() {
        return this.array instanceof float[];
    }

    public float[] toFloatArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isFloatArray()) {
            return (float[])((float[])this.array).clone();
        }
        if (this.isByteArray()) {
            byte[] a = (byte[])this.array;
            float[] result = new float[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFF;
            }
            return result;
        }
        if (this.isShortArray()) {
            short[] a = (short[])this.array;
            float[] result = new float[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFFFF;
            }
            return result;
        }
        if (this.isIntArray()) {
            int[] a = (int[])this.array;
            float[] result = new float[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k];
            }
            return result;
        }
        if (this.isLongArray()) {
            long[] a = (long[])this.array;
            float[] result = new float[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k];
            }
            return result;
        }
        if (this.isDoubleArray()) {
            double[] a = (double[])this.array;
            float[] result = new float[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = (float)a[k];
            }
            return result;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    @UsedForExternalCommunication
    public boolean isDoubleArray() {
        return this.array instanceof double[];
    }

    public double[] toDoubleArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isDoubleArray()) {
            return (double[])((double[])this.array).clone();
        }
        if (this.isByteArray()) {
            byte[] a = (byte[])this.array;
            double[] result = new double[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFF;
            }
            return result;
        }
        if (this.isShortArray()) {
            short[] a = (short[])this.array;
            double[] result = new double[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k] & 0xFFFF;
            }
            return result;
        }
        if (this.isIntArray()) {
            int[] a = (int[])this.array;
            double[] result = new double[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k];
            }
            return result;
        }
        if (this.isLongArray()) {
            long[] a = (long[])this.array;
            double[] result = new double[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k];
            }
            return result;
        }
        if (this.isFloatArray()) {
            float[] a = (float[])this.array;
            double[] result = new double[a.length];
            for (int k = 0; k < a.length; ++k) {
                result[k] = a[k];
            }
            return result;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public PNumberArray asNumberArray() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isByteArray()) {
            return SimpleMemoryModel.asUpdatableByteArray((byte[])((byte[])this.array));
        }
        if (this.isShortArray()) {
            return SimpleMemoryModel.asUpdatableShortArray((short[])((short[])this.array));
        }
        if (this.isIntArray()) {
            return SimpleMemoryModel.asUpdatableIntArray((int[])((int[])this.array));
        }
        if (this.isLongArray()) {
            return SimpleMemoryModel.asUpdatableLongArray((long[])((long[])this.array));
        }
        if (this.isFloatArray()) {
            return SimpleMemoryModel.asUpdatableFloatArray((float[])((float[])this.array));
        }
        if (this.isDoubleArray()) {
            return SimpleMemoryModel.asUpdatableDoubleArray((double[])((double[])this.array));
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public ByteBuffer toByteBuffer(ByteOrder order) {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.isByteArray()) {
            return SNumbers.bytesToByteBuffer((byte[])this.array, order);
        }
        if (this.isShortArray()) {
            return SNumbers.shortsToByteBuffer((short[])this.array, order);
        }
        if (this.isIntArray()) {
            return SNumbers.intsToByteBuffer((int[])this.array, order);
        }
        if (this.isLongArray()) {
            return SNumbers.longsToByteBuffer((long[])this.array, order);
        }
        if (this.isFloatArray()) {
            return SNumbers.floatsToByteBuffer((float[])this.array, order);
        }
        if (this.isDoubleArray()) {
            return SNumbers.doublesToByteBuffer((double[])this.array, order);
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public boolean isProbableRectangularArea() {
        return this.isInitialized() && this.blockLength == 2;
    }

    public IPoint toIPoint() {
        SNumbers numbers = new SNumbers();
        numbers.setToIdentical(this, false);
        if (!numbers.isInitialized()) {
            return null;
        }
        if (numbers.blockLength != 1) {
            throw new IllegalStateException("Numbers array has invalid block length " + numbers.blockLength + ": 1 element per block required for conversion to IPoint");
        }
        long[] array = numbers.toLongArray();
        assert (array != null);
        if (array.length == 0) {
            throw new IllegalStateException("Numbers array is empty and cannot be converted to IPoint");
        }
        return IPoint.of((long[])array);
    }

    public IRectangularArea toIRectangularArea() {
        SNumbers numbers = new SNumbers();
        numbers.setToIdentical(this, false);
        if (!numbers.isInitialized()) {
            return null;
        }
        if (numbers.blockLength != 2) {
            throw new IllegalStateException("Numbers array has invalid block length " + numbers.blockLength + ": 2 elements per block required for conversion to IRectangularArea");
        }
        long[] array = numbers.toLongArray();
        assert (array != null);
        assert (array.length % 2 == 0);
        if (array.length == 0) {
            throw new IllegalStateException("Numbers array is empty and cannot be converted to IRectangularArea");
        }
        IRange[] ranges = new IRange[array.length >> 1];
        int k = 0;
        int i = 0;
        while (i < array.length) {
            long min = array[i++];
            long max = array[i++];
            ranges[k] = IRange.of((long)min, (long)max);
            ++k;
        }
        return IRectangularArea.of((IRange[])ranges);
    }

    public Point toPoint() {
        SNumbers numbers = new SNumbers();
        numbers.setToIdentical(this, false);
        if (!numbers.isInitialized()) {
            return null;
        }
        if (numbers.blockLength != 1) {
            throw new IllegalStateException("Numbers array has invalid block length " + numbers.blockLength + ": 1 element per block required for conversion to Point");
        }
        double[] array = numbers.toDoubleArray();
        assert (array != null);
        if (array.length == 0) {
            throw new IllegalStateException("Numbers array is empty and cannot be converted to Point");
        }
        return Point.of((double[])array);
    }

    public RectangularArea toRectangularArea() {
        SNumbers numbers = new SNumbers();
        numbers.setToIdentical(this, false);
        if (!numbers.isInitialized()) {
            return null;
        }
        if (numbers.blockLength != 2) {
            throw new IllegalStateException("Numbers array has invalid block length " + numbers.blockLength + ": 2 elements per block required for conversion to RectangularArea");
        }
        double[] array = numbers.toDoubleArray();
        assert (array != null);
        assert (array.length % 2 == 0);
        if (array.length == 0) {
            throw new IllegalStateException("Numbers array is empty and cannot be converted to RectangularArea");
        }
        Range[] ranges = new Range[array.length >> 1];
        int k = 0;
        int i = 0;
        while (i < array.length) {
            double min = array[i++];
            double max = array[i++];
            ranges[k] = Range.of((double)min, (double)max);
            ++k;
        }
        return RectangularArea.of((Range[])ranges);
    }

    public SNumbers column(int indexInEachBlock) {
        return this.columnRange(indexInEachBlock, 1);
    }

    public SNumbers columnRange(int startIndexInEachBlock, int lengthInEachBlock) {
        SNumbers result = new SNumbers();
        result.replaceColumnRange(0, this, startIndexInEachBlock, lengthInEachBlock);
        return result;
    }

    public SNumbers columnsByIndexes(int[] columnsIndexes) {
        Objects.requireNonNull(columnsIndexes, "Null columnsIndexes");
        SNumbers result = columnsIndexes.length == 0 || !this.isInitialized() ? null : SNumbers.zeros(this.elementType(), this.n(), columnsIndexes.length);
        this.columnsByIndexes(result, null, columnsIndexes);
        return result;
    }

    public Object[] allColumnsArrays() {
        return this.columnRangeArrays(0, this.blockLength);
    }

    public Object[] columnRangeArrays(int startIndexInEachBlock, int lengthInEachBlock) {
        this.checkStartIndexAndLenthInBlock(startIndexInEachBlock, lengthInEachBlock, true);
        Object[] javaArrays = new Object[lengthInEachBlock];
        int[] columnsIndexes = new int[lengthInEachBlock];
        int n = this.n();
        Arrays.setAll(javaArrays, k -> this.newCompatibleJavaArray(n));
        Arrays.setAll(columnsIndexes, k -> startIndexInEachBlock + k);
        this.columnsByIndexes(null, javaArrays, columnsIndexes);
        return javaArrays;
    }

    public void columnsByIndexes(Object[] javaArraysForResultColumns, int[] columnsIndexes) {
        Objects.requireNonNull(javaArraysForResultColumns, "Null javaArraysForResultColumns");
        Objects.requireNonNull(columnsIndexes, "Null columnsIndexes");
        this.columnsByIndexes(null, javaArraysForResultColumns, columnsIndexes);
    }

    public void columnsByIndexes(SNumbers result, Object[] javaArraysForResultColumns, int[] columnsIndexes) {
        Objects.requireNonNull(columnsIndexes, "Null columnsIndexes");
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot extract columns from uninitialized numbers array");
        }
        int[] indexes = (int[])columnsIndexes.clone();
        this.checkColumnIndexes(indexes);
        int resultBlockLength = this.checkMulticolumnResult(result, indexes);
        if (resultBlockLength == 0) {
            return;
        }
        Object[] columns = javaArraysForResultColumns == null ? null : (Object[])javaArraysForResultColumns.clone();
        Object[] necessaryColumns = new Object[indexes.length];
        int[] necessaryColumnsIndexes = new int[indexes.length];
        int necessaryColumnsCount = this.checkColumns(necessaryColumns, necessaryColumnsIndexes, indexes, columns);
        assert (necessaryColumnsCount == 0 || columns != null) : "necessaryColumnsCount must be 0 if columns==null";
        if (result == null && necessaryColumnsCount == 0) {
            return;
        }
        int n = this.n();
        if (this.isByteArray()) {
            byte[] a = (byte[])this.array;
            byte[][] c = new byte[necessaryColumnsCount][];
            Arrays.setAll(c, k -> (byte[])necessaryColumns[k]);
            if (indexes.length == 1) {
                byte[] r;
                assert (result != null || Arrays.equals(indexes, necessaryColumnsIndexes));
                byte[] byArray = r = result != null ? (byte[])result.array : c[0];
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength + indexes[0];
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int j = fromInThis;
                    int i = from * resultBlockLength;
                    while (j < toInThis) {
                        r[i] = a[j];
                        j += jInc;
                        ++i;
                    }
                });
                if (result != null && necessaryColumnsCount > 0) {
                    assert (necessaryColumnsCount == 1);
                    System.arraycopy(r, 0, c[0], 0, n);
                }
            } else if (necessaryColumnsCount == 0) {
                byte[] r = (byte[])result.array;
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength;
                    int toInThis = to * this.blockLength;
                    int i = from * resultBlockLength;
                    for (int j = fromInThis; j < toInThis; j += jInc) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                    }
                });
            } else if (result == null) {
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else if (necessaryColumnsCount == indexes.length) {
                assert (Arrays.equals(indexes, necessaryColumnsIndexes));
                byte[] r = (byte[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            int n2 = i++;
                            byte by = a[j + necessaryColumnsIndexes[cIndex]];
                            c[cIndex][k] = by;
                            r[n2] = by;
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else {
                byte[] r = (byte[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            }
            return;
        }
        if (this.isShortArray()) {
            short[] a = (short[])this.array;
            short[][] c = new short[necessaryColumnsCount][];
            Arrays.setAll(c, k -> (short[])necessaryColumns[k]);
            if (indexes.length == 1) {
                short[] r;
                assert (result != null || Arrays.equals(indexes, necessaryColumnsIndexes));
                short[] sArray = r = result != null ? (short[])result.array : c[0];
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength + indexes[0];
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int j = fromInThis;
                    int i = from * resultBlockLength;
                    while (j < toInThis) {
                        r[i] = a[j];
                        j += jInc;
                        ++i;
                    }
                });
                if (result != null && necessaryColumnsCount > 0) {
                    assert (necessaryColumnsCount == 1);
                    System.arraycopy(r, 0, c[0], 0, n);
                }
            } else if (necessaryColumnsCount == 0) {
                short[] r = (short[])result.array;
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength;
                    int toInThis = to * this.blockLength;
                    int i = from * resultBlockLength;
                    for (int j = fromInThis; j < toInThis; j += jInc) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                    }
                });
            } else if (result == null) {
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else if (necessaryColumnsCount == indexes.length) {
                assert (Arrays.equals(indexes, necessaryColumnsIndexes));
                short[] r = (short[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            int n2 = i++;
                            short s = a[j + necessaryColumnsIndexes[cIndex]];
                            c[cIndex][k] = s;
                            r[n2] = s;
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else {
                short[] r = (short[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            }
            return;
        }
        if (this.isIntArray()) {
            int[] a = (int[])this.array;
            int[][] c = new int[necessaryColumnsCount][];
            Arrays.setAll(c, k -> (int[])necessaryColumns[k]);
            if (indexes.length == 1) {
                int[] r;
                assert (result != null || Arrays.equals(indexes, necessaryColumnsIndexes));
                int[] nArray = r = result != null ? (int[])result.array : c[0];
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength + indexes[0];
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int j = fromInThis;
                    int i = from * resultBlockLength;
                    while (j < toInThis) {
                        r[i] = a[j];
                        j += jInc;
                        ++i;
                    }
                });
                if (result != null && necessaryColumnsCount > 0) {
                    assert (necessaryColumnsCount == 1);
                    System.arraycopy(r, 0, c[0], 0, n);
                }
            } else if (necessaryColumnsCount == 0) {
                int[] r = (int[])result.array;
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength;
                    int toInThis = to * this.blockLength;
                    int i = from * resultBlockLength;
                    for (int j = fromInThis; j < toInThis; j += jInc) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                    }
                });
            } else if (result == null) {
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else if (necessaryColumnsCount == indexes.length) {
                assert (Arrays.equals(indexes, necessaryColumnsIndexes));
                int[] r = (int[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            int n2 = i++;
                            int n3 = a[j + necessaryColumnsIndexes[cIndex]];
                            c[cIndex][k] = n3;
                            r[n2] = n3;
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else {
                int[] r = (int[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            }
            return;
        }
        if (this.isLongArray()) {
            long[] a = (long[])this.array;
            long[][] c = new long[necessaryColumnsCount][];
            Arrays.setAll(c, k -> (long[])necessaryColumns[k]);
            if (indexes.length == 1) {
                long[] r;
                assert (result != null || Arrays.equals(indexes, necessaryColumnsIndexes));
                long[] lArray = r = result != null ? (long[])result.array : c[0];
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength + indexes[0];
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int j = fromInThis;
                    int i = from * resultBlockLength;
                    while (j < toInThis) {
                        r[i] = a[j];
                        j += jInc;
                        ++i;
                    }
                });
                if (result != null && necessaryColumnsCount > 0) {
                    assert (necessaryColumnsCount == 1);
                    System.arraycopy(r, 0, c[0], 0, n);
                }
            } else if (necessaryColumnsCount == 0) {
                long[] r = (long[])result.array;
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength;
                    int toInThis = to * this.blockLength;
                    int i = from * resultBlockLength;
                    for (int j = fromInThis; j < toInThis; j += jInc) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                    }
                });
            } else if (result == null) {
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else if (necessaryColumnsCount == indexes.length) {
                assert (Arrays.equals(indexes, necessaryColumnsIndexes));
                long[] r = (long[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            int n2 = i++;
                            long l = a[j + necessaryColumnsIndexes[cIndex]];
                            c[cIndex][k] = l;
                            r[n2] = l;
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else {
                long[] r = (long[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            }
            return;
        }
        if (this.isFloatArray()) {
            float[] a = (float[])this.array;
            float[][] c = new float[necessaryColumnsCount][];
            Arrays.setAll(c, k -> (float[])necessaryColumns[k]);
            if (indexes.length == 1) {
                float[] r;
                assert (result != null || Arrays.equals(indexes, necessaryColumnsIndexes));
                float[] fArray = r = result != null ? (float[])result.array : c[0];
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength + indexes[0];
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int j = fromInThis;
                    int i = from * resultBlockLength;
                    while (j < toInThis) {
                        r[i] = a[j];
                        j += jInc;
                        ++i;
                    }
                });
                if (result != null && necessaryColumnsCount > 0) {
                    assert (necessaryColumnsCount == 1);
                    System.arraycopy(r, 0, c[0], 0, n);
                }
            } else if (necessaryColumnsCount == 0) {
                float[] r = (float[])result.array;
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength;
                    int toInThis = to * this.blockLength;
                    int i = from * resultBlockLength;
                    for (int j = fromInThis; j < toInThis; j += jInc) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                    }
                });
            } else if (result == null) {
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else if (necessaryColumnsCount == indexes.length) {
                assert (Arrays.equals(indexes, necessaryColumnsIndexes));
                float[] r = (float[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            int n2 = i++;
                            float f = a[j + necessaryColumnsIndexes[cIndex]];
                            c[cIndex][k] = f;
                            r[n2] = f;
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else {
                float[] r = (float[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            }
            return;
        }
        if (this.isDoubleArray()) {
            double[] a = (double[])this.array;
            double[][] c = new double[necessaryColumnsCount][];
            Arrays.setAll(c, k -> (double[])necessaryColumns[k]);
            if (indexes.length == 1) {
                double[] r;
                assert (result != null || Arrays.equals(indexes, necessaryColumnsIndexes));
                double[] dArray = r = result != null ? (double[])result.array : c[0];
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength + indexes[0];
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int j = fromInThis;
                    int i = from * resultBlockLength;
                    while (j < toInThis) {
                        r[i] = a[j];
                        j += jInc;
                        ++i;
                    }
                });
                if (result != null && necessaryColumnsCount > 0) {
                    assert (necessaryColumnsCount == 1);
                    System.arraycopy(r, 0, c[0], 0, n);
                }
            } else if (necessaryColumnsCount == 0) {
                double[] r = (double[])result.array;
                assert (r != null) : "checking, that nothing to do, has failed";
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = from * this.blockLength;
                    int toInThis = to * this.blockLength;
                    int i = from * resultBlockLength;
                    for (int j = fromInThis; j < toInThis; j += jInc) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                    }
                });
            } else if (result == null) {
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else if (necessaryColumnsCount == indexes.length) {
                assert (Arrays.equals(indexes, necessaryColumnsIndexes));
                double[] r = (double[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            int n2 = i++;
                            double d = a[j + necessaryColumnsIndexes[cIndex]];
                            c[cIndex][k] = d;
                            r[n2] = d;
                        }
                        ++k;
                        j += jInc;
                    }
                });
            } else {
                double[] r = (double[])result.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int k = block << 8;
                    int to = (int)Math.min((long)k + 256L, (long)n);
                    int jInc = this.blockLength;
                    int fromInThis = k * this.blockLength;
                    int count = necessaryColumnsCount;
                    int j = fromInThis;
                    int i = k * resultBlockLength;
                    while (k < to) {
                        for (int index : indexes) {
                            r[i++] = a[j + index];
                        }
                        for (int cIndex = 0; cIndex < count; ++cIndex) {
                            c[cIndex][k] = a[j + necessaryColumnsIndexes[cIndex]];
                        }
                        ++k;
                        j += jInc;
                    }
                });
            }
            return;
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public SNumbers blockRange(int startBlockIndex, int numberOfBlocks) {
        SNumbers result = new SNumbers();
        result.replaceBlockRange(0, this, startBlockIndex, numberOfBlocks);
        return result;
    }

    public SNumbers selectBlockSet(BitArray selector) {
        Objects.requireNonNull(selector, "Null selector");
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot select blocks in uninitialized numbers array");
        }
        int n = this.n();
        if (selector.length() < (long)n) {
            throw new IllegalArgumentException("Not enough length of bit array: " + selector.length() + "<" + n);
        }
        if (selector.length() > (long)n) {
            selector = (BitArray)selector.subArray(0L, (long)n);
        }
        SNumbers result = SNumbers.zeros(this.elementType(), (int)net.algart.arrays.Arrays.cardinality((BitArray)selector), this.blockLength);
        if (this.isByteArray()) {
            byte[] r = (byte[])result.array;
            byte[] a = (byte[])this.array;
            int disp = 0;
            int dispResult = 0;
            for (int k = 0; k < n; ++k) {
                if (selector.getBit((long)k)) {
                    int dispTo = disp + this.blockLength;
                    while (disp < dispTo) {
                        r[dispResult] = a[disp];
                        ++disp;
                        ++dispResult;
                    }
                    continue;
                }
                disp += this.blockLength;
            }
        } else if (this.isShortArray()) {
            short[] r = (short[])result.array;
            short[] a = (short[])this.array;
            int disp = 0;
            int dispResult = 0;
            for (int k = 0; k < n; ++k) {
                if (selector.getBit((long)k)) {
                    int dispTo = disp + this.blockLength;
                    while (disp < dispTo) {
                        r[dispResult] = a[disp];
                        ++disp;
                        ++dispResult;
                    }
                    continue;
                }
                disp += this.blockLength;
            }
        } else if (this.isIntArray()) {
            int[] r = (int[])result.array;
            int[] a = (int[])this.array;
            int disp = 0;
            int dispResult = 0;
            for (int k = 0; k < n; ++k) {
                if (selector.getBit((long)k)) {
                    int dispTo = disp + this.blockLength;
                    while (disp < dispTo) {
                        r[dispResult] = a[disp];
                        ++disp;
                        ++dispResult;
                    }
                    continue;
                }
                disp += this.blockLength;
            }
        } else if (this.isLongArray()) {
            long[] r = (long[])result.array;
            long[] a = (long[])this.array;
            int disp = 0;
            int dispResult = 0;
            for (int k = 0; k < n; ++k) {
                if (selector.getBit((long)k)) {
                    int dispTo = disp + this.blockLength;
                    while (disp < dispTo) {
                        r[dispResult] = a[disp];
                        ++disp;
                        ++dispResult;
                    }
                    continue;
                }
                disp += this.blockLength;
            }
        } else if (this.isFloatArray()) {
            float[] r = (float[])result.array;
            float[] a = (float[])this.array;
            int disp = 0;
            int dispResult = 0;
            for (int k = 0; k < n; ++k) {
                if (selector.getBit((long)k)) {
                    int dispTo = disp + this.blockLength;
                    while (disp < dispTo) {
                        r[dispResult] = a[disp];
                        ++disp;
                        ++dispResult;
                    }
                    continue;
                }
                disp += this.blockLength;
            }
        } else if (this.isDoubleArray()) {
            double[] r = (double[])result.array;
            double[] a = (double[])this.array;
            int disp = 0;
            int dispResult = 0;
            for (int k = 0; k < n; ++k) {
                if (selector.getBit((long)k)) {
                    int dispTo = disp + this.blockLength;
                    while (disp < dispTo) {
                        r[dispResult] = a[disp];
                        ++disp;
                        ++dispResult;
                    }
                    continue;
                }
                disp += this.blockLength;
            }
        } else {
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this)));
        }
        return result;
    }

    public SNumbers setPrecision(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (elementType == this.elementType()) {
            return this;
        }
        if (elementType == Byte.TYPE) {
            return this.setToArray(this.toByteArray(), this.blockLength, false);
        }
        if (elementType == Short.TYPE) {
            return this.setToArray(this.toShortArray(), this.blockLength, false);
        }
        if (elementType == Integer.TYPE) {
            return this.setToArray(this.toIntArray(), this.blockLength, false);
        }
        if (elementType == Long.TYPE) {
            return this.setToArray(this.toLongArray(), this.blockLength, false);
        }
        if (elementType == Float.TYPE) {
            return this.setToArray(this.toFloatArray(), this.blockLength, false);
        }
        if (elementType == Double.TYPE) {
            return this.setToArray(this.toDoubleArray(), this.blockLength, false);
        }
        throw new IllegalArgumentException("The element type " + String.valueOf(elementType) + " is not supported");
    }

    public SNumbers toPrecision(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (elementType == Byte.TYPE) {
            return new SNumbers().setToArray(this.toByteArray(), this.blockLength, false);
        }
        if (elementType == Short.TYPE) {
            return new SNumbers().setToArray(this.toShortArray(), this.blockLength, false);
        }
        if (elementType == Integer.TYPE) {
            return new SNumbers().setToArray(this.toIntArray(), this.blockLength, false);
        }
        if (elementType == Long.TYPE) {
            return new SNumbers().setToArray(this.toLongArray(), this.blockLength, false);
        }
        if (elementType == Float.TYPE) {
            return new SNumbers().setToArray(this.toFloatArray(), this.blockLength, false);
        }
        if (elementType == Double.TYPE) {
            return new SNumbers().setToArray(this.toDoubleArray(), this.blockLength, false);
        }
        throw new IllegalArgumentException("The element type " + String.valueOf(elementType) + " is not supported");
    }

    public boolean isFloatingPoint() {
        return this.isFloatArray() || this.isDoubleArray();
    }

    public boolean isInteger() {
        return !this.isFloatingPoint();
    }

    public boolean isInteger(boolean includingLong64) {
        return this.isByteArray() || this.isShortArray() || this.isIntArray() || includingLong64 && this.isLongArray();
    }

    @Override
    public DataType type() {
        return DataType.NUMBERS;
    }

    public double min() {
        return this.min(false);
    }

    public double min(boolean onlyFinite) {
        return this.minInRange(0, this.n(), 0, this.blockLength, onlyFinite);
    }

    public double minInColumnRange(int indexInBlock, int lengthInBlock, boolean onlyFinite) {
        return this.minInRange(0, this.n(), indexInBlock, lengthInBlock, onlyFinite);
    }

    public double minInRange(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock, boolean onlyFinite) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array has no initialized data");
        }
        if (blockIndex < 0) {
            throw new IllegalArgumentException("Negative block index: " + blockIndex);
        }
        if (blockIndex + numberOfBlocks > this.n()) {
            throw new IllegalArgumentException("Start block index and number of blocks = " + blockIndex + " and " + this.blockLength + " are out of range 0..n-1 = 0.." + (this.n() - 1));
        }
        this.checkStartIndexAndLenthInBlock(indexInBlock, lengthInBlock, true);
        if (this.isByteArray()) {
            return this.minBytesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isShortArray()) {
            return this.minShortsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isIntArray()) {
            return this.minIntsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isLongArray()) {
            return this.minLongsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isFloatArray()) {
            return onlyFinite ? this.minFiniteFloatsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock) : this.minFloatsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isDoubleArray()) {
            return onlyFinite ? this.minFiniteDoublesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock) : this.minDoublesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public double max() {
        return this.max(false);
    }

    public double max(boolean onlyFinite) {
        return this.maxInRange(0, this.n(), 0, this.blockLength, onlyFinite);
    }

    public double maxInColumnRange(int indexInBlock, int lengthInBlock, boolean onlyFinite) {
        return this.maxInRange(0, this.n(), indexInBlock, lengthInBlock, onlyFinite);
    }

    public double maxInRange(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock, boolean onlyFinite) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array has no initialized data");
        }
        if (blockIndex < 0) {
            throw new IllegalArgumentException("Negative block index: " + blockIndex);
        }
        if (blockIndex + numberOfBlocks > this.n()) {
            throw new IllegalArgumentException("Start block index and number of blocks = " + blockIndex + " and " + this.blockLength + " are out of range 0..n-1 = 0.." + (this.n() - 1));
        }
        this.checkStartIndexAndLenthInBlock(indexInBlock, lengthInBlock, true);
        if (this.isByteArray()) {
            return this.maxBytesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isShortArray()) {
            return this.maxShortsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isIntArray()) {
            return this.maxIntsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isLongArray()) {
            return this.maxLongsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isFloatArray()) {
            return onlyFinite ? this.maxFiniteFloatsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock) : this.maxFloatsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isDoubleArray()) {
            return onlyFinite ? this.maxFiniteDoublesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock) : this.maxDoublesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    public double maxAbs() {
        return this.maxAbs(false);
    }

    public double maxAbs(boolean onlyFinite) {
        return this.maxAbsInRange(0, this.n(), 0, this.blockLength, onlyFinite);
    }

    public double maxAbsInColumnRange(int indexInBlock, int lengthInBlock, boolean onlyFinite) {
        return this.maxAbsInRange(0, this.n(), indexInBlock, lengthInBlock, onlyFinite);
    }

    public double maxAbsInRange(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock, boolean onlyFinite) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array has no initialized data");
        }
        if (blockIndex < 0) {
            throw new IllegalArgumentException("Negative block index: " + blockIndex);
        }
        if (blockIndex + numberOfBlocks > this.n()) {
            throw new IllegalArgumentException("Start block index and number of blocks = " + blockIndex + " and " + this.blockLength + " are out of range 0..n-1 = 0.." + (this.n() - 1));
        }
        this.checkStartIndexAndLenthInBlock(indexInBlock, lengthInBlock, true);
        if (this.isByteArray()) {
            return this.maxBytesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isShortArray()) {
            return this.maxShortsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isIntArray()) {
            return this.maxAbsIntsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isLongArray()) {
            return this.maxAbsLongsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isFloatArray()) {
            return onlyFinite ? this.maxAbsFiniteFloatsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock) : this.maxAbsFloatsParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        if (this.isDoubleArray()) {
            return onlyFinite ? this.maxAbsFiniteDoublesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock) : this.maxAbsDoublesParallel(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(this.array)));
    }

    @Override
    public void setTo(Data other, boolean cloneData) {
        if (other instanceof SNumbers) {
            this.setToIdentical((SNumbers)other, cloneData);
        } else if (other instanceof SScalar) {
            this.setArray(((SScalar)other).toDoubles());
        } else {
            throw new IllegalArgumentException("Cannot assign " + String.valueOf(other.getClass()) + " to " + String.valueOf(this.getClass()));
        }
    }

    @Override
    public SNumbers exchange(Data other) {
        Objects.requireNonNull(other, "Null other objects");
        if (!(other instanceof SNumbers)) {
            throw new IllegalArgumentException("Cannot exchange with another data type: " + String.valueOf(other.getClass()));
        }
        return this.exchange((SNumbers)other);
    }

    public SNumbers exchange(SNumbers other) {
        Objects.requireNonNull(other, "Null other numbers");
        long tempFlags = this.flags;
        Object tempArray = this.array;
        int tempBlockLength = this.blockLength;
        this.flags = other.flags;
        this.array = other.array;
        this.blockLength = other.blockLength;
        other.flags = tempFlags;
        other.array = tempArray;
        other.blockLength = tempBlockLength;
        return this;
    }

    public SNumbers setTo(SNumbers dataNumbers) {
        return this.setToIdentical(dataNumbers, true);
    }

    public SNumbers setToColumnRange(SNumbers otherNumbers, int startIndexInEachBlockOfOther, int lengthInEachBlock) {
        this.replaceColumnRange(0, otherNumbers, startIndexInEachBlockOfOther, lengthInEachBlock, true);
        return this;
    }

    public SNumbers setToSingleBlock(SNumbers dataNumbers, int blockIndex) {
        Objects.requireNonNull(dataNumbers, "Null dataNumbers");
        if (!dataNumbers.isInitialized()) {
            throw new IllegalArgumentException("Cannot extract block from uninitialized numbers array");
        }
        if (blockIndex < 0 || blockIndex >= dataNumbers.n()) {
            throw new IndexOutOfBoundsException("Index of the block = " + blockIndex + " is out of range 0..n()-1 = 0.." + (dataNumbers.n() - 1));
        }
        this.blockLength = dataNumbers.blockLength;
        this.array = Array.newInstance(dataNumbers.elementType(), dataNumbers.blockLength);
        System.arraycopy(dataNumbers.array, blockIndex * dataNumbers.blockLength, this.array, 0, dataNumbers.blockLength);
        this.setInitializedAndResetFlags(true);
        return this;
    }

    public void replaceColumnRange(int startIndexInThis, SNumbers otherNumbers, int startIndexInOther, int lengthInEachBlock) {
        this.replaceColumnRange(startIndexInThis, otherNumbers, startIndexInOther, lengthInEachBlock, false);
    }

    public void replaceBlockRange(int startBlockIndexInThis, SNumbers otherNumbers, int startBlockIndexInOther, int numberOfReplacedBlocks) {
        Class<?> elementType;
        if (startBlockIndexInThis < 0) {
            throw new IllegalArgumentException("Negative start block index in this array: " + startBlockIndexInThis);
        }
        Objects.requireNonNull(otherNumbers, "Null otherNumbers");
        if (!otherNumbers.isInitialized()) {
            throw new IllegalArgumentException("Cannot extract blocks from uninitialized numbers array");
        }
        if (numberOfReplacedBlocks < 0) {
            throw new IndexOutOfBoundsException("Negative number of blocks: " + numberOfReplacedBlocks);
        }
        if (startBlockIndexInOther < 0 || startBlockIndexInOther + numberOfReplacedBlocks > otherNumbers.n()) {
            throw new IndexOutOfBoundsException("Start block index and number of blocks = " + startBlockIndexInOther + " and " + numberOfReplacedBlocks + " (range " + startBlockIndexInOther + ".." + (startBlockIndexInOther + numberOfReplacedBlocks - 1) + ") are out of range 0..n-1 = 0.." + (otherNumbers.n() - 1));
        }
        if (!this.isInitialized()) {
            if (startBlockIndexInThis == 0) {
                this.setToZeros(otherNumbers.elementType(), numberOfReplacedBlocks, otherNumbers.blockLength);
            } else {
                throw new IllegalStateException("Cannot replace blocks in uninitialized numbers array");
            }
        }
        if ((elementType = this.elementType()) != otherNumbers.elementType()) {
            throw new IllegalArgumentException("Element type mismatch: cannot assign " + String.valueOf(otherNumbers.elementType()) + "[] to " + String.valueOf(elementType) + "[]");
        }
        if (this.blockLength != otherNumbers.blockLength) {
            throw new IllegalArgumentException("Block lengths mismatch: this array contains " + this.blockLength + " columns, but the other contains " + otherNumbers.blockLength + " columns");
        }
        assert (numberOfReplacedBlocks <= otherNumbers.n());
        int newN = Math.max(this.n(), startBlockIndexInThis + numberOfReplacedBlocks);
        if (newN > this.n()) {
            SNumbers result = SNumbers.zeros(elementType, newN, this.blockLength);
            result.replaceBlockRange(0, this, 0, this.n());
            this.setToIdentical(result, false);
        }
        assert (numberOfReplacedBlocks <= this.n());
        assert (this.isInitialized());
        assert (this.blockLength == otherNumbers.blockLength);
        System.arraycopy(otherNumbers.array, startBlockIndexInOther * this.blockLength, this.array, startBlockIndexInThis * this.blockLength, numberOfReplacedBlocks * this.blockLength);
    }

    public SNumbers setTo(byte[] javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength);
    }

    public SNumbers setTo(short[] javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength);
    }

    public SNumbers setTo(int[] javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength);
    }

    public SNumbers setTo(long[] javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength);
    }

    public SNumbers setTo(float[] javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength);
    }

    public SNumbers setTo(double[] javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength);
    }

    public SNumbers setTo(ByteBuffer byteBuffer, Class<?> elementType, int blockLength) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        Objects.requireNonNull(elementType, "Null elementType");
        if (elementType == Byte.TYPE) {
            return this.setTo(SNumbers.byteBufferToBytes(byteBuffer), blockLength);
        }
        if (elementType == Short.TYPE) {
            return this.setTo(SNumbers.byteBufferToShorts(byteBuffer), blockLength);
        }
        if (elementType == Integer.TYPE) {
            return this.setTo(SNumbers.byteBufferToInts(byteBuffer), blockLength);
        }
        if (elementType == Long.TYPE) {
            return this.setTo(SNumbers.byteBufferToLongs(byteBuffer), blockLength);
        }
        if (elementType == Float.TYPE) {
            return this.setTo(SNumbers.byteBufferToFloats(byteBuffer), blockLength);
        }
        if (elementType == Double.TYPE) {
            return this.setTo(SNumbers.byteBufferToDoubles(byteBuffer), blockLength);
        }
        throw new IllegalArgumentException("The element type is not byte, short, int, long, float or double (it is " + String.valueOf(elementType) + ")");
    }

    public SNumbers setTo(PNumberArray array, int blockLength) {
        Objects.requireNonNull(array, "Null array");
        if (!SNumbers.isElementTypeSupported(array.elementType())) {
            throw new IllegalArgumentException("The element type of passed array is not supported (it is " + String.valueOf(array) + ")");
        }
        return this.setToArray(array.toJavaArray(), blockLength, false);
    }

    public SNumbers setTo(IPoint point) {
        Objects.requireNonNull(point, "Null point");
        return this.setToArray(point.coordinates(), 1, false);
    }

    public SNumbers setTo(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area");
        long[] array = new long[2 * area.coordCount()];
        int k = 0;
        int i = 0;
        while (i < array.length) {
            array[i++] = area.min(k);
            array[i++] = area.max(k);
            ++k;
        }
        return this.setToArray(array, 2, false);
    }

    public SNumbers setToOrRemove(IRectangularArea area) {
        if (area == null) {
            this.remove();
            return this;
        }
        return this.setTo(area);
    }

    public SNumbers setTo(Point point) {
        Objects.requireNonNull(point, "Null point");
        return this.setToArray(point.coordinates(), 1, false);
    }

    public SNumbers setTo(RectangularArea area) {
        Objects.requireNonNull(area, "Null area");
        double[] array = new double[2 * area.coordCount()];
        int k = 0;
        int i = 0;
        while (i < array.length) {
            array[i++] = area.min(k);
            array[i++] = area.max(k);
            ++k;
        }
        return this.setToArray(array, 2, false);
    }

    public SNumbers setToOrRemove(RectangularArea area) {
        if (area == null) {
            this.remove();
            return this;
        }
        return this.setTo(area);
    }

    public SNumbers setTo(Contours contours) {
        Objects.requireNonNull(contours, "Null contours");
        this.setToArray(contours.serialize(), 2, false);
        return this;
    }

    public SNumbers setTo(Collection<?> numbers, int blockLength) {
        Objects.requireNonNull(numbers, "Null numbers");
        int size = numbers.size();
        if (size == 0) {
            return this.setToZeros(Float.TYPE, 0, blockLength);
        }
        if (size % blockLength != 0) {
            throw new IllegalArgumentException("List size " + size + " is not divisible by block length " + blockLength);
        }
        Object array = SNumbers.convertToArray(numbers);
        return this.setToArray(array, blockLength);
    }

    public SNumbers setToArray(Object javaArray, int blockLength) {
        return this.setToArray(javaArray, blockLength, true);
    }

    public SNumbers setToZeros(String elementTypeName, int n, int blockLength) {
        return this.setToZeros(SNumbers.elementType(elementTypeName), n, blockLength);
    }

    public SNumbers setToZeros(Class<?> elementType, int n, int blockLength) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (!SNumbers.isElementTypeSupported(elementType)) {
            throw new IllegalArgumentException("The element type is not byte, short, int, long, float or double (it is " + String.valueOf(elementType) + ")");
        }
        SNumbers.checkDimensions(n, blockLength);
        Object javaArray = Array.newInstance(elementType, n * blockLength);
        this.setArray(javaArray);
        this.setBlockLength(blockLength);
        return this;
    }

    public Object newCompatibleJavaArray(int arrayLength) {
        return Array.newInstance(this.elementType(), arrayLength);
    }

    public SNumbers requireInitialized(String name) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array \"" + name + "\" has no initialized data");
        }
        return this;
    }

    public SNumbers requireBlockLengthOne(String name) {
        return this.requireBlockLength(1, name);
    }

    public SNumbers requireBlockLength(int blockLength, String name) {
        if (this.isInitialized() && this.blockLength != blockLength) {
            throw new IllegalStateException("Numbers array \"" + name + "\" has invalid block length " + this.blockLength + " (" + blockLength + " elements per block required)");
        }
        return this;
    }

    public boolean checkStartIndexAndLenthInBlock(int startIndexInEachBlock, int lengthInEachBlock, boolean strictlyInside) {
        if (!this.isInitialized()) {
            throw new IllegalArgumentException("Cannot process uninitialized numbers array");
        }
        if (lengthInEachBlock < 0) {
            throw new IndexOutOfBoundsException("Negative length inside the block: " + lengthInEachBlock);
        }
        if (startIndexInEachBlock < 0) {
            throw new IndexOutOfBoundsException("Negative start index inside the block: " + startIndexInEachBlock);
        }
        if (startIndexInEachBlock + lengthInEachBlock > this.blockLength) {
            if (strictlyInside) {
                throw new IndexOutOfBoundsException("Start index and length inside the block = " + startIndexInEachBlock + " and " + lengthInEachBlock + " (range " + startIndexInEachBlock + ".." + (startIndexInEachBlock + lengthInEachBlock - 1) + ") are out of range 0..blockLength-1 = 0.." + (this.blockLength - 1));
            }
            return false;
        }
        return true;
    }

    public Formatter getFormatter(FormattingType formattingType, Locale locale) {
        Objects.requireNonNull(formattingType, "Null formatter type");
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot call getFormatter(): numbers array is not initialized");
        }
        return new Formatter(formattingType, locale);
    }

    public String toFormattedString(FormattingType formattingType, Locale locale, String format, String elementsDelimiter) {
        return this.getFormatter(formattingType, locale).setElementsFormat(format).setElementsDelimiter(elementsDelimiter).format();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeNumbersInResults) {
        if (!this.isInitialized()) {
            return super.toString();
        }
        if (includeNumbersInResults) {
            StringBuilder sb = new StringBuilder();
            if (this.isFloatingPoint()) {
                double[] a = this.toDoubleArray();
                if (a == null) {
                    return super.toString();
                }
                for (int k = 0; k < a.length; ++k) {
                    if (k > 0) {
                        sb.append(k % this.blockLength == 0 ? "\n" : ", ");
                    }
                    sb.append(a[k]);
                }
            } else {
                long[] a = this.toLongArray();
                if (a == null) {
                    return super.toString();
                }
                for (int k = 0; k < a.length; ++k) {
                    if (k > 0) {
                        sb.append(k % this.blockLength == 0 ? "\n" : ", ");
                    }
                    sb.append(a[k]);
                }
            }
            return sb.toString();
        }
        return super.toString() + " " + String.valueOf(this.elementType()) + "[" + this.blockLength + "*" + this.n() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SNumbers numbers = (SNumbers)o;
        int arrayLength = this.getArrayLength();
        return this.blockLength == numbers.blockLength && arrayLength == numbers.getArrayLength() && (this.array == numbers.array || this.array != null && JArrays.arrayEquals((Object)this.array, (int)0, (Object)numbers.array, (int)0, (int)arrayLength));
    }

    public int hashCode() {
        int hash = this.isByteArray() ? Arrays.hashCode((byte[])this.array) : (this.isShortArray() ? Arrays.hashCode((short[])this.array) : (this.isIntArray() ? Arrays.hashCode((int[])this.array) : (this.isLongArray() ? Arrays.hashCode((long[])this.array) : (this.isFloatArray() ? Arrays.hashCode((float[])this.array) : (this.isDoubleArray() ? Arrays.hashCode((double[])this.array) : 0)))));
        return ((this.isInitialized() ? this.elementType().hashCode() : 1352) ^ hash) * 31 + (this.blockLength ^ 0x26D);
    }

    @Override
    public SNumbers clone() {
        return new SNumbers().setTo(this);
    }

    public static SNumbers of(IPoint point) {
        return new SNumbers().setTo(point);
    }

    public static SNumbers of(IRectangularArea area) {
        return new SNumbers().setTo(area);
    }

    public static SNumbers of(Point point) {
        return new SNumbers().setTo(point);
    }

    public static SNumbers of(RectangularArea area) {
        return new SNumbers().setTo(area);
    }

    public static SNumbers of(Contours contours) {
        return new SNumbers().setTo(contours);
    }

    public static SNumbers of(Collection<?> numbers, int blockLength) {
        return new SNumbers().setTo(numbers, blockLength);
    }

    public static SNumbers ofArray(Object javaArray) {
        return SNumbers.ofArray(javaArray, 1);
    }

    public static SNumbers ofArray(Object javaArray, int blockLength) {
        return new SNumbers().setToArray(javaArray, blockLength);
    }

    public static SNumbers arrayAsNumbers(Object javaArray, int blockLength) {
        return new SNumbers().setToArray(javaArray, blockLength, false);
    }

    public static SNumbers zeros(String elementTypeName, int n, int blockLength) {
        return new SNumbers().setToZeros(elementTypeName, n, blockLength);
    }

    public static SNumbers zeros(Class<?> elementType, int n, int blockLength) {
        return new SNumbers().setToZeros(elementType, n, blockLength);
    }

    public static void checkDimensions(long n, long blockLength) {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative n (number of blocks");
        }
        if (blockLength <= 0L) {
            throw new IllegalArgumentException("Block length " + blockLength + " is not positive");
        }
        if (n > Integer.MAX_VALUE || blockLength > Integer.MAX_VALUE || n * blockLength > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large required array: more that 2^31-1 elements");
        }
    }

    public static ByteBuffer bytesToByteBuffer(byte[] data) {
        return SNumbers.bytesToByteBuffer(data, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer bytesToByteBuffer(byte[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.order(order);
        byteBuffer.put(data);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] byteBufferToBytes(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        byte[] result = new byte[byteBuffer.capacity()];
        byteBuffer.rewind();
        byteBuffer.get(result);
        return result;
    }

    public static ByteBuffer shortsToByteBuffer(short[] data) {
        return SNumbers.shortsToByteBuffer(data, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer shortsToByteBuffer(short[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * data.length);
        byteBuffer.order(order);
        byteBuffer.asShortBuffer().put(data);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] shortsToBytes(short[] data) {
        return SNumbers.shortsToBytes(data, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] shortsToBytes(short[] data, ByteOrder order) {
        ByteBuffer byteBuffer = SNumbers.shortsToByteBuffer(data, order);
        byte[] result = new byte[2 * data.length];
        byteBuffer.get(result);
        return result;
    }

    public static short[] byteBufferToShorts(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        if (byteBuffer.capacity() % 2 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + byteBuffer.capacity() + " is not divisible by 2");
        }
        short[] result = new short[byteBuffer.capacity() / 2];
        byteBuffer.rewind();
        byteBuffer.asShortBuffer().get(result);
        return result;
    }

    public static short[] bytesToShorts(byte[] data) {
        return SNumbers.bytesToShorts(data, ByteOrder.BIG_ENDIAN);
    }

    public static short[] bytesToShorts(byte[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + data.length + " is not divisible by 2");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.order(order);
        byteBuffer.put(data);
        return SNumbers.byteBufferToShorts(byteBuffer);
    }

    public static ByteBuffer intsToByteBuffer(int[] data) {
        return SNumbers.intsToByteBuffer(data, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer intsToByteBuffer(int[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4 * data.length);
        byteBuffer.order(order);
        byteBuffer.asIntBuffer().put(data);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] intsToBytes(int[] data) {
        return SNumbers.intsToBytes(data, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] intsToBytes(int[] data, ByteOrder order) {
        ByteBuffer byteBuffer = SNumbers.intsToByteBuffer(data, order);
        byte[] result = new byte[4 * data.length];
        byteBuffer.get(result);
        return result;
    }

    public static int[] byteBufferToInts(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        if (byteBuffer.capacity() % 4 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + byteBuffer.capacity() + " is not divisible by 4");
        }
        int[] result = new int[byteBuffer.capacity() / 4];
        byteBuffer.rewind();
        byteBuffer.asIntBuffer().get(result);
        return result;
    }

    public static int[] bytesToInts(byte[] data) {
        return SNumbers.bytesToInts(data, ByteOrder.BIG_ENDIAN);
    }

    public static int[] bytesToInts(byte[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        if (data.length % 4 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + data.length + " is not divisible by 4");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.order(order);
        byteBuffer.put(data);
        return SNumbers.byteBufferToInts(byteBuffer);
    }

    public static ByteBuffer longsToByteBuffer(long[] data) {
        return SNumbers.longsToByteBuffer(data, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer longsToByteBuffer(long[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8 * data.length);
        byteBuffer.order(order);
        byteBuffer.asLongBuffer().put(data);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] longsToBytes(long[] data) {
        return SNumbers.longsToBytes(data, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] longsToBytes(long[] data, ByteOrder order) {
        ByteBuffer byteBuffer = SNumbers.longsToByteBuffer(data, order);
        byte[] result = new byte[8 * data.length];
        byteBuffer.get(result);
        return result;
    }

    public static long[] byteBufferToLongs(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        if (byteBuffer.capacity() % 8 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + byteBuffer.capacity() + " is not divisible by 8");
        }
        long[] result = new long[byteBuffer.capacity() / 8];
        byteBuffer.rewind();
        byteBuffer.asLongBuffer().get(result);
        return result;
    }

    public static long[] bytesToLongs(byte[] data) {
        return SNumbers.bytesToLongs(data, ByteOrder.BIG_ENDIAN);
    }

    public static long[] bytesToLongs(byte[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        if (data.length % 8 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + data.length + " is not divisible by 8");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.order(order);
        byteBuffer.put(data);
        return SNumbers.byteBufferToLongs(byteBuffer);
    }

    public static ByteBuffer floatsToByteBuffer(float[] data) {
        return SNumbers.floatsToByteBuffer(data, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer floatsToByteBuffer(float[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4 * data.length);
        byteBuffer.order(order);
        byteBuffer.asFloatBuffer().put(data);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] floatsToBytes(float[] data) {
        return SNumbers.floatsToBytes(data, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] floatsToBytes(float[] data, ByteOrder order) {
        ByteBuffer byteBuffer = SNumbers.floatsToByteBuffer(data, order);
        byte[] result = new byte[4 * data.length];
        byteBuffer.get(result);
        return result;
    }

    public static float[] byteBufferToFloats(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        if (byteBuffer.capacity() % 4 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + byteBuffer.capacity() + " is not divisible by 4");
        }
        float[] result = new float[byteBuffer.capacity() / 4];
        byteBuffer.rewind();
        byteBuffer.asFloatBuffer().get(result);
        return result;
    }

    public static float[] bytesToFloats(byte[] data) {
        return SNumbers.bytesToFloats(data, ByteOrder.BIG_ENDIAN);
    }

    public static float[] bytesToFloats(byte[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        if (data.length % 4 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + data.length + " is not divisible by 4");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.order(order);
        byteBuffer.put(data);
        return SNumbers.byteBufferToFloats(byteBuffer);
    }

    public static ByteBuffer doublesToByteBuffer(double[] data) {
        return SNumbers.doublesToByteBuffer(data, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer doublesToByteBuffer(double[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8 * data.length);
        byteBuffer.order(order);
        byteBuffer.asDoubleBuffer().put(data);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] doublesToBytes(double[] data) {
        return SNumbers.doublesToBytes(data, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] doublesToBytes(double[] data, ByteOrder order) {
        ByteBuffer byteBuffer = SNumbers.doublesToByteBuffer(data, order);
        byte[] result = new byte[8 * data.length];
        byteBuffer.get(result);
        return result;
    }

    public static double[] byteBufferToDoubles(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        if (byteBuffer.capacity() % 8 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + byteBuffer.capacity() + " is not divisible by 8");
        }
        double[] result = new double[byteBuffer.capacity() / 8];
        byteBuffer.rewind();
        byteBuffer.asDoubleBuffer().get(result);
        return result;
    }

    public static double[] bytesToDoubles(byte[] data) {
        return SNumbers.bytesToDoubles(data, ByteOrder.BIG_ENDIAN);
    }

    public static double[] bytesToDoubles(byte[] data, ByteOrder order) {
        Objects.requireNonNull(data, "Null data array");
        Objects.requireNonNull(order, "Null byte order");
        if (data.length % 8 != 0) {
            throw new IllegalArgumentException("Illegal data: number of bytes " + data.length + " is not divisible by 8");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.order(order);
        byteBuffer.put(data);
        return SNumbers.byteBufferToDoubles(byteBuffer);
    }

    @Override
    protected void freeResources() {
        this.array = null;
    }

    @UsedForExternalCommunication
    private void setArray(Object javaArray) {
        Objects.requireNonNull(javaArray, "Null java array");
        if (!SNumbers.isJavaArraySupported(javaArray)) {
            throw new IllegalArgumentException("The passed java-array argument is not byte[], short[], int[], long[], float[] or double[] (it is " + javaArray.getClass().getSimpleName() + ")");
        }
        this.array = javaArray;
        this.setInitializedAndResetFlags(true);
    }

    private SNumbers setToArray(Object javaArray, int blockLength, boolean doClone) {
        Objects.requireNonNull(javaArray, "Null java array");
        if (blockLength <= 0) {
            throw new IllegalArgumentException("Block length " + blockLength + " is not positive");
        }
        if (!SNumbers.isJavaArraySupported(javaArray)) {
            throw new IllegalArgumentException("The passed java-array argument is not byte[], short[], int[], long[], float[] or double[] (it is " + javaArray.getClass().getSimpleName() + ")");
        }
        if (Array.getLength(javaArray) % blockLength != 0) {
            throw new IllegalArgumentException("Java array length " + Array.getLength(javaArray) + " is not divisible by block length " + blockLength);
        }
        this.setArray(doClone ? SNumbers.cloneJavaArray(javaArray) : javaArray);
        this.setBlockLength(blockLength);
        return this;
    }

    private SNumbers setToIdentical(SNumbers dataNumbers, boolean doClone) {
        Objects.requireNonNull(dataNumbers, "Null dataNumbers");
        this.array = doClone && dataNumbers.isInitialized() ? SNumbers.cloneJavaArray(dataNumbers.array) : dataNumbers.array;
        this.blockLength = dataNumbers.blockLength;
        this.flags = dataNumbers.flags;
        this.setInitialized(dataNumbers.isInitialized());
        return this;
    }

    private void checkGetSetIndex(int blockIndex, int indexInBlock, int lengthInBlock) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Numbers array is not initialized");
        }
        if (indexInBlock < 0 || indexInBlock >= this.blockLength) {
            throw new IndexOutOfBoundsException("Index in block = " + indexInBlock + " is out of range 0..blockLength-1 = 0.." + (this.blockLength - 1));
        }
        if (lengthInBlock < 0) {
            throw new IllegalArgumentException("Negative length in block = " + lengthInBlock);
        }
        if (indexInBlock + lengthInBlock > this.blockLength) {
            throw new IndexOutOfBoundsException("Index in block + length in block = " + (indexInBlock + lengthInBlock) + " is out of range 0..blockLength = 0.." + this.blockLength);
        }
        if (blockIndex < 0 || (long)blockIndex * (long)this.blockLength >= (long)Array.getLength(this.array)) {
            throw new IndexOutOfBoundsException("Index of the block = " + blockIndex + " is out of range 0..n()-1 = 0.." + (this.n() - 1));
        }
    }

    private void checkColumnIndexes(int[] indexes) {
        for (int j = 0; j < indexes.length; ++j) {
            if (indexes[j] >= 0 && indexes[j] < this.blockLength) continue;
            throw new IndexOutOfBoundsException("Index " + indexes[j] + " of the column #" + j + " is out of range 0..blockLength-1=" + (this.blockLength - 1));
        }
    }

    private int checkMulticolumnResult(SNumbers result, int[] indexes) {
        if (result != null) {
            if (!result.isInitialized()) {
                if (indexes.length > 0) {
                    result.setToZeros(this.elementType(), this.n(), indexes.length);
                }
            } else {
                if (this.elementType() != result.elementType()) {
                    throw new IllegalArgumentException("Element type mismatch: cannot assign " + String.valueOf(this.elementType()) + "[] to " + String.valueOf(result.elementType()) + "[]");
                }
                if (this.n() != result.n()) {
                    throw new IllegalArgumentException("Array lengths mismatch: this array contains " + this.n() + " blocks, but the result contains " + result.n() + " blocks");
                }
                if (result.blockLength != indexes.length) {
                    throw new IllegalArgumentException("Number of columns in the result " + result.blockLength + " is not equal to number of column indexes " + indexes.length);
                }
            }
        }
        return indexes.length;
    }

    private int checkColumns(Object[] resultColumns, int[] resultIndexes, int[] indexes, Object[] columns) {
        Class<?> elementType = this.elementType();
        int n = this.n();
        int count = 0;
        if (columns != null) {
            for (int j = 0; j < indexes.length; ++j) {
                if (j >= columns.length || columns[j] == null) continue;
                Class<?> componentType = columns[j].getClass().getComponentType();
                if (componentType == null) {
                    throw new IllegalArgumentException("javaArraysForResultColumns[" + j + "] is not a Java array");
                }
                if (componentType != elementType) {
                    throw new IllegalArgumentException("javaArraysForResultColumns[" + j + "] is " + componentType.getCanonicalName() + "[] array instead of required " + elementType.getCanonicalName() + "[] array");
                }
                if (Array.getLength(columns[j]) < n) {
                    throw new IllegalArgumentException("Too short passed array javaArraysForResultColumns[" + j + "]: only " + Array.getLength(columns[j]) + " elements, but at least " + n + " elements required");
                }
                resultColumns[count] = columns[j];
                resultIndexes[count] = indexes[j];
                ++count;
            }
        }
        return count;
    }

    private void replaceColumnRange(int startIndexInThis, SNumbers otherNumbers, int startIndexInOther, int lengthInEachBlock, boolean reinitialize) {
        Class<?> elementType;
        if (startIndexInThis < 0) {
            throw new IllegalArgumentException("Negative start index in this array: " + startIndexInOther);
        }
        if (!otherNumbers.checkStartIndexAndLenthInBlock(startIndexInOther, lengthInEachBlock, false)) {
            int newBlockLength = startIndexInOther + lengthInEachBlock;
            SNumbers expanded = SNumbers.zeros(otherNumbers.elementType(), otherNumbers.n(), newBlockLength);
            expanded.replaceColumnRange(0, otherNumbers, 0, otherNumbers.blockLength);
            otherNumbers = expanded;
        }
        if (reinitialize || !this.isInitialized()) {
            if (startIndexInThis == 0) {
                this.setToZeros(otherNumbers.elementType(), otherNumbers.n(), lengthInEachBlock);
            } else {
                throw new IllegalStateException("Cannot replace columns from non-zero index " + startIndexInOther + " in uninitialized numbers array");
            }
        }
        if ((elementType = this.elementType()) != otherNumbers.elementType()) {
            throw new IllegalArgumentException("Element type mismatch: cannot assign " + String.valueOf(otherNumbers.elementType()) + "[] to " + String.valueOf(elementType) + "[]");
        }
        int n = this.n();
        if (n != otherNumbers.n()) {
            throw new IllegalArgumentException("Array lengths mismatch: this array contains " + n + " blocks, but the other contains " + otherNumbers.n() + " blocks");
        }
        assert (lengthInEachBlock <= otherNumbers.blockLength) : "Error in checkStartIndexAndLenthInBlock";
        int newBlockLength = Math.max(this.blockLength, startIndexInThis + lengthInEachBlock);
        if (newBlockLength > this.blockLength) {
            SNumbers result = SNumbers.zeros(elementType, n, newBlockLength);
            result.replaceColumnRange(0, this, 0, this.blockLength);
            this.setToIdentical(result, false);
        }
        assert (lengthInEachBlock <= this.blockLength);
        assert (this.isInitialized());
        int otherBlockLength = otherNumbers.blockLength;
        if (lengthInEachBlock != this.blockLength || lengthInEachBlock != otherNumbers.blockLength) {
            if (lengthInEachBlock == 1) {
                if (otherNumbers.isByteArray()) {
                    byte[] result = (byte[])this.array;
                    byte[] a = (byte[])otherNumbers.array;
                    IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                        int from = block << 8;
                        int to = (int)Math.min((long)from + 256L, (long)n);
                        int iInc = this.blockLength;
                        int jInc = otherBlockLength;
                        int fromInThis = startIndexInThis + from * this.blockLength;
                        int toInThis = fromInThis + (to - from) * this.blockLength;
                        int fromInOther = startIndexInOther + from * otherBlockLength;
                        int i = fromInThis;
                        int j = fromInOther;
                        while (i < toInThis) {
                            result[i] = a[j];
                            i += iInc;
                            j += jInc;
                        }
                    });
                    this.array = result;
                    return;
                }
                if (otherNumbers.isShortArray()) {
                    short[] result = (short[])this.array;
                    short[] a = (short[])otherNumbers.array;
                    IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                        int from = block << 8;
                        int to = (int)Math.min((long)from + 256L, (long)n);
                        int iInc = this.blockLength;
                        int jInc = otherBlockLength;
                        int fromInThis = startIndexInThis + from * this.blockLength;
                        int toInThis = fromInThis + (to - from) * this.blockLength;
                        int fromInOther = startIndexInOther + from * otherBlockLength;
                        int i = fromInThis;
                        int j = fromInOther;
                        while (i < toInThis) {
                            result[i] = a[j];
                            i += iInc;
                            j += jInc;
                        }
                    });
                    this.array = result;
                    return;
                }
                if (otherNumbers.isIntArray()) {
                    int[] result = (int[])this.array;
                    int[] a = (int[])otherNumbers.array;
                    IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                        int from = block << 8;
                        int to = (int)Math.min((long)from + 256L, (long)n);
                        int iInc = this.blockLength;
                        int jInc = otherBlockLength;
                        int fromInThis = startIndexInThis + from * this.blockLength;
                        int toInThis = fromInThis + (to - from) * this.blockLength;
                        int fromInOther = startIndexInOther + from * otherBlockLength;
                        int i = fromInThis;
                        int j = fromInOther;
                        while (i < toInThis) {
                            result[i] = a[j];
                            i += iInc;
                            j += jInc;
                        }
                    });
                    this.array = result;
                    return;
                }
                if (otherNumbers.isLongArray()) {
                    long[] result = (long[])this.array;
                    long[] a = (long[])otherNumbers.array;
                    IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                        int from = block << 8;
                        int to = (int)Math.min((long)from + 256L, (long)n);
                        int iInc = this.blockLength;
                        int jInc = otherBlockLength;
                        int fromInThis = startIndexInThis + from * this.blockLength;
                        int toInThis = fromInThis + (to - from) * this.blockLength;
                        int fromInOther = startIndexInOther + from * otherBlockLength;
                        int i = fromInThis;
                        int j = fromInOther;
                        while (i < toInThis) {
                            result[i] = a[j];
                            i += iInc;
                            j += jInc;
                        }
                    });
                    this.array = result;
                    return;
                }
                if (otherNumbers.isFloatArray()) {
                    float[] result = (float[])this.array;
                    float[] a = (float[])otherNumbers.array;
                    IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                        int from = block << 8;
                        int to = (int)Math.min((long)from + 256L, (long)n);
                        int iInc = this.blockLength;
                        int jInc = otherBlockLength;
                        int fromInThis = startIndexInThis + from * this.blockLength;
                        int toInThis = fromInThis + (to - from) * this.blockLength;
                        int fromInOther = startIndexInOther + from * otherBlockLength;
                        int i = fromInThis;
                        int j = fromInOther;
                        while (i < toInThis) {
                            result[i] = a[j];
                            i += iInc;
                            j += jInc;
                        }
                    });
                    this.array = result;
                    return;
                }
                if (otherNumbers.isDoubleArray()) {
                    double[] result = (double[])this.array;
                    double[] a = (double[])otherNumbers.array;
                    IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                        int from = block << 8;
                        int to = (int)Math.min((long)from + 256L, (long)n);
                        int iInc = this.blockLength;
                        int jInc = otherBlockLength;
                        int fromInThis = startIndexInThis + from * this.blockLength;
                        int toInThis = fromInThis + (to - from) * this.blockLength;
                        int fromInOther = startIndexInOther + from * otherBlockLength;
                        int i = fromInThis;
                        int j = fromInOther;
                        while (i < toInThis) {
                            result[i] = a[j];
                            i += iInc;
                            j += jInc;
                        }
                    });
                    this.array = result;
                    return;
                }
                throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(otherNumbers)));
            }
            if (otherNumbers.isByteArray()) {
                byte[] result = (byte[])this.array;
                byte[] a = (byte[])otherNumbers.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int iInc = this.blockLength - lengthInEachBlock;
                    int jInc = otherBlockLength - lengthInEachBlock;
                    int length = lengthInEachBlock;
                    int fromInThis = startIndexInThis + from * this.blockLength;
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int fromInOther = startIndexInOther + from * otherBlockLength;
                    int i = fromInThis;
                    int j = fromInOther;
                    while (i < toInThis) {
                        int iTo = i + length;
                        while (i < iTo) {
                            result[i++] = a[j++];
                        }
                        i += iInc;
                        j += jInc;
                    }
                });
                this.array = result;
                return;
            }
            if (otherNumbers.isShortArray()) {
                short[] result = (short[])this.array;
                short[] a = (short[])otherNumbers.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int iInc = this.blockLength - lengthInEachBlock;
                    int jInc = otherBlockLength - lengthInEachBlock;
                    int length = lengthInEachBlock;
                    int fromInThis = startIndexInThis + from * this.blockLength;
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int fromInOther = startIndexInOther + from * otherBlockLength;
                    int i = fromInThis;
                    int j = fromInOther;
                    while (i < toInThis) {
                        int iTo = i + length;
                        while (i < iTo) {
                            result[i++] = a[j++];
                        }
                        i += iInc;
                        j += jInc;
                    }
                });
                this.array = result;
                return;
            }
            if (otherNumbers.isIntArray()) {
                int[] result = (int[])this.array;
                int[] a = (int[])otherNumbers.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int iInc = this.blockLength - lengthInEachBlock;
                    int jInc = otherBlockLength - lengthInEachBlock;
                    int length = lengthInEachBlock;
                    int fromInThis = startIndexInThis + from * this.blockLength;
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int fromInOther = startIndexInOther + from * otherBlockLength;
                    int i = fromInThis;
                    int j = fromInOther;
                    while (i < toInThis) {
                        int iTo = i + length;
                        while (i < iTo) {
                            result[i++] = a[j++];
                        }
                        i += iInc;
                        j += jInc;
                    }
                });
                this.array = result;
                return;
            }
            if (otherNumbers.isLongArray()) {
                long[] result = (long[])this.array;
                long[] a = (long[])otherNumbers.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int iInc = this.blockLength - lengthInEachBlock;
                    int jInc = otherBlockLength - lengthInEachBlock;
                    int length = lengthInEachBlock;
                    int fromInThis = startIndexInThis + from * this.blockLength;
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int fromInOther = startIndexInOther + from * otherBlockLength;
                    int i = fromInThis;
                    int j = fromInOther;
                    while (i < toInThis) {
                        int iTo = i + length;
                        while (i < iTo) {
                            result[i++] = a[j++];
                        }
                        i += iInc;
                        j += jInc;
                    }
                });
                this.array = result;
                return;
            }
            if (otherNumbers.isFloatArray()) {
                float[] result = (float[])this.array;
                float[] a = (float[])otherNumbers.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int iInc = this.blockLength - lengthInEachBlock;
                    int jInc = otherBlockLength - lengthInEachBlock;
                    int length = lengthInEachBlock;
                    int fromInThis = startIndexInThis + from * this.blockLength;
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int fromInOther = startIndexInOther + from * otherBlockLength;
                    int i = fromInThis;
                    int j = fromInOther;
                    while (i < toInThis) {
                        int iTo = i + length;
                        while (i < iTo) {
                            result[i++] = a[j++];
                        }
                        i += iInc;
                        j += jInc;
                    }
                });
                this.array = result;
                return;
            }
            if (otherNumbers.isDoubleArray()) {
                double[] result = (double[])this.array;
                double[] a = (double[])otherNumbers.array;
                IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
                    int from = block << 8;
                    int to = (int)Math.min((long)from + 256L, (long)n);
                    int iInc = this.blockLength - lengthInEachBlock;
                    int jInc = otherBlockLength - lengthInEachBlock;
                    int length = lengthInEachBlock;
                    int fromInThis = startIndexInThis + from * this.blockLength;
                    int toInThis = fromInThis + (to - from) * this.blockLength;
                    int fromInOther = startIndexInOther + from * otherBlockLength;
                    int i = fromInThis;
                    int j = fromInOther;
                    while (i < toInThis) {
                        int iTo = i + length;
                        while (i < iTo) {
                            result[i++] = a[j++];
                        }
                        i += iInc;
                        j += jInc;
                    }
                });
                this.array = result;
                return;
            }
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(otherNumbers)));
        }
        System.arraycopy(otherNumbers.array, 0, this.array, 0, this.getArrayLength());
    }

    private double minBytesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minBytes(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minBytes(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minBytes(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minBytes(int blockIndex, int numberOfBlocks) {
        int i;
        byte[] array = (byte[])this.array;
        int min = Integer.MAX_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = array[i] & 0xFF;
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private double minBytes(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        byte[] array = (byte[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int min = Integer.MAX_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = array[disp] & 0xFF;
                if (value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxBytesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxBytes(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxBytes(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxBytes(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxBytes(int blockIndex, int numberOfBlocks) {
        int i;
        byte[] array = (byte[])this.array;
        int max = Integer.MIN_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = array[i] & 0xFF;
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private double maxBytes(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        byte[] array = (byte[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int max = Integer.MIN_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = array[disp] & 0xFF;
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minShortsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minShorts(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minShorts(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minShorts(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minShorts(int blockIndex, int numberOfBlocks) {
        int i;
        short[] array = (short[])this.array;
        int min = Integer.MAX_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = array[i] & 0xFFFF;
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private double minShorts(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        short[] array = (short[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int min = Integer.MAX_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = array[disp] & 0xFFFF;
                if (value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxShortsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxShorts(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxShorts(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxShorts(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxShorts(int blockIndex, int numberOfBlocks) {
        int i;
        short[] array = (short[])this.array;
        int max = Integer.MIN_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = array[i] & 0xFFFF;
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private double maxShorts(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        short[] array = (short[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int max = Integer.MIN_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = array[disp] & 0xFFFF;
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minIntsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minInts(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minInts(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minInts(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minInts(int blockIndex, int numberOfBlocks) {
        int i;
        int[] array = (int[])this.array;
        int min = Integer.MAX_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = array[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private double minInts(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        int[] array = (int[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int min = Integer.MAX_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = array[disp];
                if (value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxIntsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxInts(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxInts(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxInts(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxInts(int blockIndex, int numberOfBlocks) {
        int i;
        int[] array = (int[])this.array;
        int max = Integer.MIN_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = array[i];
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private double maxInts(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        int[] array = (int[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int max = Integer.MIN_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = array[disp];
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double maxAbsIntsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxAbsInts(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsInts(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsInts(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxAbsInts(int blockIndex, int numberOfBlocks) {
        int i;
        int[] array = (int[])this.array;
        int max = Integer.MIN_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            int value = Math.abs(array[i]);
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private double maxAbsInts(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        int[] array = (int[])this.array;
        int increment = this.blockLength - lengthInBlock;
        int max = Integer.MIN_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                int value = Math.abs(array[disp]);
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minLongsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minLongs(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minLongs(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minLongs(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minLongs(int blockIndex, int numberOfBlocks) {
        int i;
        long[] array = (long[])this.array;
        long min = Long.MAX_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            long value = array[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private double minLongs(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        long[] array = (long[])this.array;
        int increment = this.blockLength - lengthInBlock;
        long min = Long.MAX_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                long value = array[disp];
                if (value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxLongsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxLongs(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxLongs(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxLongs(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxLongs(int blockIndex, int numberOfBlocks) {
        int i;
        long[] array = (long[])this.array;
        long max = Long.MIN_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            long value = array[i];
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private double maxLongs(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        long[] array = (long[])this.array;
        int increment = this.blockLength - lengthInBlock;
        long max = Long.MIN_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                long value = array[disp];
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double maxAbsLongsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxAbsLongs(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsLongs(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsLongs(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxAbsLongs(int blockIndex, int numberOfBlocks) {
        int i;
        long[] array = (long[])this.array;
        long max = Long.MIN_VALUE;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            long value = Math.abs(array[i]);
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private double maxAbsLongs(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        long[] array = (long[])this.array;
        int increment = this.blockLength - lengthInBlock;
        long max = Long.MIN_VALUE;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                long value = Math.abs(array[disp]);
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minFloatsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minFloats(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minFloats(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minFloats(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minFloats(int blockIndex, int numberOfBlocks) {
        int i;
        float[] array = (float[])this.array;
        double min = Double.POSITIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    private double minFloats(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        float[] array = (float[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double min = Double.POSITIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxFloatsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxFloats(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxFloats(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxFloats(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxFloats(int blockIndex, int numberOfBlocks) {
        int i;
        float[] array = (float[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxFloats(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        float[] array = (float[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double maxAbsFloatsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxAbsFloats(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsFloats(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsFloats(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxAbsFloats(int blockIndex, int numberOfBlocks) {
        int i;
        float[] array = (float[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = Math.abs(array[i]);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxAbsFloats(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        float[] array = (float[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = Math.abs(array[disp]);
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minDoublesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minDoubles(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minDoubles(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minDoubles(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minDoubles(int blockIndex, int numberOfBlocks) {
        int i;
        double[] array = (double[])this.array;
        double min = Double.POSITIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    private double minDoubles(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        double[] array = (double[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double min = Double.POSITIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxDoublesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxDoubles(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxDoubles(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxDoubles(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxDoubles(int blockIndex, int numberOfBlocks) {
        int i;
        double[] array = (double[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxDoubles(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        double[] array = (double[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double maxAbsDoublesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxAbsDoubles(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsDoubles(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsDoubles(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxAbsDoubles(int blockIndex, int numberOfBlocks) {
        int i;
        double[] array = (double[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = Math.abs(array[i]);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxAbsDoubles(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        double[] array = (double[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = Math.abs(array[disp]);
                if (value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minFiniteFloatsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minFiniteFloats(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minFiniteFloats(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minFiniteFloats(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minFiniteFloats(int blockIndex, int numberOfBlocks) {
        int i;
        float[] array = (float[])this.array;
        double min = Double.POSITIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!Double.isFinite(value) || !(value < min)) continue;
            min = value;
        }
        return min;
    }

    private double minFiniteFloats(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        float[] array = (float[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double min = Double.POSITIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (Double.isFinite(value) && value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxFiniteFloatsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxFiniteFloats(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxFiniteFloats(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxFiniteFloats(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxFiniteFloats(int blockIndex, int numberOfBlocks) {
        int i;
        float[] array = (float[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!Double.isFinite(value) || !(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxFiniteFloats(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        float[] array = (float[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (Double.isFinite(value) && value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double maxAbsFiniteFloatsParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxAbsFiniteFloats(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsFiniteFloats(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsFiniteFloats(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxAbsFiniteFloats(int blockIndex, int numberOfBlocks) {
        int i;
        float[] array = (float[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = Math.abs(array[i]);
            if (!(value <= Double.MAX_VALUE) || !(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxAbsFiniteFloats(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        float[] array = (float[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = Math.abs(array[disp]);
                if (value <= Double.MAX_VALUE && value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double minFiniteDoublesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.minFiniteDoubles(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minFiniteDoubles(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.minFiniteDoubles(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).min().orElse(Double.POSITIVE_INFINITY);
    }

    private double minFiniteDoubles(int blockIndex, int numberOfBlocks) {
        int i;
        double[] array = (double[])this.array;
        double min = Double.POSITIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!Double.isFinite(value) || !(value < min)) continue;
            min = value;
        }
        return min;
    }

    private double minFiniteDoubles(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        double[] array = (double[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double min = Double.POSITIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (Double.isFinite(value) && value < min) {
                    min = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return min;
    }

    private double maxFiniteDoublesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxFiniteDoubles(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxFiniteDoubles(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxFiniteDoubles(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxFiniteDoubles(int blockIndex, int numberOfBlocks) {
        int i;
        double[] array = (double[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = array[i];
            if (!Double.isFinite(value) || !(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxFiniteDoubles(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        double[] array = (double[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = array[disp];
                if (Double.isFinite(value) && value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private double maxAbsFiniteDoublesParallel(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        if (numberOfBlocks < 256) {
            return this.maxAbsFiniteDoubles(blockIndex, numberOfBlocks, indexInBlock, lengthInBlock);
        }
        return IntStream.range(0, numberOfBlocks + 256 - 1 >>> 8).parallel().mapToDouble(indexInBlock == 0 && lengthInBlock == this.blockLength ? block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsFiniteDoubles(from + blockIndex, size);
        } : block -> {
            int from = block << 8;
            int size = Math.min(256, numberOfBlocks - from);
            return this.maxAbsFiniteDoubles(from + blockIndex, size, indexInBlock, lengthInBlock);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private double maxAbsFiniteDoubles(int blockIndex, int numberOfBlocks) {
        int i;
        double[] array = (double[])this.array;
        double max = Double.NEGATIVE_INFINITY;
        int to = i + numberOfBlocks * this.blockLength;
        for (i = blockIndex * this.blockLength; i < to; ++i) {
            double value = Math.abs(array[i]);
            if (!(value <= Double.MAX_VALUE) || !(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double maxAbsFiniteDoubles(int blockIndex, int numberOfBlocks, int indexInBlock, int lengthInBlock) {
        double[] array = (double[])this.array;
        int increment = this.blockLength - lengthInBlock;
        double max = Double.NEGATIVE_INFINITY;
        int k = 0;
        int disp = blockIndex * this.blockLength + indexInBlock;
        while (k < numberOfBlocks) {
            int dispTo = disp + lengthInBlock;
            while (disp < dispTo) {
                double value = Math.abs(array[disp]);
                if (value <= Double.MAX_VALUE && value > max) {
                    max = value;
                }
                ++disp;
            }
            ++k;
            disp += increment;
        }
        return max;
    }

    private static char[] spaces(int numberOfSpaces) {
        if (numberOfSpaces < SPACES.length) {
            return SPACES[numberOfSpaces];
        }
        char[] spaces = new char[numberOfSpaces];
        Arrays.fill(spaces, ' ');
        return spaces;
    }

    private static int recommendedNumberOfRanges(int n) {
        int cpuCount = Arrays.SystemSettings.cpuCount();
        return cpuCount == 1 ? 1 : Math.min(n, 4 * cpuCount);
    }

    private static int[] splitToRanges(int n, int numberOfRanges) {
        int[] result = new int[numberOfRanges + 1];
        result[0] = 0;
        result[numberOfRanges] = n;
        for (int k = 1; k < numberOfRanges; ++k) {
            result[k] = (int)((double)n * (double)k / (double)numberOfRanges);
        }
        return result;
    }

    private static Object cloneJavaArray(Object value) {
        if (value == null) {
            return null;
        }
        int length = Array.getLength(value);
        Object result = Array.newInstance(value.getClass().getComponentType(), length);
        System.arraycopy(value, 0, result, 0, length);
        return result;
    }

    static {
        for (int k = 0; k < SPACES.length; ++k) {
            SNumbers.SPACES[k] = new char[k];
            Arrays.fill(SPACES[k], ' ');
        }
    }

    public class Formatter {
        private static final int MIN_NUMBER_FOR_PARALLEL = 4096;
        private final int n;
        private final int blockLength;
        private final FormattingType formattingType;
        private final Locale locale;
        String elementsFormat = "%s";
        private String elementsDelimiter = ", ";
        private int minimalElementLength = 0;
        private boolean addLineIndexes = false;
        private String lineIndexFormat = "%s";
        private String lineIndexDelimiter = ": ";
        private int minimalLineIndexLength = 0;
        private int lineIndexStart = 0;
        private String linesDelimiter = "\n";
        private boolean addEndingLinesDelimiter = true;
        private boolean simpleFormatForIntegers = false;
        private boolean parallelExecution = true;

        private Formatter(FormattingType formattingType, Locale locale) {
            this.formattingType = Objects.requireNonNull(formattingType, "Null formatter type");
            this.locale = locale;
            this.n = SNumbers.this.n();
            this.blockLength = SNumbers.this.blockLength();
        }

        public String getElementsFormat() {
            return this.elementsFormat;
        }

        public Formatter setElementsFormat(String elementsFormat) {
            this.elementsFormat = Objects.requireNonNull(elementsFormat, "Null elements format");
            return this;
        }

        public String getElementsDelimiter() {
            return this.elementsDelimiter;
        }

        public Formatter setElementsDelimiter(String elementsDelimiter) {
            this.elementsDelimiter = Objects.requireNonNull(elementsDelimiter, "Null elements delimiter");
            return this;
        }

        public int getMinimalElementLength() {
            return this.minimalElementLength;
        }

        public Formatter setMinimalElementLength(int minimalElementLength) {
            if (minimalElementLength < 0) {
                throw new IllegalArgumentException("Negative minimalElementLength = " + minimalElementLength);
            }
            this.minimalElementLength = minimalElementLength;
            return this;
        }

        public boolean isAddLineIndexes() {
            return this.addLineIndexes;
        }

        public Formatter setAddLineIndexes(boolean addLineIndexes) {
            this.addLineIndexes = addLineIndexes;
            return this;
        }

        public String getLineIndexFormat() {
            return this.lineIndexFormat;
        }

        public Formatter setLineIndexFormat(String lineIndexFormat) {
            this.lineIndexFormat = Objects.requireNonNull(lineIndexFormat, "Null line index format");
            return this;
        }

        public String getLineIndexDelimiter() {
            return this.lineIndexDelimiter;
        }

        public Formatter setLineIndexDelimiter(String lineIndexDelimiter) {
            this.lineIndexDelimiter = Objects.requireNonNull(lineIndexDelimiter, "Null line index delimiter");
            return this;
        }

        public int getMinimalLineIndexLength() {
            return this.minimalLineIndexLength;
        }

        public Formatter setMinimalLineIndexLength(int minimalLineIndexLength) {
            if (minimalLineIndexLength < 0) {
                throw new IllegalArgumentException("Negative minimalLineIndexLength = " + minimalLineIndexLength);
            }
            this.minimalLineIndexLength = minimalLineIndexLength;
            return this;
        }

        public int getLineIndexStart() {
            return this.lineIndexStart;
        }

        public Formatter setLineIndexStart(int lineIndexStart) {
            this.lineIndexStart = lineIndexStart;
            return this;
        }

        public Formatter setLinesDelimiter(String linesDelimiter) {
            this.linesDelimiter = Objects.requireNonNull(linesDelimiter, "Null lines delimiter");
            return this;
        }

        public boolean isAddEndingLinesDelimiter() {
            return this.addEndingLinesDelimiter;
        }

        public Formatter setAddEndingLinesDelimiter(boolean addEndingLinesDelimiter) {
            this.addEndingLinesDelimiter = addEndingLinesDelimiter;
            return this;
        }

        public boolean isSimpleFormatForIntegers() {
            return this.simpleFormatForIntegers;
        }

        public Formatter setSimpleFormatForIntegers(boolean simpleFormatForIntegers) {
            this.simpleFormatForIntegers = simpleFormatForIntegers;
            return this;
        }

        public boolean isParallelExecution() {
            return this.parallelExecution;
        }

        public Formatter setParallelExecution(boolean parallelExecution) {
            this.parallelExecution = parallelExecution;
            return this;
        }

        public String format() {
            return this.formatRange(0, this.n);
        }

        public String formatRange(int blockIndex, int numberOfBlocks) {
            String result;
            String string = result = this.parallelExecution ? this.parallelFormatRange(blockIndex, numberOfBlocks) : this.singleThreadFormatRange(blockIndex, numberOfBlocks);
            if (!this.addEndingLinesDelimiter && result.endsWith(this.linesDelimiter)) {
                result = result.substring(0, result.length() - this.linesDelimiter.length());
            }
            return result;
        }

        private String parallelFormatRange(int blockIndex, int numberOfBlocks) {
            if (blockIndex < 0) {
                throw new IllegalArgumentException("Negative block index: " + blockIndex);
            }
            if (blockIndex + numberOfBlocks > this.n) {
                throw new IllegalArgumentException("Start block index and number of blocks = " + blockIndex + " and " + this.blockLength + " are out of range 0..n-1 = 0.." + (this.n - 1));
            }
            if (numberOfBlocks < 4096) {
                return this.singleThreadFormatRange(blockIndex, numberOfBlocks);
            }
            int numberOfRanges = SNumbers.recommendedNumberOfRanges(numberOfBlocks);
            int[] splitters = SNumbers.splitToRanges(numberOfBlocks, numberOfRanges);
            return IntStream.range(0, numberOfRanges).parallel().mapToObj(rangeIndex -> {
                int from = splitters[rangeIndex];
                int to = splitters[rangeIndex + 1];
                return this.singleThreadFormatRange(from + blockIndex, to - from);
            }).collect(Collectors.joining());
        }

        private String singleThreadFormatRange(int blockIndex, int numberOfBlocks) {
            int k;
            int estimatedCapacity = 5 * this.blockLength * numberOfBlocks;
            ElementFormatter elementFormatter = this.elementFormatter(estimatedCapacity);
            int blockLengthM1 = this.blockLength - 1;
            int lineIndexStart = this.lineIndexStart;
            boolean addLineIndexes = this.addLineIndexes;
            int minimalLineIndexLength = this.minimalLineIndexLength;
            int minimalElementLength = this.minimalElementLength;
            int disp = k * this.blockLength;
            int kTo = k + numberOfBlocks;
            for (k = blockIndex; k < kTo; ++k) {
                int dispTo;
                if (addLineIndexes) {
                    if (minimalLineIndexLength > 0) {
                        elementFormatter.formatLineIndex(lineIndexStart + k, this.lineIndexDelimiter, minimalLineIndexLength);
                    } else {
                        elementFormatter.formatLineIndex(lineIndexStart + k, this.lineIndexDelimiter);
                    }
                }
                if (minimalElementLength > 0) {
                    dispTo = disp + blockLengthM1;
                    while (disp < dispTo) {
                        elementFormatter.formatElement(disp, this.elementsDelimiter, minimalElementLength);
                        ++disp;
                    }
                    elementFormatter.formatElement(disp++, this.linesDelimiter, minimalElementLength);
                    continue;
                }
                dispTo = disp + blockLengthM1;
                while (disp < dispTo) {
                    elementFormatter.formatElement(disp, this.elementsDelimiter);
                    ++disp;
                }
                elementFormatter.formatElement(disp++, this.linesDelimiter);
            }
            return elementFormatter.result();
        }

        private ElementFormatter elementFormatter(int estimatedCapacity) {
            if (this.simpleFormatForIntegers && !SNumbers.this.isFloatingPoint()) {
                return FormattingType.SIMPLE.elementFormatter(this, estimatedCapacity);
            }
            ElementFormatter formatter = this.formattingType.elementFormatter(this, estimatedCapacity);
            if (this.simpleFormatForIntegers) {
                if (SNumbers.this.isFloatArray()) {
                    return new SimpleForIntegersFloatsWrapper(SNumbers.this, formatter);
                }
                if (SNumbers.this.isDoubleArray()) {
                    return new SimpleForIntegersDoublesWrapper(SNumbers.this, formatter);
                }
                throw new AssertionError((Object)("Unsupported floating-point Java array type: " + String.valueOf(SNumbers.this.array)));
            }
            return formatter;
        }

        private ElementFormatter createSimpleElementFormatter(int estimatedCapacity) {
            if (SNumbers.this.isByteArray()) {
                return new SimpleBytesElementFormatter(SNumbers.this, estimatedCapacity);
            }
            if (SNumbers.this.isShortArray()) {
                return new SimpleShortsElementFormatter(SNumbers.this, estimatedCapacity);
            }
            if (SNumbers.this.isIntArray()) {
                return new SimpleIntsElementFormatter(SNumbers.this, estimatedCapacity);
            }
            if (SNumbers.this.isLongArray()) {
                return new SimpleLongsElementFormatter(SNumbers.this, estimatedCapacity);
            }
            if (SNumbers.this.isFloatArray()) {
                return new SimpleFloatsElementFormatter(SNumbers.this, estimatedCapacity);
            }
            if (SNumbers.this.isDoubleArray()) {
                return new SimpleDoublesElementFormatter(SNumbers.this, estimatedCapacity);
            }
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(SNumbers.this.array)));
        }

        private ElementFormatter createPrintfElementFormatter(int estimatedCapacity) {
            if (SNumbers.this.isByteArray()) {
                return new PrintfBytesElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isShortArray()) {
                return new PrintfShortsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isIntArray()) {
                return new PrintfIntsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isLongArray()) {
                return new PrintfLongsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isFloatArray()) {
                return new PrintfFloatsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isDoubleArray()) {
                return new PrintfDoublesElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(SNumbers.this.array)));
        }

        private ElementFormatter createDecimalElementFormatter(int estimatedCapacity) {
            if (SNumbers.this.isByteArray()) {
                return new DecimalBytesElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isShortArray()) {
                return new DecimalShortsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isIntArray()) {
                return new DecimalIntsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isLongArray()) {
                return new DecimalBytesElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isFloatArray()) {
                return new DecimalFloatsElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            if (SNumbers.this.isDoubleArray()) {
                return new DecimalDoublesElementFormatter(SNumbers.this, this, estimatedCapacity);
            }
            throw new AssertionError((Object)("Unsupported Java array type: " + String.valueOf(SNumbers.this.array)));
        }
    }

    public static enum FormattingType {
        SIMPLE(Formatter::createSimpleElementFormatter),
        PRINTF(Formatter::createPrintfElementFormatter),
        DECIMAL_FORMAT(Formatter::createDecimalElementFormatter);

        private final BiFunction<Formatter, Integer, ElementFormatter> creator;

        private FormattingType(BiFunction<Formatter, Integer, ElementFormatter> creator) {
            this.creator = creator;
        }

        ElementFormatter elementFormatter(Formatter formatter, int estimatedCapacity) {
            return this.creator.apply(formatter, estimatedCapacity);
        }
    }

    private final class SimpleForIntegersDoublesWrapper
    extends ElementFormatter {
        private final ElementFormatter parent;
        private final double[] array;

        private SimpleForIntegersDoublesWrapper(SNumbers sNumbers, ElementFormatter parent) {
            this.parent = parent;
            this.array = (double[])sNumbers.arrayReference();
        }

        @Override
        int length() {
            return this.parent.length();
        }

        @Override
        void append(String s) {
            this.parent.append(s);
        }

        @Override
        void insertSpaces(int position, int numberOfSpaces) {
            this.parent.insertSpaces(position, numberOfSpaces);
        }

        @Override
        void formatLineIndex(int index) {
            this.parent.append(String.valueOf(index));
        }

        @Override
        void formatElement(int disp) {
            double value = this.array[disp];
            long longValue = (long)value;
            if (value == (double)longValue) {
                this.parent.append(String.valueOf(longValue));
            } else {
                this.parent.formatElement(disp);
            }
        }

        @Override
        String result() {
            return this.parent.result();
        }
    }

    private final class SimpleForIntegersFloatsWrapper
    extends ElementFormatter {
        private final ElementFormatter parent;
        private final float[] array;

        private SimpleForIntegersFloatsWrapper(SNumbers sNumbers, ElementFormatter parent) {
            this.parent = parent;
            this.array = (float[])sNumbers.arrayReference();
        }

        @Override
        int length() {
            return this.parent.length();
        }

        @Override
        void append(String s) {
            this.parent.append(s);
        }

        @Override
        void insertSpaces(int position, int numberOfSpaces) {
            this.parent.insertSpaces(position, numberOfSpaces);
        }

        @Override
        void formatLineIndex(int index) {
            this.parent.append(String.valueOf(index));
        }

        @Override
        void formatElement(int disp) {
            double value = this.array[disp];
            long longValue = (long)value;
            if (value == (double)longValue) {
                this.parent.append(String.valueOf(longValue));
            } else {
                this.parent.formatElement(disp);
            }
        }

        @Override
        String result() {
            return this.parent.result();
        }
    }

    private final class DecimalDoublesElementFormatter
    extends DecimalElementFormatter {
        private final double[] array;

        private DecimalDoublesElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (double[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.elementsFormat.format(this.array[disp], this.out, this.dummy);
        }
    }

    private final class PrintfDoublesElementFormatter
    extends PrintfElementFormatter {
        private final double[] array;

        private PrintfDoublesElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (double[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.utilFormatter.format(this.elementsFormat, this.array[disp]);
        }
    }

    private final class SimpleDoublesElementFormatter
    extends SimpleElementFormatter {
        private final double[] array;

        private SimpleDoublesElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            super(sNumbers, estimatedCapacity);
            this.array = (double[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.out.append(this.array[disp]);
        }
    }

    private final class DecimalFloatsElementFormatter
    extends DecimalElementFormatter {
        private final float[] array;

        private DecimalFloatsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (float[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.elementsFormat.format((double)this.array[disp], this.out, this.dummy);
        }
    }

    private final class PrintfFloatsElementFormatter
    extends PrintfElementFormatter {
        private final float[] array;

        private PrintfFloatsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (float[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.utilFormatter.format(this.elementsFormat, Float.valueOf(this.array[disp]));
        }
    }

    private final class SimpleFloatsElementFormatter
    extends SimpleElementFormatter {
        private final float[] array;

        private SimpleFloatsElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            super(sNumbers, estimatedCapacity);
            this.array = (float[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.out.append(this.array[disp]);
        }
    }

    private final class DecimalLongsElementFormatter
    extends DecimalElementFormatter {
        private final long[] array;

        private DecimalLongsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (long[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.elementsFormat.format(this.array[disp], this.out, this.dummy);
        }
    }

    private final class PrintfLongsElementFormatter
    extends PrintfElementFormatter {
        private final long[] array;

        private PrintfLongsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (long[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.utilFormatter.format(this.elementsFormat, this.array[disp]);
        }
    }

    private final class SimpleLongsElementFormatter
    extends SimpleElementFormatter {
        private final long[] array;

        private SimpleLongsElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            super(sNumbers, estimatedCapacity);
            this.array = (long[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.out.append(this.array[disp]);
        }
    }

    private final class DecimalIntsElementFormatter
    extends DecimalElementFormatter {
        private final int[] array;

        private DecimalIntsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (int[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.elementsFormat.format((long)this.array[disp], this.out, this.dummy);
        }
    }

    private final class PrintfIntsElementFormatter
    extends PrintfElementFormatter {
        private final int[] array;

        private PrintfIntsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (int[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.utilFormatter.format(this.elementsFormat, this.array[disp]);
        }
    }

    private final class SimpleIntsElementFormatter
    extends SimpleElementFormatter {
        private final int[] array;

        private SimpleIntsElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            super(sNumbers, estimatedCapacity);
            this.array = (int[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.out.append(this.array[disp]);
        }
    }

    private final class DecimalShortsElementFormatter
    extends DecimalElementFormatter {
        private final short[] array;

        private DecimalShortsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (short[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.elementsFormat.format((long)(this.array[disp] & 0xFFFF), this.out, this.dummy);
        }
    }

    private final class PrintfShortsElementFormatter
    extends PrintfElementFormatter {
        private final short[] array;

        private PrintfShortsElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (short[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.utilFormatter.format(this.elementsFormat, this.array[disp] & 0xFFFF);
        }
    }

    private final class SimpleShortsElementFormatter
    extends SimpleElementFormatter {
        private final short[] array;

        private SimpleShortsElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            super(sNumbers, estimatedCapacity);
            this.array = (short[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.out.append(this.array[disp] & 0xFFFF);
        }
    }

    private final class DecimalBytesElementFormatter
    extends DecimalElementFormatter {
        private final byte[] array;

        private DecimalBytesElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (byte[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.elementsFormat.format((long)(this.array[disp] & 0xFF), this.out, this.dummy);
        }
    }

    private final class PrintfBytesElementFormatter
    extends PrintfElementFormatter {
        private final byte[] array;

        private PrintfBytesElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            super(sNumbers, formatter, estimatedCapacity);
            this.array = (byte[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.utilFormatter.format(this.elementsFormat, this.array[disp] & 0xFF);
        }
    }

    private final class SimpleBytesElementFormatter
    extends SimpleElementFormatter {
        private final byte[] array;

        private SimpleBytesElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            super(sNumbers, estimatedCapacity);
            this.array = (byte[])sNumbers.arrayReference();
        }

        @Override
        void formatElement(int disp) {
            this.out.append(this.array[disp] & 0xFF);
        }
    }

    private abstract class DecimalElementFormatter
    extends ElementFormatter {
        final StringBuffer out;
        final DecimalFormat lineIndexFormat;
        final DecimalFormat elementsFormat;
        final FieldPosition dummy;

        private DecimalElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            this.out = new StringBuffer(estimatedCapacity);
            if (formatter.locale == null) {
                this.lineIndexFormat = new DecimalFormat(formatter.lineIndexFormat);
                this.elementsFormat = new DecimalFormat(formatter.elementsFormat);
            } else {
                this.lineIndexFormat = new DecimalFormat(formatter.lineIndexFormat, DecimalFormatSymbols.getInstance(formatter.locale));
                this.elementsFormat = new DecimalFormat(formatter.elementsFormat, DecimalFormatSymbols.getInstance(formatter.locale));
            }
            this.dummy = new FieldPosition(0);
        }

        @Override
        int length() {
            return this.out.length();
        }

        @Override
        void append(String s) {
            this.out.append(s);
        }

        @Override
        void insertSpaces(int position, int numberOfSpaces) {
            this.out.insert(position, SNumbers.spaces(numberOfSpaces));
        }

        @Override
        void formatLineIndex(int index) {
            this.lineIndexFormat.format((long)index, this.out, this.dummy);
        }

        @Override
        abstract void formatElement(int var1);

        @Override
        String result() {
            return this.out.toString();
        }
    }

    private abstract class PrintfElementFormatter
    extends ElementFormatter {
        final StringBuilder out;
        final java.util.Formatter utilFormatter;
        final String elementsFormat;
        private final String lineIndexFormat;

        private PrintfElementFormatter(SNumbers sNumbers, Formatter formatter, int estimatedCapacity) {
            this.out = new StringBuilder(estimatedCapacity);
            this.utilFormatter = formatter.locale == null ? new java.util.Formatter(this.out) : new java.util.Formatter(this.out, formatter.locale);
            this.elementsFormat = formatter.elementsFormat;
            this.lineIndexFormat = formatter.lineIndexFormat;
        }

        @Override
        int length() {
            return this.out.length();
        }

        @Override
        void append(String s) {
            this.out.append(s);
        }

        @Override
        void insertSpaces(int position, int numberOfSpaces) {
            this.out.insert(position, SNumbers.spaces(numberOfSpaces));
        }

        @Override
        void formatLineIndex(int index) {
            this.utilFormatter.format(this.lineIndexFormat, index);
        }

        @Override
        abstract void formatElement(int var1);

        @Override
        String result() {
            return this.out.toString();
        }
    }

    private abstract class SimpleElementFormatter
    extends ElementFormatter {
        final StringBuilder out;

        private SimpleElementFormatter(SNumbers sNumbers, int estimatedCapacity) {
            this.out = new StringBuilder(estimatedCapacity);
        }

        @Override
        int length() {
            return this.out.length();
        }

        @Override
        void append(String s) {
            this.out.append(s);
        }

        @Override
        void insertSpaces(int position, int numberOfSpaces) {
            this.out.insert(position, SNumbers.spaces(numberOfSpaces));
        }

        @Override
        void formatLineIndex(int index) {
            this.out.append(index);
        }

        @Override
        abstract void formatElement(int var1);

        @Override
        String result() {
            return this.out.toString();
        }
    }

    private static abstract class ElementFormatter {
        private ElementFormatter() {
        }

        abstract int length();

        abstract void append(String var1);

        abstract void insertSpaces(int var1, int var2);

        abstract void formatLineIndex(int var1);

        abstract void formatElement(int var1);

        abstract String result();

        void formatLineIndex(int index, String delimiter) {
            this.formatLineIndex(index);
            this.append(delimiter);
        }

        void formatLineIndex(int index, String delimiter, int minimalLength) {
            int p = this.length();
            this.formatLineIndex(index);
            int q = this.length() - p;
            if (q < minimalLength) {
                this.insertSpaces(p, minimalLength - q);
            }
            this.append(delimiter);
        }

        void formatElement(int disp, String delimiter) {
            this.formatElement(disp);
            this.append(delimiter);
        }

        void formatElement(int disp, String delimiter, int minimalLength) {
            int p = this.length();
            this.formatElement(disp);
            int q = this.length() - p;
            if (q < minimalLength) {
                this.insertSpaces(p, minimalLength - q);
            }
            this.append(delimiter);
        }
    }
}

