/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core;

import java.util.Locale;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.graalvm.GraalAPI;
import net.algart.executors.api.graalvm.GraalSafety;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import org.graalvm.polyglot.Value;

public final class CommonJS
extends Executor {
    public static final String CALLABLE_EXECUTOR_FACTORY_VARIABLE = "executorFactory";
    public static final String CALLABLE_EXECUTOR_VARIABLE_1_ALT = "exec";
    public static final String CALLABLE_EXECUTOR_VARIABLE_1 = "exec1";
    public static final String CALLABLE_EXECUTOR_VARIABLE_2 = "exec2";
    public static final String CALLABLE_EXECUTOR_VARIABLE_3 = "exec3";
    public static final String INPUT_A = "a";
    public static final String INPUT_B = "b";
    public static final String INPUT_C = "c";
    public static final String INPUT_D = "d";
    public static final String INPUT_E = "e";
    public static final String INPUT_F = "f";
    public static final String INPUT_X1 = "x1";
    public static final String X1_VARIABLE_ALT = "x";
    public static final String INPUT_X2 = "x2";
    public static final String INPUT_X3 = "x3";
    public static final String INPUT_M1 = "m1";
    public static final String M1_VARIABLE_ALT = "m";
    public static final String INPUT_M2 = "m2";
    public static final String INPUT_M3 = "m3";
    public static final String INPUT_M4 = "m4";
    public static final String INPUT_M5 = "m5";
    public static final String OUTPUT_A = "a";
    public static final String OUTPUT_B = "b";
    public static final String OUTPUT_C = "c";
    public static final String OUTPUT_D = "d";
    public static final String OUTPUT_E = "e";
    public static final String OUTPUT_F = "f";
    public static final String OUTPUT_G = "g";
    public static final String OUTPUT_H = "h";
    public static final String OUTPUT_X1 = "x1";
    public static final String OUTPUT_X2 = "x2";
    public static final String OUTPUT_X3 = "x3";
    public static final String OUTPUT_M1 = "m1";
    public static final String OUTPUT_M2 = "m2";
    public static final String OUTPUT_M3 = "m3";
    public static final String OUTPUT_M4 = "m4";
    public static final String OUTPUT_M5 = "m5";
    private String initializingOperator = "";
    private String formula = "a";
    private String resultA = "";
    private String resultB = "";
    private String resultC = "";
    private String resultD = "";
    private String resultE = "";
    private String resultF = "";
    private String resultG = "";
    private String resultH = "";
    private String resultX1 = "";
    private String resultX2 = "";
    private String resultX3 = "";
    private String resultM1 = "";
    private String resultM2 = "";
    private String resultM3 = "";
    private String resultM4 = "";
    private String resultM5 = "";
    private String defaultA = "0";
    private String defaultB = "0";
    private String defaultC = "0";
    private String defaultD = "0";
    private String defaultE = "0";
    private String defaultF = "0";
    private int resultX1BlockLength = 1;
    private int resultX2BlockLength = 1;
    private int resultX3BlockLength = 1;
    private String callableExecutorId1 = "";
    private String callableExecutorId2 = "";
    private String callableExecutorId3 = "";
    private boolean callableExecutorOutputsNecessaryAlways = true;
    private final GraalAPI graalAPI = GraalAPI.getSmartScriptingInstance();
    private GraalSafety safety = GraalSafety.SAFE;
    private boolean shareNamespace = false;
    private boolean closeSharedContext = true;
    private GraalPerformerContainer performerContainer = null;
    private final GraalSourceContainer javaScriptInitializingOperator = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptFormula = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultA = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultB = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultC = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultD = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultE = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultF = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultG = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultH = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultX1 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultX2 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultX3 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultM1 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultM2 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultM3 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultM4 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultM5 = GraalSourceContainer.newLiteralContainer();
    private Executor callableExecutor1 = null;
    private Executor callableExecutor2 = null;
    private Executor callableExecutor3 = null;
    private final Object lock = new Object();

    public CommonJS() {
        this.addInputScalar("a");
        this.addInputScalar("b");
        this.addInputScalar("c");
        this.addInputScalar("d");
        this.addInputScalar("e");
        this.addInputScalar("f");
        this.addInputNumbers("x1");
        this.addInputNumbers("x2");
        this.addInputNumbers("x3");
        this.addInputMat("m1");
        this.addInputMat("m2");
        this.addInputMat("m3");
        this.addInputMat("m4");
        this.addInputMat("m5");
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar("a");
        this.addOutputScalar("b");
        this.addOutputScalar("c");
        this.addOutputScalar("d");
        this.addOutputScalar("e");
        this.addOutputScalar("f");
        this.addOutputScalar(OUTPUT_G);
        this.addOutputScalar(OUTPUT_H);
        this.addOutputNumbers("x1");
        this.addOutputNumbers("x2");
        this.addOutputNumbers("x3");
        this.addOutputMat("m1");
        this.addOutputMat("m2");
        this.addOutputMat("m3");
        this.addOutputMat("m4");
        this.addOutputMat("m5");
    }

    public String getInitializingOperator() {
        return this.initializingOperator;
    }

    public CommonJS setInitializingOperator(String initializingOperator) {
        this.initializingOperator = CommonJS.nonNull(initializingOperator).trim();
        return this;
    }

    public String getFormula() {
        return this.formula;
    }

    public CommonJS setFormula(String formula) {
        this.formula = CommonJS.nonNull(formula).trim();
        return this;
    }

    public String getResultA() {
        return this.resultA;
    }

    public CommonJS setResultA(String resultA) {
        this.resultA = CommonJS.nonNull(resultA).trim();
        return this;
    }

    public String getResultB() {
        return this.resultB;
    }

    public CommonJS setResultB(String resultB) {
        this.resultB = CommonJS.nonNull(resultB).trim();
        return this;
    }

    public String getResultC() {
        return this.resultC;
    }

    public CommonJS setResultC(String resultC) {
        this.resultC = CommonJS.nonNull(resultC).trim();
        return this;
    }

    public String getResultD() {
        return this.resultD;
    }

    public CommonJS setResultD(String resultD) {
        this.resultD = CommonJS.nonNull(resultD).trim();
        return this;
    }

    public String getResultE() {
        return this.resultE;
    }

    public CommonJS setResultE(String resultE) {
        this.resultE = CommonJS.nonNull(resultE).trim();
        return this;
    }

    public String getResultF() {
        return this.resultF;
    }

    public CommonJS setResultF(String resultF) {
        this.resultF = CommonJS.nonNull(resultF).trim();
        return this;
    }

    public String getResultG() {
        return this.resultG;
    }

    public CommonJS setResultG(String resultG) {
        this.resultG = CommonJS.nonNull(resultG).trim();
        return this;
    }

    public String getResultH() {
        return this.resultH;
    }

    public CommonJS setResultH(String resultH) {
        this.resultH = CommonJS.nonNull(resultH).trim();
        return this;
    }

    public String getResultX1() {
        return this.resultX1;
    }

    public CommonJS setResultX1(String resultX1) {
        this.resultX1 = CommonJS.nonNull(resultX1).trim();
        return this;
    }

    public String getResultX2() {
        return this.resultX2;
    }

    public CommonJS setResultX2(String resultX2) {
        this.resultX2 = CommonJS.nonNull(resultX2).trim();
        return this;
    }

    public String getResultX3() {
        return this.resultX3;
    }

    public CommonJS setResultX3(String resultX3) {
        this.resultX3 = CommonJS.nonNull(resultX3).trim();
        return this;
    }

    public String getResultM1() {
        return this.resultM1;
    }

    public CommonJS setResultM1(String resultM1) {
        this.resultM1 = CommonJS.nonNull(resultM1).trim();
        return this;
    }

    public String getResultM2() {
        return this.resultM2;
    }

    public CommonJS setResultM2(String resultM2) {
        this.resultM2 = CommonJS.nonNull(resultM2).trim();
        return this;
    }

    public String getResultM3() {
        return this.resultM3;
    }

    public CommonJS setResultM3(String resultM3) {
        this.resultM3 = CommonJS.nonNull(resultM3).trim();
        return this;
    }

    public String getResultM4() {
        return this.resultM4;
    }

    public CommonJS setResultM4(String resultM4) {
        this.resultM4 = CommonJS.nonNull(resultM4).trim();
        return this;
    }

    public String getResultM5() {
        return this.resultM5;
    }

    public CommonJS setResultM5(String resultM5) {
        this.resultM5 = CommonJS.nonNull(resultM5).trim();
        return this;
    }

    public String getDefaultA() {
        return this.defaultA;
    }

    public CommonJS setDefaultA(String defaultA) {
        this.defaultA = defaultA;
        return this;
    }

    public String getDefaultB() {
        return this.defaultB;
    }

    public CommonJS setDefaultB(String defaultB) {
        this.defaultB = defaultB;
        return this;
    }

    public String getDefaultC() {
        return this.defaultC;
    }

    public CommonJS setDefaultC(String defaultC) {
        this.defaultC = defaultC;
        return this;
    }

    public String getDefaultD() {
        return this.defaultD;
    }

    public CommonJS setDefaultD(String defaultD) {
        this.defaultD = defaultD;
        return this;
    }

    public String getDefaultE() {
        return this.defaultE;
    }

    public CommonJS setDefaultE(String defaultE) {
        this.defaultE = defaultE;
        return this;
    }

    public String getDefaultF() {
        return this.defaultF;
    }

    public CommonJS setDefaultF(String defaultF) {
        this.defaultF = defaultF;
        return this;
    }

    public int getResultX1BlockLength() {
        return this.resultX1BlockLength;
    }

    public CommonJS setResultX1BlockLength(int resultX1BlockLength) {
        this.resultX1BlockLength = CommonJS.positive(resultX1BlockLength);
        return this;
    }

    public int getResultX2BlockLength() {
        return this.resultX2BlockLength;
    }

    public CommonJS setResultX2BlockLength(int resultX2BlockLength) {
        this.resultX2BlockLength = CommonJS.positive(resultX2BlockLength);
        return this;
    }

    public int getResultX3BlockLength() {
        return this.resultX3BlockLength;
    }

    public CommonJS setResultX3BlockLength(int resultX3BlockLength) {
        this.resultX3BlockLength = CommonJS.positive(resultX3BlockLength);
        return this;
    }

    public String getCallableExecutorId1() {
        return this.callableExecutorId1;
    }

    public CommonJS setCallableExecutorId1(String callableExecutorId1) {
        this.callableExecutorId1 = CommonJS.nonNull(callableExecutorId1).trim();
        return this;
    }

    public String getCallableExecutorId2() {
        return this.callableExecutorId2;
    }

    public CommonJS setCallableExecutorId2(String callableExecutorId2) {
        this.callableExecutorId2 = CommonJS.nonNull(callableExecutorId2).trim();
        return this;
    }

    public String getCallableExecutorId3() {
        return this.callableExecutorId3;
    }

    public CommonJS setCallableExecutorId3(String callableExecutorId3) {
        this.callableExecutorId3 = CommonJS.nonNull(callableExecutorId3).trim();
        return this;
    }

    public boolean isCallableExecutorOutputsNecessaryAlways() {
        return this.callableExecutorOutputsNecessaryAlways;
    }

    public CommonJS setCallableExecutorOutputsNecessaryAlways(boolean callableExecutorOutputsNecessaryAlways) {
        this.callableExecutorOutputsNecessaryAlways = callableExecutorOutputsNecessaryAlways;
        return this;
    }

    public boolean isConvertInputScalarToNumber() {
        return this.graalAPI.isConvertInputScalarToNumber();
    }

    public CommonJS setConvertInputScalarToNumber(boolean convertInputScalarToNumber) {
        this.graalAPI.setConvertInputScalarToNumber(convertInputScalarToNumber);
        return this;
    }

    public boolean isConvertInputNumbersToArray() {
        return this.graalAPI.isConvertInputNumbersToArray();
    }

    public CommonJS setConvertInputNumbersToArray(boolean convertInputNumbersToArray) {
        this.graalAPI.setConvertInputNumbersToArray(convertInputNumbersToArray);
        return this;
    }

    public boolean isConvertInputArraysToDouble() {
        return this.graalAPI.isConvertInputArraysToDouble();
    }

    public CommonJS setConvertInputArraysToDouble(boolean convertInputArraysToDouble) {
        this.graalAPI.setConvertInputArraysToDouble(convertInputArraysToDouble);
        return this;
    }

    public boolean isConvertOutputIntegerToBriefForm() {
        return this.graalAPI.isConvertOutputIntegerToBriefForm();
    }

    public CommonJS setConvertOutputIntegersToBriefForm(boolean convertOutputIntegersToBriefForm) {
        this.graalAPI.setConvertOutputIntegersToBriefForm(convertOutputIntegersToBriefForm);
        return this;
    }

    public GraalSafety getSafety() {
        return this.safety;
    }

    public CommonJS setSafety(GraalSafety safety) {
        CommonJS.nonNull(safety);
        if (safety != this.safety) {
            this.closePerformerContainer();
            this.safety = safety;
        }
        return this;
    }

    public boolean isShareNamespace() {
        return this.shareNamespace;
    }

    public CommonJS setShareNamespace(boolean shareNamespace) {
        if (shareNamespace != this.shareNamespace) {
            this.closePerformerContainer();
            this.shareNamespace = shareNamespace;
        }
        return this;
    }

    public boolean isCloseSharedContext() {
        return this.closeSharedContext;
    }

    public CommonJS setCloseSharedContext(boolean closeSharedContext) {
        this.closeSharedContext = closeSharedContext;
        return this;
    }

    @Override
    public void initialize() {
        long t1 = CommonJS.debugTime();
        GraalPerformer performer = this.performerContainer().performer(this.getContextId());
        long t2 = CommonJS.debugTime();
        this.closeExecutors();
        ExecutorFactory executorFactory = new ExecutorFactory(this.getSessionId(), this.callableExecutorOutputsNecessaryAlways);
        Value bindings = performer.bindingsJS();
        bindings.putMember(CALLABLE_EXECUTOR_FACTORY_VARIABLE, (Object)executorFactory);
        if (!this.callableExecutorId1.isEmpty()) {
            this.callableExecutor1 = executorFactory.get(this.callableExecutorId1);
            bindings.putMember(CALLABLE_EXECUTOR_VARIABLE_1, (Object)this.callableExecutor1);
            bindings.putMember(CALLABLE_EXECUTOR_VARIABLE_1_ALT, (Object)this.callableExecutor1);
        }
        if (!this.callableExecutorId2.isEmpty()) {
            this.callableExecutor2 = executorFactory.get(this.callableExecutorId2);
            bindings.putMember(CALLABLE_EXECUTOR_VARIABLE_2, (Object)this.callableExecutor2);
        }
        if (!this.callableExecutorId3.isEmpty()) {
            this.callableExecutor3 = executorFactory.get(this.callableExecutorId3);
            bindings.putMember(CALLABLE_EXECUTOR_VARIABLE_3, (Object)this.callableExecutor3);
        }
        long t3 = CommonJS.debugTime();
        if (!this.initializingOperator.isEmpty()) {
            this.javaScriptInitializingOperator.setCommonJS(this.initializingOperator);
            this.putAllInputs(bindings, true);
            performer.perform(this.javaScriptInitializingOperator);
        }
        long t4 = CommonJS.debugTime();
        CommonJS.logDebug(() -> String.format(Locale.US, "JavaScript reset in %.5f ms: %.2f mcs getting performer + %.2f mcs adding executors + %.2f mcs initializing script", (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001));
    }

    @Override
    public void process() {
        long t1 = CommonJS.debugTime();
        GraalPerformer performer = this.performerContainer().performer(this.getContextId());
        this.javaScriptFormula.setCommonJS(this.formula);
        this.javaScriptResultA.setCommonJS(this.resultA);
        this.javaScriptResultB.setCommonJS(this.resultB);
        this.javaScriptResultC.setCommonJS(this.resultC);
        this.javaScriptResultD.setCommonJS(this.resultD);
        this.javaScriptResultE.setCommonJS(this.resultE);
        this.javaScriptResultF.setCommonJS(this.resultF);
        this.javaScriptResultG.setCommonJS(this.resultG);
        this.javaScriptResultH.setCommonJS(this.resultH);
        this.javaScriptResultX1.setCommonJS(this.resultX1);
        this.javaScriptResultX2.setCommonJS(this.resultX2);
        this.javaScriptResultX3.setCommonJS(this.resultX3);
        this.javaScriptResultM1.setCommonJS(this.resultM1);
        this.javaScriptResultM2.setCommonJS(this.resultM2);
        this.javaScriptResultM3.setCommonJS(this.resultM3);
        this.javaScriptResultM4.setCommonJS(this.resultM4);
        this.javaScriptResultM5.setCommonJS(this.resultM5);
        long t2 = CommonJS.debugTime();
        this.putAllInputs(performer.bindingsJS(), false);
        long t3 = CommonJS.debugTime();
        Value result = performer.perform(this.javaScriptFormula);
        this.graalAPI.storeScalar(this, this.defaultOutputPortName(), result);
        long t4 = CommonJS.debugTime();
        this.graalAPI.storeScalar(this, "a", performer.perform(this.javaScriptResultA));
        this.graalAPI.storeScalar(this, "b", performer.perform(this.javaScriptResultB));
        this.graalAPI.storeScalar(this, "c", performer.perform(this.javaScriptResultC));
        this.graalAPI.storeScalar(this, "d", performer.perform(this.javaScriptResultD));
        this.graalAPI.storeScalar(this, "e", performer.perform(this.javaScriptResultE));
        this.graalAPI.storeScalar(this, "f", performer.perform(this.javaScriptResultF));
        this.graalAPI.storeScalar(this, OUTPUT_H, performer.perform(this.javaScriptResultH));
        this.graalAPI.storeNumbers(this, "x1", performer.perform(this.javaScriptResultX1), this.resultX1BlockLength);
        this.graalAPI.storeNumbers(this, "x2", performer.perform(this.javaScriptResultX2), this.resultX2BlockLength);
        this.graalAPI.storeNumbers(this, "x3", performer.perform(this.javaScriptResultX3), this.resultX3BlockLength);
        this.graalAPI.storeMat(this, "m1", performer.perform(this.javaScriptResultM1));
        this.graalAPI.storeMat(this, "m2", performer.perform(this.javaScriptResultM2));
        this.graalAPI.storeMat(this, "m3", performer.perform(this.javaScriptResultM3));
        this.graalAPI.storeMat(this, "m4", performer.perform(this.javaScriptResultM4));
        this.graalAPI.storeMat(this, "m5", performer.perform(this.javaScriptResultM5));
        long t5 = CommonJS.debugTime();
        CommonJS.logDebug(() -> String.format(Locale.US, "JavaScript \"%s\" executed in %.5f ms: %.2f mcs compiling + %.2f mcs adding vars + %.2f mcs main script + %.2f mcs additional outputs (%d shared script performers)", CommonJS.scriptToShortString(this.formula), (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001, (double)(t5 - t4) * 0.001, GraalPerformerContainer.numberOfSharedPerformers()));
    }

    @Override
    public void close() {
        super.close();
        this.closeExecutors();
        this.closePerformerContainer();
    }

    private void closeExecutors() {
        if (this.callableExecutor3 != null) {
            this.callableExecutor3.close();
            this.callableExecutor3 = null;
        }
        if (this.callableExecutor2 != null) {
            this.callableExecutor2.close();
            this.callableExecutor2 = null;
        }
        if (this.callableExecutor1 != null) {
            this.callableExecutor1.close();
            this.callableExecutor1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePerformerContainer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.performerContainer != null) {
                this.performerContainer.freeResources(this.closeSharedContext);
                this.performerContainer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraalPerformerContainer performerContainer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.performerContainer == null) {
                this.performerContainer = GraalAPI.JS.getJSContainer(this.shareNamespace, this.safety);
            }
            return this.performerContainer;
        }
    }

    private void putAllInputs(Value bindings, boolean putNullBindingForUninitialized) {
        this.graalAPI.loadScalar(bindings, this, "a", this.defaultA);
        this.graalAPI.loadScalar(bindings, this, "b", this.defaultB);
        this.graalAPI.loadScalar(bindings, this, "c", this.defaultC);
        this.graalAPI.loadScalar(bindings, this, "d", this.defaultD);
        this.graalAPI.loadScalar(bindings, this, "e", this.defaultE);
        this.graalAPI.loadScalar(bindings, this, "f", this.defaultF);
        this.graalAPI.loadNumbers(bindings, this, "x1", putNullBindingForUninitialized, X1_VARIABLE_ALT);
        this.graalAPI.loadNumbers(bindings, this, "x2", putNullBindingForUninitialized, new String[0]);
        this.graalAPI.loadNumbers(bindings, this, "x3", putNullBindingForUninitialized, new String[0]);
        this.graalAPI.loadMat(bindings, this, "m1", putNullBindingForUninitialized, M1_VARIABLE_ALT);
        this.graalAPI.loadMat(bindings, this, "m2", putNullBindingForUninitialized, new String[0]);
        this.graalAPI.loadMat(bindings, this, "m3", putNullBindingForUninitialized, new String[0]);
        this.graalAPI.loadMat(bindings, this, "m4", putNullBindingForUninitialized, new String[0]);
        this.graalAPI.loadMat(bindings, this, "m5", putNullBindingForUninitialized, new String[0]);
    }

    private static String scriptToShortString(String script) {
        if (((String)script).length() > 30) {
            script = ((String)script).substring(0, 30) + "...";
        }
        return ((String)script).replaceAll("(?:\\r(?!\\n)|\\n|\\r\\n)", " \\\\n ");
    }

    public static class ExecutorFactory {
        private final String sessionId;
        private final boolean callableExecutorOutputsNecessaryAlways;
        private net.algart.executors.api.system.ExecutorFactory executorFactory = null;

        private ExecutorFactory(String sessionId, boolean callableExecutorOutputsNecessaryAlways) {
            this.sessionId = sessionId;
            this.callableExecutorOutputsNecessaryAlways = callableExecutorOutputsNecessaryAlways;
        }

        public Executor get(String callableExecutorId) {
            Executor result = this.factory().newExecutor(Executor.class, callableExecutorId);
            result.setAllOutputsNecessary(this.callableExecutorOutputsNecessaryAlways);
            return result;
        }

        public net.algart.executors.api.system.ExecutorFactory factory() {
            if (this.executorFactory == null) {
                this.executorFactory = ExecutionBlock.globalLoaders().newFactory(this.sessionId);
            }
            return this.executorFactory;
        }
    }
}

