/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core.arrays;

import net.algart.arrays.SizeMismatchException;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;

public final class BlockJSModifyingSeveralNumbers
extends Executor {
    public static final String IN_OUT_A = "a";
    public static final String IN_OUT_B = "b";
    public static final String IN_OUT_C = "c";
    public static final String IN_OUT_D = "d";
    private String javaScriptCode = "a[0] = a[0] * p + k;";
    private double p = 0.0;
    private double q = 0.0;
    private double r = 0.0;
    private double s = 0.0;
    private double t = 0.0;
    private double u = 0.0;
    private volatile JavaScriptPerformer javaScript = null;

    public BlockJSModifyingSeveralNumbers() {
        this.useVisibleResultParameter();
        this.addInputNumbers(IN_OUT_A);
        this.addInputNumbers(IN_OUT_B);
        this.addInputNumbers(IN_OUT_C);
        this.addInputNumbers(IN_OUT_D);
        this.addOutputNumbers(IN_OUT_A);
        this.addOutputNumbers(IN_OUT_B);
        this.addOutputNumbers(IN_OUT_C);
        this.addOutputNumbers(IN_OUT_D);
    }

    public String getJavaScriptCode() {
        return this.javaScriptCode;
    }

    public BlockJSModifyingSeveralNumbers setJavaScriptCode(String javaScriptCode) {
        this.javaScriptCode = BlockJSModifyingSeveralNumbers.nonNull(javaScriptCode);
        return this;
    }

    public double getP() {
        return this.p;
    }

    public BlockJSModifyingSeveralNumbers setP(double p) {
        this.p = p;
        return this;
    }

    public double getQ() {
        return this.q;
    }

    public BlockJSModifyingSeveralNumbers setQ(double q) {
        this.q = q;
        return this;
    }

    public double getR() {
        return this.r;
    }

    public BlockJSModifyingSeveralNumbers setR(double r) {
        this.r = r;
        return this;
    }

    public double getS() {
        return this.s;
    }

    public BlockJSModifyingSeveralNumbers setS(double s) {
        this.s = s;
        return this;
    }

    public double getT() {
        return this.t;
    }

    public BlockJSModifyingSeveralNumbers setT(double t) {
        this.t = t;
        return this;
    }

    public double getU() {
        return this.u;
    }

    public BlockJSModifyingSeveralNumbers setU(double u) {
        this.u = u;
        return this;
    }

    @Override
    public void process() {
        SNumbers aArray = this.getInputNumbers(IN_OUT_A);
        SNumbers bArray = this.getInputNumbers(IN_OUT_B, true);
        SNumbers cArray = this.getInputNumbers(IN_OUT_C, true);
        SNumbers dArray = this.getInputNumbers(IN_OUT_D, true);
        BlockJSModifyingSeveralNumbers.checkNEquality(aArray, bArray, IN_OUT_A, IN_OUT_B);
        BlockJSModifyingSeveralNumbers.checkNEquality(aArray, cArray, IN_OUT_A, IN_OUT_C);
        BlockJSModifyingSeveralNumbers.checkNEquality(aArray, dArray, IN_OUT_A, IN_OUT_D);
        this.javaScript = JavaScriptPerformer.newInstanceIfChanged(this.javaScriptCode, this.javaScript);
        this.javaScript.putVariable("p", this.p);
        this.javaScript.putVariable("q", this.q);
        this.javaScript.putVariable("r", this.r);
        this.javaScript.putVariable("s", this.s);
        this.javaScript.putVariable("t", this.t);
        this.javaScript.putVariable("u", this.u);
        double[] a = BlockJSModifyingSeveralNumbers.createBlock(aArray);
        double[] b = BlockJSModifyingSeveralNumbers.createBlock(bArray);
        double[] c = BlockJSModifyingSeveralNumbers.createBlock(cArray);
        double[] d = BlockJSModifyingSeveralNumbers.createBlock(dArray);
        this.javaScript.putVariable(IN_OUT_A, a);
        this.javaScript.putVariable(IN_OUT_B, b);
        this.javaScript.putVariable(IN_OUT_C, c);
        this.javaScript.putVariable(IN_OUT_D, c);
        int n = aArray.n();
        for (int k = 0; k < n; ++k) {
            this.javaScript.putVariable("k", k);
            BlockJSModifyingSeveralNumbers.readBlock(a, aArray, k);
            BlockJSModifyingSeveralNumbers.readBlock(b, bArray, k);
            BlockJSModifyingSeveralNumbers.readBlock(c, cArray, k);
            BlockJSModifyingSeveralNumbers.readBlock(d, dArray, k);
            this.javaScript.perform();
            BlockJSModifyingSeveralNumbers.writeBlock(a, aArray, k);
            BlockJSModifyingSeveralNumbers.writeBlock(b, bArray, k);
            BlockJSModifyingSeveralNumbers.writeBlock(c, cArray, k);
            BlockJSModifyingSeveralNumbers.writeBlock(d, dArray, k);
        }
        this.getNumbers(IN_OUT_A).setTo(aArray);
        this.getNumbers(IN_OUT_B).setTo(bArray);
        this.getNumbers(IN_OUT_C).setTo(cArray);
        this.getNumbers(IN_OUT_D).setTo(dArray);
    }

    private static double[] createBlock(SNumbers numbers) {
        return new double[numbers != null && numbers.isInitialized() ? numbers.getBlockLength() : 0];
    }

    private static void readBlock(double[] block, SNumbers numbers, int k) {
        if (block.length > 0) {
            numbers.getBlockDoubleValues(k, block);
        }
    }

    private static void writeBlock(double[] block, SNumbers numbers, int k) {
        if (block.length > 0) {
            numbers.setBlockDoubleValues(k, block);
        }
    }

    private static void checkNEquality(SNumbers first, SNumbers second, String firstName, String secondName) {
        if (first != null && first.isInitialized() && second != null && second.isInitialized() && second.n() != first.n()) {
            throw new SizeMismatchException("The number arrays' \"" + firstName + "\" and \"" + secondName + "\" numbers of columns mismatch: " + first.n() + " and " + second.n());
        }
    }
}

