/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains.core;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Objects;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.multichains.MultiChain;
import net.algart.executors.api.multichains.MultiChainSettingsBuilder;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.CombineChainSettings;
import net.algart.json.Jsons;

public class CombineMultiChainSettings
extends CombineChainSettings {
    public MultiChain multiChain() {
        SettingsBuilder settingsBuilder = this.settingsBuilder();
        if (!(settingsBuilder instanceof MultiChainSettingsBuilder)) {
            throw new IllegalStateException("Invalid usage of " + String.valueOf(this) + ": settings object is not MultiChainSettingsBuilder");
        }
        MultiChainSettingsBuilder multiChainSettingsBuilder = (MultiChainSettingsBuilder)settingsBuilder;
        return multiChainSettingsBuilder.multiChain();
    }

    public void selectChainVariant(String variant) {
        Objects.requireNonNull(variant, "Null variant");
        this.setStringParameter(this.multiChain().selectedChainParameter(), variant);
    }

    @Override
    protected JsonObject correctSettings(JsonObject settingsJson, SettingsBuilder settingsBuilder) {
        if (!(settingsBuilder instanceof MultiChainSettingsBuilder)) {
            throw new IllegalArgumentException("Invalid usage of " + String.valueOf(this) + ": settings object is not MultiChainSettingsBuilder");
        }
        MultiChainSettingsBuilder multiChainSettingsBuilder = (MultiChainSettingsBuilder)settingsBuilder;
        MultiChain multiChain = multiChainSettingsBuilder.multiChain();
        String chainId = settingsJson.getString("___selectedChainId", null);
        if (chainId == null) {
            return settingsJson;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (!settingsJson.containsKey((Object)"___selectedChainName")) {
            for (ChainSpecification specification : multiChain.chainSpecifications()) {
                if (!chainId.equals(specification.chainId())) continue;
                builder.add("___selectedChainName", specification.chainName());
                break;
            }
        }
        Jsons.addAllJson(builder, settingsJson);
        return builder.build();
    }
}

