/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.python;

import java.nio.file.Path;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.jep.JepAPI;
import net.algart.executors.api.python.PythonSpecification;
import net.algart.jep.JepPerformer;
import net.algart.jep.JepPerformerContainer;
import net.algart.jep.additions.AtomicPyCallable;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepInterpretation;
import net.algart.jep.additions.JepType;

public final class JepCaller
implements Cloneable,
AutoCloseable {
    private static final boolean REUSE_SINGLE_THREAD_FOR_ALL_INSTANCES = true;
    private static final boolean DEBUG_SLEEP_FOR_PARALLEL_EXECUTION = false;
    private final PythonSpecification specification;
    private final PythonSpecification.Python python;
    private volatile JepPerformerContainer container;
    private final JepType type;
    private final JepAPI jepAPI = JepAPI.getInstance();
    private volatile AtomicPyObject pythonClassInstance = null;
    private final Object lock = new Object();

    private JepCaller(PythonSpecification specification) {
        this.specification = Objects.requireNonNull(specification, "Null specification");
        this.python = specification.getPython();
        if (this.python == null) {
            Path file = specification.getSpecificationFile();
            throw new IllegalArgumentException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a Python executor configuration: no \"python\" section");
        }
        JepType type = this.python.getJepType();
        if (type.isSubInterpreter()) {
            throw new IllegalArgumentException("Pure interpreter (" + String.valueOf((Object)type) + "is not allowed");
        }
        this.type = type;
        this.container = JepAPI.newContainer(type);
    }

    public static JepCaller of(PythonSpecification specification) {
        return new JepCaller(specification);
    }

    public PythonSpecification specification() {
        return this.specification;
    }

    public String executorId() {
        return this.specification.getId();
    }

    public String name() {
        return this.specification.getName();
    }

    public String platformId() {
        return this.specification.getPlatformId();
    }

    public JepType type() {
        return this.type;
    }

    public boolean isGlobalSynchronizationRequired() {
        return this.type.isJVMGlobal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JepPerformer performer() {
        Object object = this.lock;
        synchronized (object) {
            return this.container.performer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicPyObject pythonClassInstance() {
        Object object = this.lock;
        synchronized (object) {
            return this.pythonClassInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithLock(Runnable initializing, Runnable processing) {
        Objects.requireNonNull(initializing, "Null initializing");
        Objects.requireNonNull(processing, "Null processing");
        Object object = this.lock;
        synchronized (object) {
            initializing.run();
            processing.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Executor executor) {
        Object object = this.lock;
        synchronized (object) {
            JepPerformer performer = this.performer();
            if (this.python.isClassMethod()) {
                String className = this.python.getClassName();
                performer.perform(JepInterpretation.importPythonCode(this.python.getModule(), className));
                if (this.pythonClassInstance == null) {
                    this.pythonClassInstance = performer.newObject(className, new Object[0]);
                }
            } else {
                performer.perform(JepInterpretation.importPythonCode(this.python.getModule(), this.python.getFunction()));
            }
        }
    }

    public AtomicPyObject loadParameters(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        JepPerformer performer = this.performer();
        AtomicPyObject parameters = this.jepAPI.newAPIObject(performer, this.python.getParametersClass());
        this.jepAPI.loadSystemParameters(executor, parameters, null);
        this.jepAPI.loadParameters(executor, parameters);
        return parameters;
    }

    public AtomicPyObject readInputPorts(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        JepPerformer performer = this.performer();
        AtomicPyObject inputs = this.jepAPI.newAPIObject(performer, this.python.getInputsClass());
        this.jepAPI.readInputPorts(performer, executor.inputPorts(), inputs);
        return inputs;
    }

    public AtomicPyObject createOutputs() {
        return this.jepAPI.newAPIObject(this.performer(), this.python.getOutputsClass());
    }

    public void writeOutputPorts(Executor executor, AtomicPyObject outputs) {
        Objects.requireNonNull(executor, "Null executor");
        this.jepAPI.writeOutputPorts(this.performer(), executor.outputPorts(), outputs);
    }

    public void writeOptionalOutputPort(Executor executor, String portName, Object value, boolean preserveExisting) {
        Port outputPort;
        Objects.requireNonNull(executor, "Null executor");
        if (value != null && (outputPort = executor.getOutputPort(portName)) != null) {
            this.jepAPI.writeOutputPort(this.performer(), outputPort, value, preserveExisting);
        }
    }

    public Object callPython(AtomicPyObject parameters, AtomicPyObject inputs, AtomicPyObject outputs) {
        if (this.python.isClassMethod()) {
            AtomicPyObject instance = this.pythonClassInstance();
            if (instance == null) {
                throw new IllegalStateException("initialize() was not called correctly");
            }
            try (AtomicPyCallable method = instance.getAtomicCallable(this.python.getFunction());){
                Object object = method.callAs(Object.class, parameters.pyObject(), inputs.pyObject(), outputs.pyObject());
                return object;
            }
        }
        JepPerformer performer = this.performer();
        return performer.invokeFunction(this.python.getFunction(), parameters.pyObject(), inputs.pyObject(), outputs.pyObject());
    }

    public JepCaller clone() {
        try {
            JepCaller clone = (JepCaller)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pythonClassInstance != null) {
                this.pythonClassInstance.close();
                this.pythonClassInstance = null;
            }
            this.container.close();
        }
    }
}

