/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.python.core;

import net.algart.executors.api.python.core.AbstractCallPython;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepInterpretation;

public final class CallPythonExternalFunction
extends AbstractCallPython {
    private static final String STANDARD_API_FILE_TO_IMPORT_FIELD = "_env_file_to_import";
    private static final String EXTERNAL_EXECUTE_CODE = "def _execute_external(params, inputs, outputs):\n    _external_module = params._env.import_file(params.%s)\n    return _external_module.%s(params, inputs, outputs)\n";
    private String pyFile = "";
    private String moduleName = "pyalgart_lib_demo_simple.simple_demo";

    public CallPythonExternalFunction() {
        this.addOutputScalar("code");
    }

    public String getPyFile() {
        return this.pyFile;
    }

    public CallPythonExternalFunction setPyFile(String pyFile) {
        this.pyFile = CallPythonExternalFunction.nonNull(pyFile).trim();
        return this;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public CallPythonExternalFunction setModuleName(String moduleName) {
        if (!(moduleName = CallPythonExternalFunction.nonNull(moduleName).trim()).matches("\\S+")) {
            throw new IllegalArgumentException("Python module name must not contain space characters");
        }
        this.moduleName = moduleName;
        return this;
    }

    @Override
    protected String code() {
        String mainFunctionName = this.getMainFunctionName();
        JepInterpretation.checkValidPythonFunctionName(mainFunctionName);
        if (!this.pyFile.isEmpty()) {
            return EXTERNAL_EXECUTE_CODE.formatted(STANDARD_API_FILE_TO_IMPORT_FIELD, mainFunctionName);
        }
        return JepInterpretation.importPythonCode(this.moduleName, mainFunctionName);
    }

    @Override
    protected Object callFunction(AtomicPyObject pythonParameters, AtomicPyObject pythonInputs, AtomicPyObject pythonOutputs) {
        if (!this.pyFile.isEmpty()) {
            pythonParameters.setAttribute(STANDARD_API_FILE_TO_IMPORT_FIELD, this.pyFile);
            return this.performer.invokeFunction("_execute_external", pythonParameters.pyObject(), pythonInputs.pyObject(), pythonOutputs.pyObject());
        }
        return super.callFunction(pythonParameters, pythonInputs, pythonOutputs);
    }

    @Override
    protected String executorName() {
        return "Python external function";
    }
}

