/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public enum ExecutionStage {
    LOADING_TIME("loading_time"),
    RUN_TIME("run_time");

    private final String stageName;

    private ExecutionStage(String stageName) {
        this.stageName = Objects.requireNonNull(stageName);
    }

    public static Collection<String> stageNames() {
        return Arrays.stream(ExecutionStage.values()).map(ExecutionStage::stageName).toList();
    }

    public String stageName() {
        return this.stageName;
    }

    public static ExecutionStage ofStageName(String stageName) {
        Objects.requireNonNull(stageName, "Null stage name");
        return ExecutionStage.fromStageName(stageName).orElseThrow(() -> new IllegalArgumentException("Unknown stage name: \"" + stageName + "\""));
    }

    public static Optional<ExecutionStage> fromStageName(String stageName) {
        for (ExecutionStage stage : ExecutionStage.values()) {
            if (!stage.stageName.equals(stageName)) continue;
            return Optional.of(stage);
        }
        return Optional.empty();
    }

    public static void main(String[] args) {
        for (ExecutionStage stage : ExecutionStage.values()) {
            System.out.printf("%s: %s, %s%n", new Object[]{stage, stage.stageName(), ExecutionStage.ofStageName(stage.stageName())});
        }
    }
}

