/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import jakarta.json.JsonException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.DefaultExecutorFactory;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;

public final class ExecutorLoaderSet {
    private final List<ExecutorLoader> loaders = new ArrayList<ExecutorLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ExecutorLoader loader) {
        List<ExecutorLoader> list = this.loaders;
        synchronized (list) {
            this.loaders.add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutorLoader> list() {
        List<ExecutorLoader> list = this.loaders;
        synchronized (list) {
            return Collections.unmodifiableList(this.loaders);
        }
    }

    public ExecutorFactory newFactory(String sessionId, ExecutorSpecificationSet preloadedSpecifications) {
        return new DefaultExecutorFactory(this, sessionId, preloadedSpecifications);
    }

    public ExecutorFactory newFactory(String sessionId) {
        return this.newFactory(sessionId, ExecutorSpecificationSet.allBuiltIn());
    }

    public ExecutionBlock newExecutor(String sessionId, ExecutorSpecification specification, CreateMode createMode) throws ClassNotFoundException {
        ExecutionBlock executor = this.loadExecutor(sessionId, specification, createMode);
        if (executor == null) {
            throw new IllegalArgumentException("Cannot load executor with ID " + specification.getId() + ": unknown executor specification");
        }
        return executor;
    }

    public ExecutionBlock loadExecutor(String sessionId, ExecutorSpecification specification, CreateMode createMode) throws ClassNotFoundException {
        Objects.requireNonNull(specification, "Null specification");
        List<ExecutorLoader> loaders = this.list();
        for (int k = loaders.size() - 1; k >= 0; --k) {
            ExecutionBlock executor = loaders.get(k).loadExecutor(sessionId, specification, createMode);
            if (executor == null) continue;
            return executor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorSpecification getSpecification(String sessionId, String executorId, boolean includeGlobalSession) throws JsonException {
        Objects.requireNonNull(executorId, "Null executorId");
        List<ExecutorLoader> list = this.loaders;
        synchronized (list) {
            for (ExecutorLoader loader : this.loaders) {
                ExecutorSpecification result;
                if (includeGlobalSession && (result = loader.getSpecification("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f", executorId)) != null) {
                    return result;
                }
                if (sessionId == null || (result = loader.getSpecification(sessionId, executorId)) == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializedSpecification(String sessionId, String executorId, boolean includeGlobalSession) throws JsonException {
        Objects.requireNonNull(executorId, "Null executorId");
        List<ExecutorLoader> list = this.loaders;
        synchronized (list) {
            for (ExecutorLoader loader : this.loaders) {
                String result;
                if (includeGlobalSession && (result = loader.serializedSpecification("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f", executorId)) != null) {
                    return result;
                }
                if (sessionId == null || (result = loader.serializedSpecification(sessionId, executorId)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public Map<String, String> allSerializedSpecifications(String sessionId, boolean includeGlobalSession) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (ExecutorLoader loader : this.list()) {
            if (includeGlobalSession) {
                result.putAll(loader.allSerializedSpecifications("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f"));
            }
            if (sessionId == null) continue;
            result.putAll(loader.allSerializedSpecifications(sessionId));
        }
        return result;
    }

    public Set<String> allExecutorIds(String sessionId, boolean includeGlobalSession) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ExecutorLoader loader : this.list()) {
            if (includeGlobalSession) {
                result.addAll(loader.allExecutorIds("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f"));
            }
            if (sessionId == null) continue;
            result.addAll(loader.allExecutorIds(sessionId));
        }
        return result;
    }

    public Set<String> allSessionIds() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ExecutorLoader loader : this.list()) {
            result.addAll(loader.allSessionIds());
        }
        return result;
    }

    public void clearSession(String sessionId) {
        for (ExecutorLoader loader : this.list()) {
            loader.clearSession(sessionId);
        }
    }
}

