/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.executors.api.data.DataType;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class PortSpecification
extends AbstractConvertibleToJson {
    private String name;
    private DataType valueType;
    private String caption = null;
    private String hint = null;
    private boolean advanced = false;

    public PortSpecification() {
    }

    public PortSpecification(JsonObject json, Path file) {
        this.name = Jsons.reqString(json, "name", file);
        String valueTypeName = Jsons.reqString(json, "value_type", file);
        this.valueType = DataType.fromTypeName(valueTypeName).orElseThrow(() -> Jsons.badValue(json, "value_type", valueTypeName, DataType.typeNames(), file));
        this.caption = json.getString("caption", null);
        this.hint = json.getString("hint", null);
        this.advanced = json.getBoolean("advanced", false);
    }

    public String getName() {
        return this.name;
    }

    public PortSpecification setName(String name) {
        this.name = Objects.requireNonNull(name, "Null name");
        return this;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public PortSpecification setValueType(DataType valueType) {
        this.valueType = Objects.requireNonNull(valueType, "Null valueType");
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public PortSpecification setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public PortSpecification setHint(String hint) {
        this.hint = hint;
        return this;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public PortSpecification setAdvanced(boolean advanced) {
        this.advanced = advanced;
        return this;
    }

    public boolean isCompatible(PortSpecification other) {
        Objects.requireNonNull(other, "Null other");
        return other.valueType == this.valueType;
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.name, "name");
        this.checkNull((Object)this.valueType, "valueType");
    }

    public String toString() {
        return "PortSpecification{name='" + this.name + "', valueType=" + String.valueOf((Object)this.valueType) + ", caption=" + this.caption + ", hint=" + this.hint + ", advanced=" + this.advanced + "}";
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        builder.add("name", this.name);
        builder.add("value_type", this.valueType.typeName());
        if (this.caption != null) {
            builder.add("caption", this.caption);
        }
        if (this.hint != null) {
            builder.add("hint", this.hint);
        }
        if (this.advanced) {
            builder.add("advanced", this.advanced);
        }
    }
}

