/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common;

import java.awt.Color;

public interface ChannelOperation {
    public int currentChannel();

    public int numberOfChannels();

    default public double colorChannel(double[] rgb) {
        return ChannelOperation.colorChannel(rgb, this.currentChannel(), this.numberOfChannels());
    }

    public static double colorChannel(double[] rgb, int channel, int numberOfChannels) {
        return ChannelOperation.colorChannel(rgb, channel, numberOfChannels, 0.0);
    }

    public static double colorChannel(double[] rgb, int channel, int numberOfChannels, double defaultForExtraChannels) {
        return ChannelOperation.correctLittleRoundingError(numberOfChannels == 1 ? ChannelOperation.intensity(rgb[0], rgb[1], rgb[2]) : (channel == 0 ? rgb[0] : (channel == 1 ? rgb[1] : (channel == 2 ? rgb[2] : (channel == 3 ? rgb[3] : defaultForExtraChannels)))));
    }

    default public double colorChannel(String s, double maxPossibleValue) {
        return ChannelOperation.colorChannel(s, maxPossibleValue, this.currentChannel(), this.numberOfChannels());
    }

    public static double colorChannel(String s, double maxPossibleValue, int currentChannel, int numberOfChannels) {
        return ChannelOperation.colorChannel(ChannelOperation.decodeRGBA(s, maxPossibleValue), currentChannel, numberOfChannels);
    }

    default public double colorChannel(Color color, double maxPossibleValue) {
        return ChannelOperation.colorChannel(color, maxPossibleValue, this.currentChannel(), this.numberOfChannels());
    }

    public static double colorChannel(Color color, int channel, int numberOfChannels) {
        return numberOfChannels == 1 ? ChannelOperation.intensity(color.getRed(), color.getGreen(), color.getBlue()) / 255.0 : (channel == 0 ? (double)color.getRed() / 255.0 : (channel == 1 ? (double)color.getGreen() / 255.0 : (channel == 2 ? (double)color.getBlue() / 255.0 : (channel == 3 ? (double)color.getAlpha() / 255.0 : 0.0))));
    }

    public static double colorChannel(Color color, double maxPossibleValue, int currentChannel, int numberOfChannels) {
        return ChannelOperation.correctLittleRoundingError(ChannelOperation.colorChannel(color, currentChannel, numberOfChannels) * maxPossibleValue);
    }

    public static double[] decodeRGBA(String s) {
        return ChannelOperation.decodeRGBA(s, 1.0);
    }

    public static double[] decodeRGBA(String s, double scale) {
        boolean hexNumber;
        boolean normalizedChannels;
        boolean rawChannels = (s = s.trim()).startsWith("[") && s.endsWith("]");
        boolean bl = normalizedChannels = s.startsWith("(") && s.endsWith(")");
        if (rawChannels || normalizedChannels) {
            String[] values;
            double defaultAlpha = scale;
            if (rawChannels) {
                scale = 1.0;
            }
            if ((values = s.substring(1, s.length() - 1).split("[, ]+")).length == 0) {
                return new double[]{0.0, 0.0, 0.0, scale};
            }
            double[] result = new double[4];
            for (int k = 0; k < result.length; ++k) {
                String v;
                result[k] = k >= values.length ? result[values.length - 1] : ((v = values[k].trim()).isEmpty() ? 0.0 : scale * Double.parseDouble(v));
            }
            if (values.length < 4) {
                result[3] = defaultAlpha;
            }
            return result;
        }
        boolean numberSign = s.startsWith("#");
        boolean bl2 = hexNumber = s.startsWith("0x") || s.startsWith("0X");
        if (numberSign || hexNumber) {
            int alpha;
            boolean isRgba = numberSign && s.length() == 9;
            long i = Long.decode(s);
            if (isRgba) {
                alpha = (int)i & 0xFF;
                i >>>= 8;
            } else {
                alpha = 255;
            }
            int r = (int)(i >>> 16) & 0xFF;
            int g = (int)(i >>> 8) & 0xFF;
            int b = (int)i & 0xFF;
            return new double[]{scale * (double)r / 255.0, scale * (double)g / 255.0, scale * (double)b / 255.0, scale * (double)alpha / 255.0};
        }
        return ChannelOperation.decodeRGBAForSingleNumber(Double.parseDouble(s), scale);
    }

    public static double[] decodeRGBAForSingleNumber(double value) {
        return new double[]{value, value, value, 1.0};
    }

    public static double[] decodeRGBAForSingleNumber(double value, double scale) {
        return new double[]{value *= scale, value, value, scale};
    }

    public static double intensity(double r, double g, double b) {
        if (r == g && r == b) {
            return r;
        }
        return 0.299 * r + 0.587 * g + 0.114 * b;
    }

    public static double correctLittleRoundingError(double probablyInteger) {
        long round = StrictMath.round(probablyInteger);
        return Math.abs(round) >= 1L && Math.abs(probablyInteger - (double)round) < 1.0E-7 ? (double)round : probablyInteger;
    }
}

