/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.multimatrix.MultiMatrix;

public abstract class MultiMatrixGenerator
extends Executor {
    public static final String SAME_ELEMENT_TYPE = "unchanged";
    private int numberOfChannels = 1;
    private long dimX = 64L;
    private long dimY = 64L;
    private long dimZ = 0L;
    private Class<?> elementType = Byte.TYPE;

    protected MultiMatrixGenerator() {
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public final int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public final void setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = MultiMatrixGenerator.positive(numberOfChannels);
    }

    public final long getDimX() {
        return this.dimX;
    }

    public final void setDimX(long dimX) {
        this.dimX = MultiMatrixGenerator.nonNegative(dimX);
    }

    public final long getDimY() {
        return this.dimY;
    }

    public final void setDimY(long dimY) {
        this.dimY = MultiMatrixGenerator.nonNegative(dimY);
    }

    public long getDimZ() {
        return this.dimZ;
    }

    public void setDimZ(long dimZ) {
        this.dimZ = MultiMatrixGenerator.nonNegative(dimZ);
    }

    public final Class<?> getElementType() {
        return this.elementType;
    }

    public final void setElementType(Class<?> elementType) {
        this.elementType = MultiMatrixGenerator.nonNull(elementType);
    }

    public final void setElementType(String elementType) {
        this.setElementType(MultiMatrixGenerator.elementType(elementType));
    }

    @Override
    public void process() {
        this.setStartProcessingTimeStamp();
        MultiMatrix result = this.create();
        this.setEndProcessingTimeStamp();
        this.getMat().setTo(result);
    }

    public abstract MultiMatrix create();

    public static Class<?> elementType(String primitiveElementTypeName) {
        return MultiMatrixGenerator.elementType(primitiveElementTypeName, false);
    }

    public static Class<?> elementType(String primitiveElementTypeName, boolean nullForUnchanged) {
        Objects.requireNonNull(primitiveElementTypeName, "Null element type name");
        if (nullForUnchanged && primitiveElementTypeName.equals(SAME_ELEMENT_TYPE)) {
            return null;
        }
        return switch (primitiveElementTypeName) {
            case "boolean" -> Boolean.TYPE;
            case "byte" -> Byte.TYPE;
            case "short" -> Short.TYPE;
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            default -> throw new IllegalArgumentException("Illegal name of element type");
        };
    }
}

