/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.io.MatrixIO;

public final class ChangeFileExtension
extends ScalarFilter
implements ReadOnlyExecutionInput {
    private String extension = "";
    private boolean preserveWhenEmpty = false;

    public String getExtension() {
        return this.extension;
    }

    public ChangeFileExtension setExtension(String extension) {
        this.extension = ChangeFileExtension.nonNull(extension);
        return this;
    }

    public boolean isPreserveWhenEmpty() {
        return this.preserveWhenEmpty;
    }

    public ChangeFileExtension setPreserveWhenEmpty(boolean preserveWhenEmpty) {
        this.preserveWhenEmpty = preserveWhenEmpty;
        return this;
    }

    @Override
    public SScalar process(SScalar source) {
        String s = source.getValue();
        s = this.changeExtension(s);
        return SScalar.of(s);
    }

    public String changeExtension(String s) {
        if (s == null) {
            return null;
        }
        String extension = this.extension.trim();
        if (!extension.isEmpty()) {
            if (!extension.matches("^[A-Za-z0-9_\\-.]*$")) {
                throw new IllegalArgumentException("Non-allowed extension \"" + extension + "\": only latin letters A-Z, a-z, digits 0-9 and characters '_', '-', '.' are permitted");
            }
            return MatrixIO.removeExtension((String)s) + "." + extension;
        }
        return this.preserveWhenEmpty ? s : MatrixIO.removeExtension((String)s);
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

