/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.FileOperation;

public final class CheckFileExistence
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_IS_EXISTING_FILE = "is_existing_file";
    public static final String OUTPUT_IS_EXISTING_FOLDER = "is_existing_folder";
    private String whenNotExists = "0";
    private String whenExists = "1";

    public CheckFileExistence() {
        this.setFileExistenceRequired(false);
        this.addInputScalar("file");
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_IS_EXISTING_FILE);
        this.addOutputScalar(OUTPUT_IS_EXISTING_FOLDER);
        this.addOutputScalar("absolute_path");
    }

    public String getWhenNotExists() {
        return this.whenNotExists;
    }

    public CheckFileExistence setWhenNotExists(String whenNotExists) {
        this.whenNotExists = whenNotExists;
        return this;
    }

    public String getWhenExists() {
        return this.whenExists;
    }

    public CheckFileExistence setWhenExists(String whenExists) {
        this.whenExists = whenExists;
        return this;
    }

    @Override
    public void process() {
        Path f = this.completeFilePath();
        this.getScalar().setTo(f != null && Files.exists(f, new LinkOption[0]) ? this.whenExists : this.whenNotExists);
        this.getScalar(OUTPUT_IS_EXISTING_FILE).setTo(f != null && Files.isRegularFile(f, new LinkOption[0]) ? this.whenExists : this.whenNotExists);
        this.getScalar(OUTPUT_IS_EXISTING_FOLDER).setTo(f != null && Files.isDirectory(f, new LinkOption[0]) ? this.whenExists : this.whenNotExists);
    }
}

