/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.files.FileSortOrder;
import net.algart.io.MatrixIO;

public final class ListOfFiles
extends FileOperation
implements ReadOnlyExecutionInput {
    private String globPattern = "*.{jpeg,jpg,png,gif,bmp}";
    private String regularExpression = "";
    private FileSortOrder sortOrder = FileSortOrder.SUBDIRECTORIES_FIRST;
    private boolean singlePath = false;
    private boolean recursiveScanning = true;
    private boolean absolutePaths = true;
    private boolean removeExtension = false;

    public ListOfFiles() {
        this.setFileExistenceRequired(false);
        this.addInputScalar("file");
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar("absolute_path");
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public ListOfFiles setGlobPattern(String globPattern) {
        this.globPattern = ListOfFiles.nonEmpty(globPattern);
        return this;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public ListOfFiles setRegularExpression(String regularExpression) {
        this.regularExpression = ListOfFiles.nonNull(regularExpression);
        return this;
    }

    public FileSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public ListOfFiles setSortOrder(FileSortOrder sortOrder) {
        this.sortOrder = ListOfFiles.nonNull(sortOrder);
        return this;
    }

    public boolean isSinglePath() {
        return this.singlePath;
    }

    public ListOfFiles setSinglePath(boolean singlePath) {
        this.singlePath = singlePath;
        return this;
    }

    public boolean isRecursiveScanning() {
        return this.recursiveScanning;
    }

    public ListOfFiles setRecursiveScanning(boolean recursiveScanning) {
        this.recursiveScanning = recursiveScanning;
        return this;
    }

    public boolean isAbsolutePaths() {
        return this.absolutePaths;
    }

    public ListOfFiles setAbsolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
        return this;
    }

    public boolean isRemoveExtension() {
        return this.removeExtension;
    }

    public ListOfFiles setRemoveExtension(boolean removeExtension) {
        this.removeExtension = removeExtension;
        return this;
    }

    @Override
    public void process() {
        this.getScalar().setTo(this.listOfFiles().stream().map(String::valueOf).collect(Collectors.joining("\n")));
    }

    public List<Path> listOfFiles() {
        Path fileOrFolder = this.completeFilePath();
        try {
            ListOfFiles.logDebug(() -> "Reading list of files in " + String.valueOf(fileOrFolder));
            if (this.singlePath || fileOrFolder != null && Files.isRegularFile(fileOrFolder, new LinkOption[0])) {
                return List.of(this.correctPath(fileOrFolder == null ? Path.of("", new String[0]) : fileOrFolder, null));
            }
            if (this.skipIfMissingOrThrow(fileOrFolder, false, () -> "File/folder " + String.valueOf(fileOrFolder) + " does not exist")) {
                return List.of();
            }
            String regularExpression = this.regularExpression.trim();
            Pattern pattern = regularExpression.isEmpty() ? null : Pattern.compile(regularExpression);
            ArrayList<Path> result = new ArrayList<Path>();
            ListOfFiles.findFiles(result, fileOrFolder, this.globPattern, pattern, this.recursiveScanning);
            this.sortOrder.sort(result);
            return result.stream().map(path -> this.correctPath((Path)path, fileOrFolder)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void findFiles(List<Path> result, Path path, String globPattern, Pattern regExp, boolean recursiveScanning) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> files = Files.newDirectoryStream(path, globPattern);){
                for (Path file : files) {
                    if (regExp != null && !regExp.matcher(file.toString().toLowerCase()).matches()) continue;
                    result.add(file);
                }
            }
            if (recursiveScanning) {
                files = Files.newDirectoryStream(path);
                try {
                    for (Path file : files) {
                        ListOfFiles.findFiles(result, file, globPattern, regExp, recursiveScanning);
                    }
                }
                finally {
                    if (files != null) {
                        files.close();
                    }
                }
            }
        }
    }

    private Path correctPath(Path path, Path root) {
        if (this.absolutePaths) {
            path = path.toAbsolutePath();
        } else if (root != null) {
            path = root.relativize(path);
        }
        return this.removeExtension ? Paths.get(MatrixIO.removeExtension((String)path.toString()), new String[0]) : path;
    }
}

