/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.io.MatrixIO;

public final class ResolvePath
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_PATH = "path";
    public static final String OUTPUT_ABSOLUTE_PATH = "absolute_path";
    public static final String OUTPUT_PARENT_FOLDER = "parent_folder";
    public static final String OUTPUT_FILE_NAME = "file_name";
    private String path = "";
    private String childPath = "";
    private SecurityLevel securityLevel = SecurityLevel.HIGH;
    private Operation operation = Operation.NONE;
    private boolean removeExtension = false;

    public ResolvePath() {
        this.setDefaultInputScalar(INPUT_PATH);
        this.setDefaultOutputScalar(OUTPUT_ABSOLUTE_PATH);
        this.addOutputScalar(OUTPUT_PARENT_FOLDER);
        this.addOutputScalar(OUTPUT_FILE_NAME);
    }

    public String getPath() {
        return this.path;
    }

    public ResolvePath setPath(String path) {
        this.path = ResolvePath.nonNull(path);
        return this;
    }

    public String getChildPath() {
        return this.childPath;
    }

    public ResolvePath setChildPath(String childPath) {
        this.childPath = ResolvePath.nonNull(childPath);
        return this;
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public ResolvePath setSecurityLevel(SecurityLevel securityLevel) {
        this.securityLevel = ResolvePath.nonNull(securityLevel);
        return this;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public ResolvePath setOperation(Operation operation) {
        this.operation = ResolvePath.nonNull(operation);
        return this;
    }

    public boolean isRemoveExtension() {
        return this.removeExtension;
    }

    public ResolvePath setRemoveExtension(boolean removeExtension) {
        this.removeExtension = removeExtension;
        return this;
    }

    @Override
    public void process() {
        Path fileName;
        String filePath = PathPropertyReplacement.translateTmpDir(this.filePath());
        PathPropertyReplacement.checkProbableProperties(filePath);
        Path path = Paths.get(filePath, new String[0]);
        PathPropertyReplacement.checkAbsolute(path);
        path = this.resolveResultPath(path);
        PathPropertyReplacement.checkProbableProperties(path.toString());
        this.getScalar(OUTPUT_ABSOLUTE_PATH).setTo(path.toString());
        Path parent = path.getParent();
        if (parent != null) {
            this.getScalar(OUTPUT_PARENT_FOLDER).setTo(parent.toString());
        }
        if ((fileName = path.getFileName()) != null) {
            this.getScalar(OUTPUT_FILE_NAME).setTo(fileName.toString());
        }
        try {
            this.operation.checkOrCreate(path);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private String filePath() {
        String inputPath = this.getInputScalar(INPUT_PATH, true).getValue();
        String result = inputPath != null ? inputPath : this.path;
        return ResolvePath.nonEmpty(result.trim(), INPUT_PATH);
    }

    private Path resolveResultPath(Path path) {
        String childPath = this.childPath.trim();
        if (!childPath.isEmpty()) {
            this.securityLevel.testChild(childPath);
            if (this.removeExtension) {
                childPath = MatrixIO.removeExtension((String)childPath);
            }
            path = path.resolve(childPath);
        }
        return path;
    }

    public static enum SecurityLevel {
        NONE{

            @Override
            public void testChild(String childPath) {
            }
        }
        ,
        MEDIUM{

            @Override
            public void testChild(String childPath) {
                SecurityLevel.checkParent(childPath);
                int length = childPath.length();
                for (int k = 0; k < length; ++k) {
                    char c = childPath.charAt(k);
                    if (c == '_' || c == '-' || c == '.' || c == ' ' || Character.isLetterOrDigit(c)) continue;
                    throw new IllegalArgumentException("Non-allowed child path \"" + childPath + "\": only letters, digits, spaces and characters '_', '-', '.' are permitted");
                }
            }
        }
        ,
        HIGH{

            @Override
            public void testChild(String childPath) {
                SecurityLevel.checkParent(childPath);
                if (!childPath.matches("^[A-Za-z0-9_\\-. ]*$")) {
                    throw new IllegalArgumentException("Non-allowed child path \"" + childPath + "\": only latin letters A-Z, a-z, digits 0-9, spaces and characters '_', '-', '.' are permitted");
                }
            }
        };


        public abstract void testChild(String var1);

        private static void checkParent(String childPath) {
            if (childPath.contains("..")) {
                throw new IllegalArgumentException("Non-allowed child path \"" + childPath + "\": sequence of 2 or more dots \"..\" is prohibited.");
            }
        }
    }

    public static enum Operation {
        NONE(true){

            @Override
            public void checkOrCreate(Path path) {
            }
        }
        ,
        CHECK_EXISTENCE(true){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new FileNotFoundException("\"" + String.valueOf(path) + "\" does not exist");
                }
            }
        }
        ,
        CHECK_FOLDER_EXISTENCE(true){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    throw new FileNotFoundException("\"" + String.valueOf(path) + "\" does not exist or is not a directory");
                }
            }
        }
        ,
        CHECK_FILE_EXISTENCE(true){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new FileNotFoundException("\"" + String.valueOf(path) + "\" does not exist or is not a regular file");
                }
            }
        }
        ,
        CHECK_PARENT_EXISTENCE(true){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                Path parent = path.getParent();
                if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                    throw new FileNotFoundException("\"" + String.valueOf(parent) + "\" (parent folder of \"" + String.valueOf(path) + "\") does not exist or is not a directory");
                }
            }
        }
        ,
        CREATE_FOLDER(false){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectory(path, new FileAttribute[0]);
                }
            }
        }
        ,
        CREATE_FILE(false){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    Files.createFile(path, new FileAttribute[0]);
                }
            }
        }
        ,
        CREATE_PARENT(false){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                Path parent = path.getParent();
                if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                    Files.createDirectory(parent, new FileAttribute[0]);
                }
            }
        }
        ,
        CREATE_FOLDER_WITH_PARENTS(false){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
            }
        }
        ,
        CREATE_FILE_WITH_PARENTS(false){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    Path parent = path.getParent();
                    if (parent != null) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.createFile(path, new FileAttribute[0]);
                }
            }
        }
        ,
        CREATE_PARENTS(false){

            @Override
            public void checkOrCreate(Path path) throws IOException {
                Path parent = path.getParent();
                if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
            }
        };

        private final boolean readOnlyOperation;

        private Operation(boolean readOnlyOperation) {
            this.readOnlyOperation = readOnlyOperation;
        }

        public boolean isReadOnlyOperation() {
            return this.readOnlyOperation;
        }

        public abstract void checkOrCreate(Path var1) throws IOException;
    }
}

