/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public enum AngleDistanceMetric {
    SIN{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2 = Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
            if (r1r2 < 1.0E-10) {
                return 0.0;
            }
            double r1r2sin = x2 * y1 - x1 * y2;
            return r1r2sin / r1r2;
        }
    }
    ,
    SIN_COS{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2Sqr = (x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2);
            if (r1r2Sqr < 1.0E-20) {
                return 0.0;
            }
            double r1r2sin = x2 * y1 - x1 * y2;
            double r1r2cos = x1 * y1 + x2 * y2;
            return r1r2sin * r1r2cos / r1r2Sqr;
        }
    }
    ,
    SIN_SIGNUM_COS{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2 = Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
            if (r1r2 < 1.0E-10) {
                return 0.0;
            }
            double r1r2cos = x1 * y1 + x2 * y2;
            return (r1r2cos >= 0.0 ? x2 * y1 - x1 * y2 : x1 * y2 - x2 * y1) / r1r2;
        }
    }
    ,
    R_SIN{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2 = Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
            if (r1r2 < 1.0E-10) {
                return 0.0;
            }
            double r1r2sin = x2 * y1 - x1 * y2;
            return r1r2sin / Math.sqrt(r1r2);
        }
    }
    ,
    R_SIN_COS{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2 = Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
            if (r1r2 < 1.0E-10) {
                return 0.0;
            }
            double r1r2sin = x2 * y1 - x1 * y2;
            double r1r2cos = x1 * y1 + x2 * y2;
            return r1r2sin * r1r2cos / (r1r2 * Math.sqrt(r1r2));
        }
    }
    ,
    R_SIN_SIGNUM_COS{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2 = Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
            if (r1r2 < 1.0E-10) {
                return 0.0;
            }
            double r1r2cos = x1 * y1 + x2 * y2;
            return (r1r2cos >= 0.0 ? x2 * y1 - x1 * y2 : x1 * y2 - x2 * y1) / Math.sqrt(r1r2);
        }
    }
    ,
    R_R_SIN{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            return x2 * y1 - x1 * y2;
        }
    }
    ,
    R_R_SIN_COS{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2sin = x2 * y1 - x1 * y2;
            double r1r2cos = x1 * y1 + x2 * y2;
            double r1r2 = Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
            if (r1r2 < 1.0E-10) {
                return r1r2sin;
            }
            return r1r2sin * r1r2cos / r1r2;
        }
    }
    ,
    R_R_SIN_SIGNUM_COS{

        @Override
        public double distance(double x1, double y1, double x2, double y2) {
            double r1r2cos = x1 * y1 + x2 * y2;
            return r1r2cos >= 0.0 ? x2 * y1 - x1 * y2 : x1 * y2 - x2 * y1;
        }
    };

    private static final double COMPUTER_EPSILON = 1.0E-10;
    private static final double COMPUTER_EPSILON_SQR = 1.0E-20;

    public abstract double distance(double var1, double var3, double var5, double var7);

    public final Matrix<? extends PArray> asAngleDifference(Matrix<? extends PArray> x1, Matrix<? extends PArray> y1, Matrix<? extends PArray> x2, Matrix<? extends PArray> y2, Class<? extends PArray> requiredType) {
        return Matrices.asFuncMatrix((Func)new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0], x[1], x[2], x[3]);
            }

            public double get(double x1, double y1, double x2, double y2) {
                return AngleDistanceMetric.this.distance(x1, y1, x2, y2);
            }
        }, requiredType, x1, y1, x2, y2);
    }
}

