/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixNormalize2DVector
extends SeveralMultiMatricesOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    public static final String OUTPUT_X = "x";
    public static final String OUTPUT_Y = "y";
    public static final String OUTPUT_MAGNITUDE = "magnitude";
    private static final double COMPUTER_TINY_EPSILON = 1.0E-5;
    private static final Func MAGNITUDE_FUNC = new AbstractFunc(){

        public double get(double ... x) {
            return this.get(x[0], x[1]);
        }

        public double get(double x, double y) {
            return Math.sqrt(x * x + y * y);
        }
    };
    private ResultForZeroVector resultForZeroVector = ResultForZeroVector.X0_Y1;

    public MatrixNormalize2DVector() {
        super("x", "y");
        this.addOutputMat("x");
        this.addOutputMat("y");
        this.setDefaultOutputMat(OUTPUT_MAGNITUDE);
    }

    public ResultForZeroVector getResultForZeroVector() {
        return this.resultForZeroVector;
    }

    public MatrixNormalize2DVector setResultForZeroVector(ResultForZeroVector resultForZeroVector) {
        this.resultForZeroVector = MatrixNormalize2DVector.nonNull(resultForZeroVector);
        return this;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        Objects.requireNonNull(sources, "Null sources");
        Matrix<? extends PArray> x = sources.get(0).asMultiMatrix2D().intensityChannel();
        Matrix<? extends PArray> y = sources.get(1).asMultiMatrix2D().intensityChannel();
        Matrix<? extends PArray> magnitude = this.magnitude(x, y);
        if (this.isOutputNecessary("x")) {
            this.getMat("x").setTo(MultiMatrix.of2DMono(this.normalizeX(x, y, magnitude)));
        }
        if (this.isOutputNecessary("y")) {
            this.getMat("y").setTo(MultiMatrix.of2DMono(this.normalizeY(x, y, magnitude)));
        }
        return MultiMatrix.of2DMono(magnitude);
    }

    public Matrix<? extends PArray> magnitude(Matrix<? extends PArray> x, Matrix<? extends PArray> y) {
        Matrix result = Arrays.SMM.newFloatMatrix(x.dimensions());
        Matrices.applyFunc(null, (Func)MAGNITUDE_FUNC, (Matrix)result, x, y);
        return result;
    }

    public Matrix<? extends PArray> normalizeX(Matrix<? extends PArray> x, Matrix<? extends PArray> y, Matrix<? extends PArray> magnitude) {
        return this.normalizeXY(x, y, magnitude, true);
    }

    public Matrix<? extends PArray> normalizeY(Matrix<? extends PArray> x, Matrix<? extends PArray> y, Matrix<? extends PArray> magnitude) {
        return this.normalizeXY(x, y, magnitude, false);
    }

    private Matrix<? extends PArray> normalizeXY(Matrix<? extends PArray> x, Matrix<? extends PArray> y, Matrix<? extends PArray> magnitude, final boolean xComponent) {
        return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0], x[1], x[2]);
            }

            public double get(double xOrY, double secondFromXOrY, double magnitude) {
                assert (magnitude >= 0.0);
                if (magnitude <= 1.0E-5 && magnitude >= -1.0E-5) {
                    return MatrixNormalize2DVector.this.resultForZeroVector.normalizeTiny(xOrY, secondFromXOrY, xComponent);
                }
                return xOrY / magnitude;
            }
        }, FloatArray.class, xComponent ? x : y, xComponent ? y : x, magnitude));
    }

    public static enum ResultForZeroVector {
        ZERO(0.0, 0.0),
        X1_Y0(1.0, 0.0),
        X0_Y1(0.0, 1.0),
        NAN(Double.NaN, Double.NaN);

        private final double defaultX;
        private final double defaultY;

        private ResultForZeroVector(double defaultX, double defaultY) {
            this.defaultX = defaultX;
            this.defaultY = defaultY;
        }

        double normalizeTiny(double xOrY, double secondFromXOrY, boolean xComponent) {
            if (xOrY == 0.0) {
                if (secondFromXOrY == 0.0) {
                    return xComponent ? this.defaultX : this.defaultY;
                }
                return 0.0;
            }
            if (secondFromXOrY == 0.0) {
                return xOrY > 0.0 ? 1.0 : -1.0;
            }
            double magnitude = Math.hypot(xOrY, secondFromXOrY);
            return xOrY / magnitude;
        }
    }
}

