/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.multimatrix.MultiMatrix;

public final class ChangeNumberOfChannels
extends MultiMatrixFilter {
    private boolean inputRequired = false;
    private int numberOfChannels = 0;
    private boolean fillAlphaWithMaxValue = false;

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public ChangeNumberOfChannels setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public ChangeNumberOfChannels setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = ChangeNumberOfChannels.nonNegative(numberOfChannels);
        return this;
    }

    public boolean isFillAlphaWithMaxValue() {
        return this.fillAlphaWithMaxValue;
    }

    public ChangeNumberOfChannels setFillAlphaWithMaxValue(boolean fillAlphaWithMaxValue) {
        this.fillAlphaWithMaxValue = fillAlphaWithMaxValue;
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        if (source == null) {
            return null;
        }
        if (this.numberOfChannels == 0) {
            return source;
        }
        ChangeNumberOfChannels.logDebug(() -> "Changing number of channels " + source.numberOfChannels() + " -> " + this.numberOfChannels + " for matrix " + String.valueOf(source));
        return source.asOtherNumberOfChannels(this.numberOfChannels, this.fillAlphaWithMaxValue).clone();
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return !this.inputRequired;
    }

    @Override
    protected boolean resultRequired() {
        return this.inputRequired;
    }
}

