/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.math.Point;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.Morphology;
import net.algart.multimatrix.MultiMatrix;

public final class FindValue
extends MultiMatrixFilter {
    private static final Func IS_NAN = new AbstractFunc(){

        public double get(double ... x) {
            return Double.isNaN(x[0]) ? 1.0 : 0.0;
        }

        public double get(double x0) {
            return Double.isNaN(x0) ? 1.0 : 0.0;
        }
    };
    private static final Func IS_INFINITY = new AbstractFunc(){

        public double get(double ... x) {
            return Double.isInfinite(x[0]) ? 1.0 : 0.0;
        }

        public double get(double x0) {
            return Double.isInfinite(x0) ? 1.0 : 0.0;
        }
    };
    private ValueKind valueKind = ValueKind.NON_ZERO;
    private boolean checkOnlyRGBChannels = true;
    private double customValue = 0.0;
    private int dilationSize = 0;

    public ValueKind getValueKind() {
        return this.valueKind;
    }

    public FindValue setValueKind(ValueKind valueKind) {
        this.valueKind = FindValue.nonNull(valueKind);
        return this;
    }

    public boolean isCheckOnlyRGBChannels() {
        return this.checkOnlyRGBChannels;
    }

    public FindValue setCheckOnlyRGBChannels(boolean checkOnlyRGBChannels) {
        this.checkOnlyRGBChannels = checkOnlyRGBChannels;
        return this;
    }

    public double getCustomValue() {
        return this.customValue;
    }

    public FindValue setCustomValue(double customValue) {
        this.customValue = customValue;
        return this;
    }

    public int getDilationSize() {
        return this.dilationSize;
    }

    public FindValue setDilationSize(int dilationSize) {
        this.dilationSize = FindValue.nonNegative(dilationSize);
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        MultiMatrix binaryResult = this.valueKind.find(source, this.checkOnlyRGBChannels, this.customValue);
        if (this.dilationSize > 0) {
            ContinuedMorphology morphology = ContinuedMorphology.getInstance((Morphology)BasicMorphology.getInstance(null), (Matrix.ContinuationMode)Matrix.ContinuationMode.ZERO_CONSTANT);
            UniformGridPattern pattern = Patterns.newSphereIntegerPattern((Point)Point.origin((int)binaryResult.dimCount()), (double)Math.max(0.0, 0.5 * (double)(this.dilationSize + 1) - 0.2));
            binaryResult = binaryResult.apply(arg_0 -> FindValue.lambda$process$0((Morphology)morphology, (Pattern)pattern, arg_0));
        }
        return binaryResult;
    }

    private static /* synthetic */ Matrix lambda$process$0(Morphology morphology, Pattern pattern, Matrix m) {
        return morphology.dilation(m, pattern);
    }

    public static enum ValueKind {
        ZERO{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.zeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        NON_ZERO{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.nonZeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        NAN{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.asFunc(IS_NAN, FloatArray.class).nonZeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        INFINITY{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.asFunc(IS_INFINITY, FloatArray.class).nonZeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        EQUAL_TO_RAW_CUSTOM{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.asFunc((Func)LinearFunc.getInstance((double)customValue, (double[])new double[]{-1.0}), DoubleArray.class).zeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        NONEQUAL_TO_RAW_CUSTOM{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.asFunc((Func)LinearFunc.getInstance((double)customValue, (double[])new double[]{-1.0}), DoubleArray.class).nonZeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        EQUAL_TO_NORMALIZED_CUSTOM{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.asPrecision(Double.TYPE).asFunc((Func)LinearFunc.getInstance((double)customValue, (double[])new double[]{-1.0}), DoubleArray.class).zeroPixels(checkOnlyRGBChannels);
            }
        }
        ,
        NONEQUAL_TO_NORMALIZED_CUSTOM{

            @Override
            MultiMatrix find(MultiMatrix source, boolean checkOnlyRGBChannels, double customValue) {
                return source.asPrecision(Double.TYPE).asFunc((Func)LinearFunc.getInstance((double)customValue, (double[])new double[]{-1.0}), DoubleArray.class).nonZeroPixels(checkOnlyRGBChannels);
            }
        };


        abstract MultiMatrix find(MultiMatrix var1, boolean var2, double var3);
    }
}

