/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.awt.AWTDrawer;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.matrices.drawing.PositionsAndColors;

public final class DrawLine
extends AWTDrawer {
    public static final String INPUT_POSITIONS = "positions";
    public static final String INPUT_PAIRS_OF_INDEXES_OF_POINTS = "pairs_of_indexes_of_points";
    public static final String INPUT_COLORS = "colors";
    private boolean percents = false;
    private double x1 = 0.0;
    private double y1 = 0.0;
    private double x2 = 0.0;
    private double y2 = 0.0;
    private double thickness = 1.0;
    private double lengthIncrement = 0.0;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public DrawLine() {
        this.addInputNumbers(INPUT_POSITIONS);
        this.addInputNumbers(INPUT_PAIRS_OF_INDEXES_OF_POINTS);
        this.addInputNumbers(INPUT_COLORS);
    }

    public boolean isPercents() {
        return this.percents;
    }

    public DrawLine setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX1() {
        return this.x1;
    }

    public DrawLine setX1(double x1) {
        this.x1 = x1;
        return this;
    }

    public double getY1() {
        return this.y1;
    }

    public DrawLine setY1(double y1) {
        this.y1 = y1;
        return this;
    }

    public double getX2() {
        return this.x2;
    }

    public DrawLine setX2(double x2) {
        this.x2 = x2;
        return this;
    }

    public double getY2() {
        return this.y2;
    }

    public DrawLine setY2(double y2) {
        this.y2 = y2;
        return this;
    }

    public double getThickness() {
        return this.thickness;
    }

    public DrawLine setThickness(double thickness) {
        this.thickness = DrawLine.nonNegative(thickness);
        return this;
    }

    public double getLengthIncrement() {
        return this.lengthIncrement;
    }

    public DrawLine setLengthIncrement(double lengthIncrement) {
        this.lengthIncrement = lengthIncrement;
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public DrawLine setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = DrawLine.nonNull(indexingBase);
        return this;
    }

    @Override
    public void process(Graphics2D g, int dimX, int dimY) {
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        SNumbers pairsOfIndexes = this.getInputNumbers(INPUT_PAIRS_OF_INDEXES_OF_POINTS, true);
        if (pairsOfIndexes.isInitialized()) {
            DrawLine.translatePairsOfIndexes(positions, pairsOfIndexes, this.indexingBase);
        }
        SNumbers colors = this.getInputNumbers(INPUT_COLORS, true);
        double defaultX1 = this.percents ? this.x1 / 100.0 * (double)(dimX - 1) : this.x1;
        double defaultY1 = this.percents ? this.y1 / 100.0 * (double)(dimY - 1) : this.y1;
        double defaultX2 = this.percents ? this.x2 / 100.0 * (double)(dimX - 1) : this.x2;
        double defaultY2 = this.percents ? this.y2 / 100.0 * (double)(dimY - 1) : this.y2;
        PositionsAndColors positionsAndColors = new PositionsAndColors(positions, colors, new double[]{defaultX1, defaultY1, defaultX2, defaultY2}, Double.NaN, 4);
        g.setStroke(new BasicStroke((float)this.thickness));
        for (int k = 0; k < positionsAndColors.n; ++k) {
            double[] x1y1x2y2 = positionsAndColors.xyAndOthers(k);
            DrawLine.increaseLength(x1y1x2y2, this.lengthIncrement);
            float[] rgb = positionsAndColors.colorRGB(k);
            g.setColor(rgb == null ? this.getColor() : new Color(DrawLine.truncateColor01(rgb[0]), DrawLine.truncateColor01(rgb[1]), DrawLine.truncateColor01(rgb[2])));
            g.drawLine((int)x1y1x2y2[0], (int)x1y1x2y2[1], (int)x1y1x2y2[2], (int)x1y1x2y2[3]);
        }
    }

    public static void translatePairsOfIndexes(SNumbers positions, SNumbers pairsOfIndexes, IndexingBase indexingBase) {
        if (pairsOfIndexes.getBlockLength() != 2) {
            throw new IllegalArgumentException("Pairs of indexes must contain 2 elements per block");
        }
        int positionsBlockLength = positions.getBlockLength();
        int numberOfPositions = positions.n();
        if (positionsBlockLength < 2) {
            throw new IllegalArgumentException("Positions of points must contain at least 2 elements per block (x, y)");
        }
        int n = pairsOfIndexes.n();
        int[] pairsOfIndexesArray = pairsOfIndexes.toIntArray();
        double[] positionsArray = positions.toDoubleArray();
        SNumbers.checkDimensions(n, 4L);
        double[] result = new double[4 * n];
        int minIndex = indexingBase.start;
        int maxIndex = numberOfPositions - 1 + indexingBase.start;
        int disp = 0;
        for (int k = 0; k < n; ++k) {
            int i1 = pairsOfIndexesArray[2 * k];
            int i2 = pairsOfIndexesArray[2 * k + 1];
            if (i1 < minIndex || i1 > maxIndex) {
                throw new IndexOutOfBoundsException("Invalid point index " + i1 + ": not in range " + minIndex + ".." + maxIndex);
            }
            if (i2 < minIndex || i2 > maxIndex) {
                throw new IndexOutOfBoundsException("Invalid point index " + i2 + ": not in range " + minIndex + ".." + maxIndex);
            }
            int disp1 = (i1 - minIndex) * positionsBlockLength;
            int disp2 = (i2 - minIndex) * positionsBlockLength;
            result[disp++] = positionsArray[disp1];
            result[disp++] = positionsArray[disp1 + 1];
            result[disp++] = positionsArray[disp2];
            result[disp++] = positionsArray[disp2 + 1];
        }
        positions.setTo(result, 4);
    }

    public static void increaseLength(double[] x1y1x2y2, double lengthIncrement) {
        if (lengthIncrement == 0.0) {
            return;
        }
        double x1 = x1y1x2y2[0];
        double x2 = x1y1x2y2[2];
        double y1 = x1y1x2y2[1];
        double y2 = x1y1x2y2[3];
        double centerX = 0.5 * (x1 + x2);
        double centerY = 0.5 * (y1 + y2);
        double length = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        if (length == 0.0) {
            return;
        }
        double scale = (length + lengthIncrement) / length;
        x1y1x2y2[0] = centerX + scale * (x1 - centerX);
        x1y1x2y2[2] = centerX + scale * (x2 - centerX);
        x1y1x2y2[1] = centerY + scale * (y1 - centerY);
        x1y1x2y2[3] = centerY + scale * (y2 - centerY);
    }
}

