/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.drawing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import net.algart.executors.modules.core.common.awt.AWTDrawer;

public final class DrawText
extends AWTDrawer {
    private boolean percents = false;
    private double x = 0.0;
    private double y = 0.0;
    private String fontName = "SansSerif";
    private int fontSize = 16;
    private boolean italic = false;
    private boolean bold = false;
    private boolean renderHTML = false;
    private String text = "";

    public boolean isPercents() {
        return this.percents;
    }

    public DrawText setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public DrawText setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public DrawText setY(double y) {
        this.y = y;
        return this;
    }

    public String getFontName() {
        return this.fontName;
    }

    public DrawText setFontName(String fontName) {
        this.fontName = DrawText.nonEmpty(fontName);
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public DrawText setFontSize(int fontSize) {
        this.fontSize = DrawText.nonNegative(fontSize);
        return this;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public DrawText setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public boolean isBold() {
        return this.bold;
    }

    public DrawText setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public boolean isRenderHTML() {
        return this.renderHTML;
    }

    public DrawText setRenderHTML(boolean renderHTML) {
        this.renderHTML = renderHTML;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public DrawText setText(String text) {
        this.text = DrawText.nonNull(text);
        return this;
    }

    @Override
    public void process(Graphics2D g, int dimX, int dimY) {
        double x = this.percents ? this.x / 100.0 * (double)(dimX - 1) : this.x;
        double y = this.percents ? this.y / 100.0 * (double)(dimY - 1) : this.y;
        g.translate(x, y);
        int fontStyle = (this.bold ? 1 : 0) | (this.italic ? 2 : 0);
        Font font = new Font(this.fontName, fontStyle, this.fontSize);
        g.setFont(font);
        Object text = this.text;
        if (this.renderHTML) {
            if (!((String)text).startsWith("<html>")) {
                text = "<html>" + (String)text;
            }
            JLabel label = new JLabel();
            label.setForeground(this.getColor());
            label.setText((String)text);
            Dimension size = label.getPreferredSize();
            label.setBounds(0, 0, size.width, size.height);
            label.paint(g);
        } else {
            int h = g.getFontMetrics().getHeight();
            g.drawString((String)text, 0, h);
        }
    }
}

