/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.awt.image.BufferedImage;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.matrices.io.MatReader;
import net.algart.io.MatrixIO;
import net.algart.io.UnsupportedImageFormatException;

public final class ReadImage
extends FileOperation
implements ReadOnlyExecutionInput,
MatReader {
    public static final String DEFAULT_HELPER_CLASS = ReadImage.class.getName().replace("." + ReadImage.class.getSimpleName(), ".helpers.DefaultMatReaderHelper");
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    private int numberOfChannels = 0;
    private boolean useHelperClass = true;

    public ReadImage() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
    }

    public static ReadImage getInstance() {
        return new ReadImage();
    }

    public static ReadImage getSecureInstance() {
        ReadImage result = new ReadImage();
        result.setSecure(true);
        return result;
    }

    @Override
    public ReadImage setFile(String file) {
        super.setFile(file);
        return this;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public ReadImage setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = ReadImage.nonNegative(numberOfChannels);
        return this;
    }

    public boolean isUseHelperClass() {
        return this.useHelperClass;
    }

    public ReadImage setUseHelperClass(boolean useHelperClass) {
        this.useHelperClass = useHelperClass;
        return this;
    }

    @Override
    public void process() {
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        SMat result = this.getMat();
        if (input.isInitialized()) {
            ReadImage.logDebug(() -> "Copying " + String.valueOf(input));
            result.setTo(input);
        } else {
            try {
                this.readMat(result);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        this.getScalar(OUTPUT_DIM_X).setTo(result.getDimX());
        this.getScalar(OUTPUT_DIM_Y).setTo(result.getDimY());
    }

    public SMat readImage() throws IOException {
        return this.readMat(new SMat());
    }

    public SMat readMat(SMat result) throws IOException {
        this.readMat(result, this.completeFilePath());
        return result;
    }

    @Override
    public void readMat(SMat result, Path path) throws IOException {
        Objects.requireNonNull(result, "Null result");
        try {
            BufferedImage bufferedImage = this.readBufferedImage(path);
            assert (bufferedImage != null || !this.isFileExistenceRequired()) : "Impossible when fileExistenceRequired";
            result.setToOrRemove(bufferedImage);
        }
        catch (UnsupportedImageFormatException e) {
            MatReader helper;
            if (!this.useHelperClass) {
                throw e;
            }
            try {
                helper = (MatReader)Class.forName(DEFAULT_HELPER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception helperException) {
                Executor.LOG.log(System.Logger.Level.DEBUG, () -> "Java image I/O failed; attempt to use the helper \"" + DEFAULT_HELPER_CLASS + "\" also failed: " + String.valueOf(helperException), (Throwable)helperException);
                throw e;
            }
            try {
                helper.readMat(result, path);
            }
            catch (UnsupportedImageFormatException suppressed) {
                e.addSuppressed((Throwable)suppressed);
                throw e;
            }
        }
        if (this.numberOfChannels != 0) {
            result.setTo(result.toMultiMatrix().asOtherNumberOfChannels(this.numberOfChannels));
        }
    }

    public BufferedImage readBufferedImage() throws IOException {
        return this.readBufferedImage(this.completeFilePath());
    }

    public BufferedImage readBufferedImage(Path path) throws IOException {
        if (this.skipIfMissing(path, true)) {
            return null;
        }
        ReadImage.logDebug(() -> "Reading image from " + String.valueOf(path) + " by Java API (ImageIO)");
        return MatrixIO.readBufferedImage((Path)path);
    }
}

