/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.function.DoubleUnaryOperator;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.numbers.NumberArrayFilter;
import net.algart.math.functions.ExpFunc;
import net.algart.math.functions.Func;

public final class NumbersExponent
extends NumberArrayFilter
implements ReadOnlyExecutionInput {
    private ExponentBase exponentBase = ExponentBase.BASE_10;
    private double customBase = 2.0;

    public ExponentBase getExponentBase() {
        return this.exponentBase;
    }

    public NumbersExponent setExponentBase(ExponentBase exponentBase) {
        this.exponentBase = NumbersExponent.nonNull(exponentBase);
        return this;
    }

    public double getCustomBase() {
        return this.customBase;
    }

    public NumbersExponent setCustomBase(double customBase) {
        this.customBase = customBase;
        return this;
    }

    @Override
    public PArray process(UpdatablePNumberArray array, int blockLength, int numberOfBlocks) {
        double base = this.exponentBase.baseProducer.applyAsDouble(this.customBase);
        return Arrays.clone((PArray)Arrays.asFuncArray((Func)ExpFunc.getInstance((double)base), NumbersExponent.resultClass((PArray)array), (PArray[])new PArray[]{array}));
    }

    static Class<? extends PArray> resultClass(PArray array) {
        return array instanceof DoubleArray ? DoubleArray.class : FloatArray.class;
    }

    public static enum ExponentBase {
        BASE_10(operand -> 10.0),
        BASE_E(operand -> Math.E),
        CUSTOM(operand -> operand);

        private final DoubleUnaryOperator baseProducer;

        private ExponentBase(DoubleUnaryOperator baseProducer) {
            this.baseProducer = baseProducer;
        }
    }
}

