/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import java.util.stream.Collectors;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.OptionalArguments;
import net.algart.executors.modules.core.common.numbers.SeveralNumberArraysOperation;
import net.algart.executors.modules.core.scalars.arithmetic.ProductOfTwoPowers;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;

public final class NumbersSumOfPowers
extends SeveralNumberArraysOperation
implements ReadOnlyExecutionInput {
    private double power = 2.0;
    private double powerOfSum = 0.5;
    private double dividerOfSum = 1.0;

    public NumbersSumOfPowers() {
        super(new String[0]);
    }

    public double getPower() {
        return this.power;
    }

    public NumbersSumOfPowers setPower(double power) {
        this.power = power;
        return this;
    }

    public NumbersSumOfPowers setPower(String power) {
        return this.setPower(ProductOfTwoPowers.smartParseDouble(power));
    }

    public double getPowerOfSum() {
        return this.powerOfSum;
    }

    public NumbersSumOfPowers setPowerOfSum(double powerOfSum) {
        this.powerOfSum = powerOfSum;
        return this;
    }

    public NumbersSumOfPowers setPowerOfSum(String powerOfSum) {
        return this.setPowerOfSum(ProductOfTwoPowers.smartParseDouble(powerOfSum));
    }

    public double getDividerOfSum() {
        return this.dividerOfSum;
    }

    public NumbersSumOfPowers setDividerOfSum(double dividerOfSum) {
        this.dividerOfSum = dividerOfSum;
        return this;
    }

    @Override
    public PArray process(List<PNumberArray> sources, int ... blockLengths) {
        List<PNumberArray> nonNull = new OptionalArguments<PNumberArray>(sources).extract();
        PowerFunc powerFunc = PowerFunc.getInstance((double)this.power, (double)(1.0 / this.dividerOfSum));
        LinearFunc averagingFunc = LinearFunc.getNonweightedInstance((double)0.0, (double)1.0, (int)nonNull.size());
        PowerFunc sumPowerFunc = PowerFunc.getInstance((double)this.powerOfSum);
        List<PArray> powered = nonNull.stream().map(array -> (DoubleArray)Arrays.asFuncArray((Func)powerFunc, DoubleArray.class, (PArray[])new PArray[]{array})).collect(Collectors.toList());
        PArray sum = Arrays.asFuncArray((Func)averagingFunc, DoubleArray.class, (PArray[])powered.toArray(new PArray[0]));
        return Arrays.asFuncArray((Func)sumPowerFunc, FloatArray.class, (PArray[])new PArray[]{sum});
    }
}

