/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.stream.IntStream;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class NumbersTrigonometry
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_SIN = "sin";
    public static final String OUTPUT_COS = "cos";
    public static final String OUTPUT_TAN = "tan";
    public static final String OUTPUT_ASIN = "asin";
    public static final String OUTPUT_ACOS = "acos";
    public static final String OUTPUT_ATAN = "atan";
    private boolean degrees = false;
    private double resultMultiplier = 1.0;

    public NumbersTrigonometry() {
        this.useVisibleResultParameter();
        this.removeOutputPort(DEFAULT_OUTPUT_PORT);
        this.addOutputNumbers(OUTPUT_SIN);
        this.addOutputNumbers(OUTPUT_COS);
        this.addOutputNumbers(OUTPUT_TAN);
        this.addOutputNumbers(OUTPUT_ASIN);
        this.addOutputNumbers(OUTPUT_ACOS);
        this.addOutputNumbers(OUTPUT_ATAN);
    }

    public boolean isDegrees() {
        return this.degrees;
    }

    public NumbersTrigonometry setDegrees(boolean degrees) {
        this.degrees = degrees;
        return this;
    }

    public double getResultMultiplier() {
        return this.resultMultiplier;
    }

    public NumbersTrigonometry setResultMultiplier(double resultMultiplier) {
        this.resultMultiplier = resultMultiplier;
        return this;
    }

    @Override
    protected SNumbers processNumbers(SNumbers sourceNumbers) {
        float[] source = sourceNumbers.toFloatArray();
        float[] result = new float[source.length];
        if (this.isOutputNecessary(OUTPUT_SIN)) {
            this.sin(source, result);
            this.getNumbers(OUTPUT_SIN).setTo(result, sourceNumbers.getBlockLength());
        }
        if (this.isOutputNecessary(OUTPUT_COS)) {
            this.cos(source, result);
            this.getNumbers(OUTPUT_COS).setTo(result, sourceNumbers.getBlockLength());
        }
        if (this.isOutputNecessary(OUTPUT_TAN)) {
            this.tan(source, result);
            this.getNumbers(OUTPUT_TAN).setTo(result, sourceNumbers.getBlockLength());
        }
        if (this.isOutputNecessary(OUTPUT_ASIN)) {
            this.asin(source, result);
            this.getNumbers(OUTPUT_ASIN).setTo(result, sourceNumbers.getBlockLength());
        }
        if (this.isOutputNecessary(OUTPUT_ACOS)) {
            this.acos(source, result);
            this.getNumbers(OUTPUT_ACOS).setTo(result, sourceNumbers.getBlockLength());
        }
        if (this.isOutputNecessary(OUTPUT_ATAN)) {
            this.atan(source, result);
            this.getNumbers(OUTPUT_ATAN).setTo(result, sourceNumbers.getBlockLength());
        }
        return null;
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    private void sin(float[] source, float[] result) {
        IntStream.range(0, source.length + 255 >>> 8).parallel().forEach(block -> {
            if (this.degrees) {
                this.sinBlockDegrees(source, result, block);
            } else {
                this.sinBlockRadians(source, result, block);
            }
        });
    }

    private void sinBlockDegrees(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.sin(Math.toRadians(source[i])));
        }
    }

    private void sinBlockRadians(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.sin(source[i]));
        }
    }

    private void cos(float[] source, float[] result) {
        IntStream.range(0, source.length + 255 >>> 8).parallel().forEach(block -> {
            if (this.degrees) {
                this.cosBlockDegrees(source, result, block);
            } else {
                this.cosBlockRadians(source, result, block);
            }
        });
    }

    private void cosBlockDegrees(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.cos(Math.toRadians(source[i])));
        }
    }

    private void cosBlockRadians(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.cos(source[i]));
        }
    }

    private void tan(float[] source, float[] result) {
        IntStream.range(0, source.length + 255 >>> 8).parallel().forEach(block -> {
            if (this.degrees) {
                this.tanBlockDegrees(source, result, block);
            } else {
                this.tanBlockRadians(source, result, block);
            }
        });
    }

    private void tanBlockDegrees(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.tan(Math.toRadians(source[i])));
        }
    }

    private void tanBlockRadians(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.tan(source[i]));
        }
    }

    private void asin(float[] source, float[] result) {
        IntStream.range(0, source.length + 255 >>> 8).parallel().forEach(block -> {
            if (this.degrees) {
                this.asinBlockDegrees(source, result, block);
            } else {
                this.asinBlockRadians(source, result, block);
            }
        });
    }

    private void asinBlockDegrees(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.toDegrees(Math.asin(source[i])));
        }
    }

    private void asinBlockRadians(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.asin(source[i]));
        }
    }

    private void acos(float[] source, float[] result) {
        IntStream.range(0, source.length + 255 >>> 8).parallel().forEach(block -> {
            if (this.degrees) {
                this.acosBlockDegrees(source, result, block);
            } else {
                this.acosBlockRadians(source, result, block);
            }
        });
    }

    private void acosBlockDegrees(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.toDegrees(Math.acos(source[i])));
        }
    }

    private void acosBlockRadians(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.acos(source[i]));
        }
    }

    private void atan(float[] source, float[] result) {
        IntStream.range(0, source.length + 255 >>> 8).parallel().forEach(block -> {
            if (this.degrees) {
                this.atanBlockDegrees(source, result, block);
            } else {
                this.atanBlockRadians(source, result, block);
            }
        });
    }

    private void atanBlockDegrees(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.toDegrees(Math.atan(source[i])));
        }
    }

    private void atanBlockRadians(float[] source, float[] result, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)source.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = (float)(this.resultMultiplier * Math.atan(source[i]));
        }
    }
}

