/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumberArrayFilter;

public final class CastNumbers
extends NumberArrayFilter
implements ReadOnlyExecutionInput {
    private Class<?> elementType = Float.TYPE;

    public Class<?> getElementType() {
        return this.elementType;
    }

    public CastNumbers setElementType(Class<?> elementType) {
        this.elementType = CastNumbers.nonNull(elementType, "element type");
        return this;
    }

    public CastNumbers setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    @Override
    public SNumbers process(SNumbers input) {
        return input.toPrecision(this.elementType);
    }

    @Override
    public PArray process(UpdatablePNumberArray array, int blockLength, int numberOfBlocks) {
        SNumbers numbers = SNumbers.ofArray(array.toJavaArray(), 1);
        numbers = numbers.toPrecision(this.elementType);
        return (PNumberArray)SimpleMemoryModel.asUpdatableArray((Object)numbers.getArray());
    }
}

