/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;

public final class ExtractNumbersColumnsByNames
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_COLUMN_NAMES = "column_names";
    public static final String OUTPUT_COLUMN_NAMES = "column_names";
    public static final String OUTPUT_COLUMN_PREFIX = "column_";
    private String extractedColumnNames = "";

    public ExtractNumbersColumnsByNames() {
        this.useVisibleResultParameter();
        this.setDefaultInputNumbers(DEFAULT_INPUT_PORT);
        this.addInputScalar("column_names");
        this.setDefaultOutputNumbers(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar("column_names");
    }

    public String getExtractedColumnNames() {
        return this.extractedColumnNames;
    }

    public ExtractNumbersColumnsByNames setExtractedColumnNames(String extractedColumnNames) {
        this.extractedColumnNames = ExtractNumbersColumnsByNames.nonNull(extractedColumnNames);
        return this;
    }

    @Override
    public void process() {
        String portName;
        SNumbers source = this.getInputNumbers();
        List<String> columnNames = this.getInputScalar("column_names", true).toTrimmedLinesWithoutComments();
        List<String> extractedNames = SScalar.splitJsonOrTrimmedLinesWithoutComments(this.extractedColumnNames);
        ArrayList<SNumbers> resultList = new ArrayList<SNumbers>();
        int k = 0;
        while (this.hasOutputPort(portName = this.outputPortName(k))) {
            resultList.add(this.isOutputNecessary(portName) ? this.getNumbers(portName) : null);
            ++k;
        }
        int[] columnIndexes = this.findColumnIndexes(columnNames, extractedNames, source.blockLength());
        SNumbers result = this.isOutputNecessary(DEFAULT_OUTPUT_PORT) ? this.getNumbers() : null;
        long t1 = ExtractNumbersColumnsByNames.debugTime();
        this.extractColumns(result, resultList, source, columnIndexes);
        long t2 = ExtractNumbersColumnsByNames.debugTime();
        ExtractNumbersColumnsByNames.logDebug(() -> String.format(Locale.US, "Extracting %d columns %s by names from number array %s: %.3f ms (%.1f ns/block)", columnIndexes.length, extractedNames.stream().collect(Collectors.joining("\", \"", "\"", "\"")), source, (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / (double)source.n()));
        this.getScalar("column_names").setTo(String.join((CharSequence)"\n", extractedNames));
    }

    public int[] findColumnIndexes(List<String> columnNames, List<String> extractedNames, int blockLength) {
        Objects.requireNonNull(extractedNames, "Null extractedNames");
        if (blockLength < 1) {
            throw new IllegalArgumentException("Zero or negative " + blockLength);
        }
        int[] result = new int[extractedNames.size()];
        int k = 0;
        for (String extractedName : extractedNames) {
            int index;
            ++k;
            try {
                index = Integer.parseInt(extractedName);
            }
            catch (NumberFormatException ignored) {
                Objects.requireNonNull(columnNames, "No column names parameter, but it is required to find the result column #" + k + " by its name \"" + extractedName + "\"");
                index = columnNames.indexOf(extractedName);
                if (index == -1) {
                    throw new IllegalArgumentException("Name \"" + extractedName + "\" of the result column #" + k + " is not found in the full list of column names");
                }
                ++index;
            }
            if (index == 0) {
                throw new IllegalArgumentException("Zero index is not allowed (result column #" + k + ")");
            }
            if (Math.abs(index) > blockLength) {
                throw new IllegalArgumentException("Index " + index + " of column \"" + extractedName + "\" is out of range -blockLength..blockLength = -" + blockLength + ".." + blockLength + " (result column #" + k + ")");
            }
            result[k - 1] = index >= 0 ? index - 1 : blockLength + index;
        }
        return result;
    }

    public void extractColumns(SNumbers result, List<SNumbers> resultColumns, SNumbers source, int[] columnIndexes) {
        Objects.requireNonNull(source, "Null source");
        Objects.requireNonNull(columnIndexes, "Null columnIndexes");
        Objects.requireNonNull(resultColumns, "Null resultColumns");
        SNumbers[] resultColumnArray = resultColumns.toArray(new SNumbers[0]);
        int n = source.n();
        Object[] javaArraysForResultColumns = new Object[resultColumns.size()];
        Arrays.setAll(javaArraysForResultColumns, k -> k >= columnIndexes.length || resultColumnArray[k] == null ? null : source.newCompatibleJavaArray(n));
        source.columnsByIndexes(result, javaArraysForResultColumns, columnIndexes);
        for (int k2 = 0; k2 < resultColumnArray.length; ++k2) {
            if (javaArraysForResultColumns[k2] == null) continue;
            resultColumnArray[k2].setToArray(javaArraysForResultColumns[k2], 1);
        }
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return super.visibleResultsInformation().addPorts(this.getOutputPort("column_names"));
    }

    private String outputPortName(int inputIndex) {
        return OUTPUT_COLUMN_PREFIX + (inputIndex + 1);
    }
}

