/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.core.numbers.conversions.JsonToIndexValueTable;
import net.algart.json.Jsons;

public final class JsonToColorPalette
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_JSON_PALETTE = "json_palette";
    public static final String INPUT_JSON_NAMED_INDEXES = "json_named_indexes";
    public static final String OUTPUT_PALETTE = "palette";
    private int numberOfChannels = 3;
    private String defaultColor = "#000000";
    private double defaultValueForExtraChannels = 1.0;
    private int indexingBase = 0;

    public JsonToColorPalette() {
        this.setDefaultInputScalar(INPUT_JSON_PALETTE);
        this.addInputScalar(INPUT_JSON_NAMED_INDEXES);
        this.setDefaultOutputNumbers(OUTPUT_PALETTE);
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public JsonToColorPalette setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = JsonToColorPalette.positive(numberOfChannels);
        return this;
    }

    public String getDefaultColor() {
        return this.defaultColor;
    }

    public JsonToColorPalette setDefaultColor(String defaultColor) {
        this.defaultColor = JsonToColorPalette.nonNull(defaultColor);
        return this;
    }

    public double getDefaultValueForExtraChannels() {
        return this.defaultValueForExtraChannels;
    }

    public JsonToColorPalette setDefaultValueForExtraChannels(double defaultValueForExtraChannels) {
        this.defaultValueForExtraChannels = defaultValueForExtraChannels;
        return this;
    }

    public int getIndexingBase() {
        return this.indexingBase;
    }

    public JsonToColorPalette setIndexingBase(int indexingBase) {
        this.indexingBase = JsonToColorPalette.nonNegative(indexingBase);
        return this;
    }

    @Override
    public void process() {
        SNumbers result = this.process(this.getInputScalar(INPUT_JSON_PALETTE).getValue(), this.getInputScalar(INPUT_JSON_NAMED_INDEXES, true).getValue());
        this.getNumbers(OUTPUT_PALETTE).exchange(result);
    }

    public SNumbers process(String jsonPaletteString, String jsonIndexNamesString) {
        Objects.requireNonNull(jsonPaletteString, "Null jsonPaletteString");
        JsonObject jsonPalette = Jsons.toJson(jsonPaletteString.trim());
        JsonObject jsonIndexNames = Jsons.toJson(jsonIndexNamesString, true);
        int tableLength = JsonToIndexValueTable.findTableLength(jsonPalette, jsonIndexNames, this.indexingBase, INPUT_JSON_NAMED_INDEXES, true);
        double[] resultTable = new double[this.numberOfChannels * tableLength];
        double[] filler = new double[this.numberOfChannels];
        this.fillColor(filler, 0, ChannelOperation.decodeRGBA(this.defaultColor));
        int disp = 0;
        while (disp < resultTable.length) {
            for (int j = 0; j < this.numberOfChannels; ++j) {
                resultTable[disp++] = filler[j];
            }
        }
        block6: for (Map.Entry entry : jsonPalette.entrySet()) {
            int index = JsonToIndexValueTable.toIndex(jsonIndexNames, (String)entry.getKey(), INPUT_JSON_NAMED_INDEXES);
            if (index < this.indexingBase) continue;
            int offset = (index - this.indexingBase) * this.numberOfChannels;
            JsonValue jsonValue = (JsonValue)entry.getValue();
            switch (jsonValue.getValueType()) {
                case NUMBER: {
                    double value = ((JsonNumber)jsonValue).doubleValue();
                    this.fillColor(resultTable, offset, ChannelOperation.decodeRGBAForSingleNumber(value));
                    continue block6;
                }
                case STRING: {
                    String value = ((JsonString)jsonValue).getString();
                    this.fillColor(resultTable, offset, ChannelOperation.decodeRGBA(value));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Palette JSON  must contain double or string values, but for key \"" + (String)entry.getKey() + "\" it contains \"" + String.valueOf(jsonValue) + "\"");
        }
        return SNumbers.ofArray(resultTable, this.numberOfChannels);
    }

    private void fillColor(double[] values, int offset, double[] color) {
        for (int i = 0; i < this.numberOfChannels; ++i) {
            values[offset++] = ChannelOperation.colorChannel(color, i, this.numberOfChannels, this.defaultValueForExtraChannels);
        }
    }
}

