/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class ReplaceNumbersColumns
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_REPLACE_WITH = "replace_with";
    private int indexInBlock = 0;
    private int indexInReplacer = 0;
    private int lengthInBlock = 0;

    public ReplaceNumbersColumns() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addInputNumbers(INPUT_REPLACE_WITH);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getIndexInBlock() {
        return this.indexInBlock;
    }

    public ReplaceNumbersColumns setIndexInBlock(int indexInBlock) {
        this.indexInBlock = ReplaceNumbersColumns.nonNegative(indexInBlock);
        return this;
    }

    public int getIndexInReplacer() {
        return this.indexInReplacer;
    }

    public ReplaceNumbersColumns setIndexInReplacer(int indexInReplacer) {
        this.indexInReplacer = ReplaceNumbersColumns.nonNegative(indexInReplacer);
        return this;
    }

    public int getLengthInBlock() {
        return this.lengthInBlock;
    }

    public ReplaceNumbersColumns setLengthInBlock(int lengthInBlock) {
        this.lengthInBlock = ReplaceNumbersColumns.nonNegative(lengthInBlock);
        return this;
    }

    @Override
    public void process() {
        SNumbers inputPortNumbers = this.getInputNumbers(this.defaultInputPortName(), true);
        SNumbers inputPortNumbersReplacer = this.getInputNumbers(INPUT_REPLACE_WITH);
        int lengthInBlock = this.lengthInBlock == 0 ? inputPortNumbersReplacer.getBlockLength() : this.lengthInBlock;
        ReplaceNumbersColumns.logDebug(() -> "Replacing column" + (lengthInBlock == 1 ? "" : "s") + " (elements #" + this.indexInBlock + (String)(lengthInBlock == 1 ? "" : ".." + (this.indexInBlock + lengthInBlock - 1)) + " in each block) of input number array " + String.valueOf(inputPortNumbers) + " with column" + (lengthInBlock == 1 ? "" : "s") + " (elements #" + this.indexInReplacer + (String)(lengthInBlock == 1 ? "" : ".." + (this.indexInReplacer + lengthInBlock - 1)) + " from each block) of replacer array: " + String.valueOf(inputPortNumbersReplacer));
        this.getNumbers().setTo(inputPortNumbers).replaceColumnRange(this.indexInBlock, inputPortNumbersReplacer, this.indexInReplacer, lengthInBlock);
    }
}

