/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.numbers.io.ReadRawNumbers;
import net.algart.executors.modules.core.numbers.io.WriteRawNumbers;

public final class MultiReadRawNumbers
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_COLUMN_NAMES = "column_names";
    public static final String OUTPUT_COLUMN_INDEXES = "column_indexes";
    private String globPattern = "*.dat";
    private int blockLength = 1;
    private Class<?> elementType = Float.TYPE;
    private WriteRawNumbers.ByteOrder byteOrder = WriteRawNumbers.ByteOrder.BIG_ENDIAN;
    private boolean readMetadataFile = false;

    public MultiReadRawNumbers() {
        this.addFileOperationPorts();
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_COLUMN_NAMES);
        this.addOutputScalar(OUTPUT_COLUMN_INDEXES);
    }

    public static MultiReadRawNumbers getInstance() {
        return new MultiReadRawNumbers();
    }

    @Override
    public MultiReadRawNumbers setFile(String file) {
        super.setFile(file);
        return this;
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public MultiReadRawNumbers setGlobPattern(String globPattern) {
        this.globPattern = MultiReadRawNumbers.nonEmpty(globPattern);
        return this;
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public MultiReadRawNumbers setBlockLength(int blockLength) {
        this.blockLength = MultiReadRawNumbers.positive(blockLength);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public MultiReadRawNumbers setElementType(Class<?> elementType) {
        this.elementType = MultiReadRawNumbers.nonNull(elementType);
        return this;
    }

    public MultiReadRawNumbers setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public WriteRawNumbers.ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public MultiReadRawNumbers setByteOrder(WriteRawNumbers.ByteOrder byteOrder) {
        this.byteOrder = MultiReadRawNumbers.nonNull(byteOrder);
        return this;
    }

    public boolean isReadMetadataFile() {
        return this.readMetadataFile;
    }

    public MultiReadRawNumbers setReadMetadataFile(boolean readMetadataFile) {
        this.readMetadataFile = readMetadataFile;
        return this;
    }

    @Override
    public void process() {
        Path path = this.completeFilePath().toAbsolutePath();
        ReadRawNumbers readRawNumbers = ReadRawNumbers.getInstance();
        readRawNumbers.setBlockLength(this.blockLength).setElementType(this.elementType).setByteOrder(this.byteOrder).setReadMetadataFile(this.readMetadataFile).setFileExistenceRequired(true);
        Accumulator accumulator = new Accumulator(file -> readRawNumbers.setFile((Path)file).readRaw());
        MultiReadRawNumbers.processFiles(path, this.globPattern, accumulator);
        SNumbers result = accumulator.join();
        if (result != null) {
            this.getNumbers().exchange(result);
        }
        this.getScalar(OUTPUT_COLUMN_INDEXES).exchange(readRawNumbers.getScalar(OUTPUT_COLUMN_INDEXES));
        this.getScalar(OUTPUT_COLUMN_NAMES).exchange(readRawNumbers.getScalar(OUTPUT_COLUMN_NAMES));
    }

    static void processFiles(Path path, String globPattern, Accumulator accumulator) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            accumulator.processFile(path);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            ArrayList<Path> files = new ArrayList<Path>();
            PathMatcher matcher = path.getFileSystem().getPathMatcher("glob:" + globPattern);
            try (DirectoryStream<Path> fileStream = Files.newDirectoryStream(path);){
                for (Path f : fileStream) {
                    if (!Files.isDirectory(f, new LinkOption[0]) && (!Files.isRegularFile(f, new LinkOption[0]) || !matcher.matches(f.getFileName()))) continue;
                    files.add(f);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            Collections.sort(files);
            for (Path f : files) {
                if (!Files.isRegularFile(f, new LinkOption[0])) continue;
                accumulator.processFile(f);
            }
            for (Path subfolder : files) {
                if (!Files.isDirectory(subfolder, new LinkOption[0])) continue;
                MultiReadRawNumbers.processFiles(subfolder, globPattern, accumulator);
            }
        }
    }

    static class Accumulator {
        private final Function<Path, SNumbers> readFunction;
        List<SNumbers> numbersList = new ArrayList<SNumbers>();
        private Path firstFile = null;
        private SNumbers firstNumbers = null;
        private long totalLength = 0L;
        private int n = 0;

        Accumulator(Function<Path, SNumbers> readFunction) {
            this.readFunction = Objects.requireNonNull(readFunction);
        }

        void processFile(Path file) {
            SNumbers numbers = this.readFunction.apply(file);
            assert (numbers != null) : "ReadRawNumbers must not return null when fileExistenceRequired=true";
            if (this.firstNumbers == null) {
                this.firstFile = file;
                this.firstNumbers = numbers;
            } else {
                if (this.firstNumbers.getBlockLength() != numbers.getBlockLength()) {
                    throw new IllegalArgumentException("Different block length in the source number arrays: " + numbers.getBlockLength() + " (file " + String.valueOf(file) + ") != " + this.firstNumbers.getBlockLength() + " (file " + String.valueOf(this.firstFile) + ")");
                }
                if (this.firstNumbers.elementType() != numbers.elementType()) {
                    throw new IllegalArgumentException("Different element type in the source number arrays: " + String.valueOf(numbers.elementType()) + " (file " + String.valueOf(file) + ") != " + String.valueOf(this.firstNumbers.elementType()) + " (file " + String.valueOf(this.firstFile) + ")");
                }
            }
            this.totalLength += (long)numbers.getArrayLength();
            if (this.totalLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large summary number of elements in " + this.numbersList.size() + "arrays: >2^31-1");
            }
            this.n += numbers.n();
            this.numbersList.add(numbers);
        }

        SNumbers join() {
            if (this.numbersList.isEmpty()) {
                return null;
            }
            SNumbers result = SNumbers.zeros(this.firstNumbers.elementType(), this.n, this.firstNumbers.getBlockLength());
            int m = this.numbersList.size();
            int disp = 0;
            for (int k = 0; k < m; ++k) {
                SNumbers numbers = this.numbersList.get(k);
                int length = numbers.n();
                result.replaceBlockRange(disp, numbers, 0, length);
                disp += length;
            }
            return result;
        }
    }
}

