/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.io;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.algart.arrays.MutablePArray;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.io.FileOperation;

public final class ReadCSVNumbers
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_HEADERS = "headers";
    public static final String AUTO_ELEMENT_TYPE = "auto";
    private static final Charset[] POSSIBLE_CSV_CHARSETS = new Charset[]{StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.UTF_8};
    private Class<?> elementType = null;
    private int numberOfSkippedInitialLines = 0;

    public ReadCSVNumbers() {
        this.addFileOperationPorts();
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_HEADERS);
    }

    public static ReadCSVNumbers getInstance() {
        return new ReadCSVNumbers();
    }

    public static ReadCSVNumbers getSecureInstance() {
        ReadCSVNumbers result = new ReadCSVNumbers();
        result.setSecure(true);
        return result;
    }

    @Override
    public ReadCSVNumbers setFile(String file) {
        super.setFile(file);
        return this;
    }

    @Override
    public ReadCSVNumbers setFile(Path file) {
        super.setFile(file);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public ReadCSVNumbers setElementType(Class<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    public ReadCSVNumbers setElementType(String elementType) {
        return this.setElementType(AUTO_ELEMENT_TYPE.equals(elementType) ? null : SNumbers.elementType(elementType));
    }

    public int getNumberOfSkippedInitialLines() {
        return this.numberOfSkippedInitialLines;
    }

    public ReadCSVNumbers setNumberOfSkippedInitialLines(int numberOfSkippedInitialLines) {
        this.numberOfSkippedInitialLines = numberOfSkippedInitialLines;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadCSVNumbers.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
        } else {
            SNumbers result = this.readCSV();
            if (result != null) {
                this.getNumbers().setTo(result);
            }
        }
    }

    public SNumbers readCSV() {
        Path csvFile = this.completeFilePath();
        try {
            if (this.skipIfMissingFileOrThrow(csvFile)) {
                return null;
            }
            ReadCSVNumbers.logDebug(() -> "Reading number array from " + String.valueOf(csvFile.toAbsolutePath()));
            ArrayList<String> resultHeaders = new ArrayList<String>();
            SNumbers result = this.readCSV(csvFile, resultHeaders);
            this.getScalar(OUTPUT_HEADERS).setTo(String.join((CharSequence)"\n", resultHeaders));
            return result;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public SNumbers readCSV(Path csvFile) throws IOException {
        return this.readCSV(csvFile, new ArrayList<String>());
    }

    public SNumbers readCSV(Path csvFile, List<String> resultHeaders) throws IOException {
        Objects.requireNonNull(csvFile, "Null file path");
        SNumbers largestResult = null;
        ArrayList<String> largestHeaders = null;
        Exception exception = null;
        for (Charset POSSIBLE_CSV_CHARSET : POSSIBLE_CSV_CHARSETS) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile.toFile()), POSSIBLE_CSV_CHARSET));){
                SNumbers numbers;
                AtomicBoolean goodHeader;
                ArrayList<String> headers;
                block15: {
                    headers = new ArrayList<String>();
                    goodHeader = new AtomicBoolean();
                    numbers = this.readCSV(reader, headers, goodHeader);
                    if (!goodHeader.get()) break block15;
                    resultHeaders.clear();
                    resultHeaders.addAll(headers);
                    SNumbers sNumbers = numbers;
                    return sNumbers;
                }
                try {
                    if (largestResult != null && numbers.getArrayLength() <= largestResult.getArrayLength()) continue;
                    largestResult = numbers;
                    largestHeaders = new ArrayList<String>(headers);
                }
                catch (IOException | NumberFormatException e) {
                    if (goodHeader.get()) {
                        throw e;
                    }
                    exception = e;
                }
            }
        }
        if (exception == null) {
            assert (largestResult != null && largestHeaders != null);
            resultHeaders.clear();
            resultHeaders.addAll(largestHeaders);
            return largestResult;
        }
        if (largestResult != null && largestResult.getArrayLength() > 0) {
            resultHeaders.clear();
            resultHeaders.addAll(largestHeaders);
            return largestResult;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (RuntimeException)exception;
    }

    public SNumbers readCSV(BufferedReader reader) throws IOException, NumberFormatException {
        return this.readCSV(reader, null, new AtomicBoolean());
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return super.visibleResultsInformation().addPorts(this.getOutputPort(OUTPUT_HEADERS));
    }

    private SNumbers readCSV(BufferedReader reader, List<String> resultHeaders, AtomicBoolean goodHeader) throws IOException, NumberFormatException {
        Objects.requireNonNull(reader, "Null reader argument");
        ReadCSVNumbers.skipBOM(reader);
        goodHeader.set(false);
        for (int k = 0; k < this.numberOfSkippedInitialLines; ++k) {
            String skipped = reader.readLine();
            if (skipped != null) continue;
            throw new IOException("Empty CSV file");
        }
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Empty CSV file");
        }
        String[] headers = line.trim().split("([,;\\s]\\s*)");
        int blockLength = headers.length;
        Class<?> autoDetectedElementType = ReadCSVNumbers.parseSNumbersHeader(headers);
        if (autoDetectedElementType != null) {
            goodHeader.set(true);
        }
        Class<Object> elementType = this.elementType != null ? this.elementType : (autoDetectedElementType != null ? autoDetectedElementType : Float.TYPE);
        double[] singleBlock = new double[blockLength];
        MutablePArray array = MutablePArray.newArray(elementType);
        long count = 0L;
        while (true) {
            block11: {
                boolean firstLineWithUnknownHeader;
                boolean bl = firstLineWithUnknownHeader = count == 0L && !goodHeader.get();
                if (!firstLineWithUnknownHeader) {
                    line = reader.readLine();
                }
                if (line == null) break;
                String[] items = line.trim().split("([,;\\s]\\s*)");
                try {
                    for (int k = 0; k < singleBlock.length; ++k) {
                        singleBlock[k] = k < items.length ? Double.parseDouble(items[k].trim()) : 0.0;
                    }
                }
                catch (NumberFormatException e) {
                    if (!firstLineWithUnknownHeader) {
                        throw e;
                    }
                    break block11;
                }
                if (firstLineWithUnknownHeader) {
                    headers = new String[]{};
                }
                long currentLength = array.length();
                array.length(currentLength + (long)singleBlock.length);
                array.setData(currentLength, SNumbers.ofArray(singleBlock).toPrecision(elementType).getArray());
            }
            ++count;
        }
        if (resultHeaders != null) {
            resultHeaders.clear();
            resultHeaders.addAll(Arrays.asList(headers));
        }
        return SNumbers.ofArray(array.ja(), blockLength);
    }

    private static void skipBOM(Reader reader) throws IOException {
        reader.mark(1);
        char[] possibleBOM = new char[1];
        reader.read(possibleBOM);
        if (possibleBOM[0] != '\ufeff') {
            reader.reset();
        }
    }

    private static Class<?> parseSNumbersHeader(String[] headers) throws IOException {
        if (headers.length == 0) {
            throw new IOException("Invalid CSV header: zero number of columns");
        }
        Class<?> result = null;
        for (Class<?> elementType : SNumbers.SUPPORTED_ELEMENT_TYPES) {
            if (!headers[0].startsWith(elementType.getSimpleName())) continue;
            result = elementType;
            break;
        }
        return result;
    }
}

