/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.numbers.NumberArrayFilter;
import net.algart.executors.modules.core.matrices.misc.LimitInterpretation;
import net.algart.math.Range;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.RectangularFunc;

public final class ContrastAndClassifyNumbers
extends NumberArrayFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_SELECTOR = "selector";
    public static final String OUTPUT_LOW_LIMIT_VALUE = "low_limit_value";
    public static final String OUTPUT_HIGH_LIMIT_VALUE = "high_limit_value";
    private double lowLimit = 0.0;
    private double highLimit = 1.0;
    private LimitInterpretation lowLimitInterpretation = LimitInterpretation.PERCENTILE_BETWEEN_MIN_AND_MAX;
    private LimitInterpretation highLimitInterpretation = LimitInterpretation.PERCENTILE_BETWEEN_MIN_AND_MAX;
    private double resultMin = 0.0;
    private double resultMax = 1.0;
    private boolean truncateOverflow = true;
    private boolean invertSelector = false;

    public ContrastAndClassifyNumbers() {
        this.addOutputNumbers(OUTPUT_SELECTOR);
        this.addOutputScalar(OUTPUT_LOW_LIMIT_VALUE);
        this.addOutputScalar(OUTPUT_HIGH_LIMIT_VALUE);
    }

    public double getLowLimit() {
        return this.lowLimit;
    }

    public ContrastAndClassifyNumbers setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
        return this;
    }

    public double getHighLimit() {
        return this.highLimit;
    }

    public ContrastAndClassifyNumbers setHighLimit(double highLimit) {
        this.highLimit = highLimit;
        return this;
    }

    public LimitInterpretation getLowLimitInterpretation() {
        return this.lowLimitInterpretation;
    }

    public ContrastAndClassifyNumbers setLowLimitInterpretation(LimitInterpretation lowLimitInterpretation) {
        this.lowLimitInterpretation = ContrastAndClassifyNumbers.nonNull(lowLimitInterpretation);
        return this;
    }

    public LimitInterpretation getHighLimitInterpretation() {
        return this.highLimitInterpretation;
    }

    public ContrastAndClassifyNumbers setHighLimitInterpretation(LimitInterpretation highLimitInterpretation) {
        this.highLimitInterpretation = highLimitInterpretation;
        return this;
    }

    public double getResultMin() {
        return this.resultMin;
    }

    public ContrastAndClassifyNumbers setResultMin(double resultMin) {
        this.resultMin = resultMin;
        return this;
    }

    public double getResultMax() {
        return this.resultMax;
    }

    public ContrastAndClassifyNumbers setResultMax(double resultMax) {
        this.resultMax = resultMax;
        return this;
    }

    public boolean isTruncateOverflow() {
        return this.truncateOverflow;
    }

    public ContrastAndClassifyNumbers setTruncateOverflow(boolean truncateOverflow) {
        this.truncateOverflow = truncateOverflow;
        return this;
    }

    public boolean isInvertSelector() {
        return this.invertSelector;
    }

    public ContrastAndClassifyNumbers setInvertSelector(boolean invertSelector) {
        this.invertSelector = invertSelector;
        return this;
    }

    @Override
    public PArray process(UpdatablePNumberArray array, int blockLength, int numberOfBlocks) {
        ByteArray selector;
        UpdatablePNumberArray result;
        if (this.lowLimit > this.highLimit) {
            throw new IllegalArgumentException("Illegal low (" + this.lowLimit + ") or high (" + this.highLimit + ") limits: must be low <= high");
        }
        if (this.resultMin > this.resultMax) {
            throw new IllegalArgumentException("Illegal result minimum (" + this.resultMin + ") or maximum (" + this.resultMax + "): must be result min <= max");
        }
        final Range rangeToContrast = this.rangeForContrasting((PArray)array);
        ContrastAndClassifyNumbers.logDebug(() -> "Contrast of " + (this.lowLimitInterpretation == LimitInterpretation.PERCENTILE_BETWEEN_MIN_AND_MAX ? "percentile" : "value") + " " + this.lowLimit + ".." + this.highLimit + " for " + String.valueOf(array) + " (range to contrast " + String.valueOf(rangeToContrast) + ")");
        this.getScalar(OUTPUT_LOW_LIMIT_VALUE).setTo(rangeToContrast.min());
        this.getScalar(OUTPUT_HIGH_LIMIT_VALUE).setTo(rangeToContrast.max());
        if (rangeToContrast.size() == 0.0) {
            result = array;
            selector = Arrays.nByteCopies((long)array.length(), (byte)((byte)(this.invertSelector ? 1 : 0)));
        } else {
            final Range destRange = Range.of((double)this.resultMin, (double)this.resultMax);
            result = (PNumberArray)Arrays.asFuncArray((Func)(this.truncateOverflow ? new AbstractFunc(this){
                final double mult;
                final double b;
                {
                    this.mult = destRange.size() / rangeToContrast.size();
                    this.b = destRange.min() - rangeToContrast.min() * this.mult;
                }

                public double get(double ... x) {
                    return this.get(x[0]);
                }

                public double get(double x0) {
                    return destRange.cut(this.b + this.mult * x0);
                }
            } : LinearFunc.getInstance((Range)destRange, (Range)rangeToContrast)), (Class)array.type(), (PArray[])new PArray[]{array});
            double inValue = this.invertSelector ? 0.0 : 1.0;
            double outValue = this.invertSelector ? 1.0 : 0.0;
            selector = (PNumberArray)Arrays.asFuncArray((Func)RectangularFunc.getInstance((Range)rangeToContrast, (double)inValue, (double)outValue), ByteArray.class, (PArray[])new PArray[]{array});
        }
        if (this.isOutputNecessary(OUTPUT_SELECTOR)) {
            this.getNumbers(OUTPUT_SELECTOR).setTo((PNumberArray)selector, blockLength);
        }
        return result;
    }

    public Range rangeForContrasting(PArray values) {
        Range range = this.lowLimitInterpretation.isUseRange() || this.highLimitInterpretation.isUseRange() ? Arrays.rangeOf((PArray)values) : null;
        long[] histogram = null;
        if (this.lowLimitInterpretation.isUseHistogram() || this.highLimitInterpretation.isUseHistogram()) {
            assert (range != null);
            histogram = new long[65536];
            double increasedSize = range.size() * ((double)histogram.length / ((double)histogram.length - 1.0));
            double increasedMax = range.min() + increasedSize;
            Arrays.histogramOf((PArray)values, (long[])histogram, (double)range.min(), (double)increasedMax);
        }
        return Range.of((double)this.lowLimitInterpretation.translateLimit(this.lowLimit, range, 1.0, histogram), (double)this.highLimitInterpretation.translateLimit(this.highLimit, range, 1.0, histogram));
    }
}

