/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import java.util.List;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.SeveralScalarsOperation;

public final class ProductOfTwoPowers
extends SeveralScalarsOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private double a = 1.0;
    private double b = 1.0;
    private double m = 1.0;

    public ProductOfTwoPowers() {
        super(INPUT_X, INPUT_Y);
    }

    public double getA() {
        return this.a;
    }

    public ProductOfTwoPowers setA(double a) {
        this.a = a;
        return this;
    }

    public ProductOfTwoPowers setA(String a) {
        return this.setA(ProductOfTwoPowers.smartParseDouble(a));
    }

    public double getB() {
        return this.b;
    }

    public ProductOfTwoPowers setB(double b) {
        this.b = b;
        return this;
    }

    public ProductOfTwoPowers setB(String b) {
        return this.setB(ProductOfTwoPowers.smartParseDouble(b));
    }

    public double getM() {
        return this.m;
    }

    public ProductOfTwoPowers setM(double m) {
        this.m = m;
        return this;
    }

    @Override
    public SScalar process(List<SScalar> sources) {
        double x = sources.get(0).toDouble();
        Double y = sources.get(1).toDoubleOrNull();
        double r = y == null ? StrictMath.pow(x, this.a) * this.m : StrictMath.pow(x, this.a) * StrictMath.pow(y, this.b) * this.m;
        return SScalar.of(r);
    }

    public static double smartParseDouble(String s) {
        int p = (s = s.trim()).indexOf("/");
        if (p == -1) {
            return Double.parseDouble(s);
        }
        String left = s.substring(0, p).trim();
        String right = s.substring(p + 1).trim();
        return Double.parseDouble(left) / Double.parseDouble(right);
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex > 0;
    }
}

