/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;

public final class RoundScalar
extends ScalarFilter {
    private RoundingMode roundingMode;

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public RoundScalar setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = RoundScalar.nonNull(roundingMode);
        return this;
    }

    @Override
    public SScalar process(SScalar source) {
        if (this.roundingMode.rounder == null) {
            return source;
        }
        Number result = this.roundingMode.round(source.toDouble());
        return SScalar.of(result);
    }

    public static enum RoundingMode {
        SKIP_OPERATION(null),
        NONE(Double::valueOf),
        FLOOR_TO_DOUBLE(StrictMath::floor),
        CEIL_TO_DOUBLE(StrictMath::ceil),
        EVEN_ROUND_TO_DOUBLE(StrictMath::rint),
        CAST_TO_LONG(value -> (long)value),
        CAST_TO_INT(value -> (int)value),
        ROUND_TO_LONG(StrictMath::round),
        ROUND_TO_INT(value -> {
            long i = StrictMath.round(value);
            return i < Integer.MIN_VALUE ? Integer.MIN_VALUE : (i > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)i);
        }),
        EVEN_ROUND_TO_LONG(value -> (long)StrictMath.rint(value)),
        EVEN_ROUND_TO_INT(value -> (int)StrictMath.rint(value));

        private final DoubleToNumber rounder;

        private RoundingMode(DoubleToNumber rounder) {
            this.rounder = rounder;
        }

        public Number round(double value) {
            return this.rounder.apply(value);
        }
    }

    @FunctionalInterface
    private static interface DoubleToNumber {
        public Number apply(double var1);
    }
}

