/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import jakarta.json.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;
import net.algart.json.Jsons;

public class GetExecutorSpecification
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_EXECUTOR_ID = "executor_id";
    public static final String OUTPUT_SETTINGS_SPECIFICATION = "settings_specification";
    public static final String OUTPUT_AUTOGENERATED_SETTINGS_SPECIFICATION = "autogenerated_settings_specification";
    public static final String OUTPUT_PLATFORM_ID = "platform_id";
    public static final String OUTPUT_CATEGORY = "category";
    public static final String OUTPUT_NAME = "name";
    public static final String OUTPUT_DESCRIPTION = "description";
    public static final String OUTPUT_ID = "id";
    public static final String OUTPUT_LANGUAGE = "language";
    public static final String OUTPUT_BUILT_IN = "built_in";
    private static final List<String> ALL_OUTPUT_PORTS = List.of(DEFAULT_OUTPUT_PORT, "settings_specification", "autogenerated_settings_specification", "platform_id", "category", "name", "description", "id", "language", "built_in");
    private String id = "n/a";
    private boolean specialSearchInBuiltIn = true;

    public GetExecutorSpecification() {
        this.addInputScalar(INPUT_EXECUTOR_ID);
        ALL_OUTPUT_PORTS.forEach(this::addOutputScalar);
    }

    public String getId() {
        return this.id;
    }

    public GetExecutorSpecification setId(String id) {
        this.id = GetExecutorSpecification.nonNull(id);
        return this;
    }

    public boolean isSpecialSearchInBuiltIn() {
        return this.specialSearchInBuiltIn;
    }

    public GetExecutorSpecification setSpecialSearchInBuiltIn(boolean specialSearchInBuiltIn) {
        this.specialSearchInBuiltIn = specialSearchInBuiltIn;
        return this;
    }

    @Override
    public void process() {
        ExecutorSpecification specification;
        ALL_OUTPUT_PORTS.forEach(s -> this.getScalar((String)s).remove());
        this.getScalar(OUTPUT_BUILT_IN).setTo(false);
        String id = this.getInputScalar(INPUT_EXECUTOR_ID, true).getValue();
        if (id == null) {
            id = this.id;
        }
        if ((specification = this.findSpecification(id)) == null) {
            this.getScalar().remove();
            return;
        }
        this.setOutputScalarIfNecessary(OUTPUT_SETTINGS_SPECIFICATION, () -> specification.hasSettings() ? specification.getSettings().jsonString() : null);
        this.setOutputScalarIfNecessary(OUTPUT_AUTOGENERATED_SETTINGS_SPECIFICATION, () -> specification.toSettingsSpecification().jsonString());
        this.getScalar(OUTPUT_PLATFORM_ID).setTo(specification.getPlatformId());
        this.getScalar(OUTPUT_CATEGORY).setTo(specification.getCategory());
        this.getScalar(OUTPUT_NAME).setTo(specification.getName());
        this.getScalar(OUTPUT_DESCRIPTION).setTo(specification.getDescription());
        this.getScalar(OUTPUT_ID).setTo(specification.getId());
        this.getScalar(OUTPUT_LANGUAGE).setTo(specification.getLanguage());
    }

    public ExecutorSpecification findSpecification(String executorId) {
        Objects.requireNonNull(executorId, "Null executorId");
        long t1 = GetExecutorSpecification.debugTime();
        ExecutorSpecification builtIn = ExecutorSpecificationSet.allBuiltIn().get(executorId);
        this.getScalar(OUTPUT_BUILT_IN).setTo(builtIn != null);
        long t2 = GetExecutorSpecification.debugTime();
        if (builtIn != null && this.specialSearchInBuiltIn) {
            JsonObject json = builtIn.toJson();
            long t3 = GetExecutorSpecification.debugTime();
            this.getScalar().setTo(Jsons.toPrettyString(json));
            long t4 = GetExecutorSpecification.debugTime();
            GetExecutorSpecification.logDebug(() -> String.format(Locale.US, "Executor \"%s\" is a built-in executor \"%s\": %.5f ms = %.3f mcs quick check + %.3f mcs making JSON + %.3f mcs returning", executorId, builtIn.getName(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001));
            return builtIn;
        }
        ExecutorSpecification extended = GetExecutorSpecification.globalLoaders().getSpecification(this.getSessionId(), executorId, true);
        if (extended == null) {
            return null;
        }
        long t3 = GetExecutorSpecification.debugTime();
        this.getScalar().setTo(extended.jsonString());
        long t4 = GetExecutorSpecification.debugTime();
        GetExecutorSpecification.logDebug(() -> String.format(Locale.US, "Executor \"%s\" is an extended executor \"%s\": %.5f ms = %.3f mcs quick check + %.3f mcs requesting description + %.3f mcs returning", executorId, extended.getName(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001));
        return extended;
    }
}

