/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.function.Consumer;
import jep.MainInterpreter;
import jep.PyConfig;

public class GlobalPythonConfiguration
extends PyConfig {
    public static final String JEP_CONFIG_PROPERTY_PREFIX = "jep.config.";
    public static final GlobalPythonConfiguration INSTANCE = new GlobalPythonConfiguration(false);
    private boolean used = false;
    private final Object lock = new Object();

    public GlobalPythonConfiguration(boolean isolated) {
        super(isolated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHome() {
        Object object = this.lock;
        synchronized (object) {
            return this.home;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setHome(String home) {
        Object object = this.lock;
        synchronized (object) {
            super.setHome(home);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOptimizationLevel() {
        Object object = this.lock;
        synchronized (object) {
            return this.optimizationLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setOptimizationLevel(int optimizationLevel) {
        Object object = this.lock;
        synchronized (object) {
            super.setOptimizationLevel(optimizationLevel);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getSiteImport() {
        Object object = this.lock;
        synchronized (object) {
            return this.siteImport < 0 ? null : Boolean.valueOf(this.siteImport > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setSiteImport(boolean siteImport) {
        Object object = this.lock;
        synchronized (object) {
            super.setSiteImport(siteImport);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoreEnvironment() {
        Object object = this.lock;
        synchronized (object) {
            return this.useEnvironment == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getUseEnvironment() {
        Object object = this.lock;
        synchronized (object) {
            return this.useEnvironment < 0 ? null : Boolean.valueOf(this.useEnvironment > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setUseEnvironment(boolean useEnvironment) {
        Object object = this.lock;
        synchronized (object) {
            super.setUseEnvironment(useEnvironment);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getUserSiteDirectory() {
        Object object = this.lock;
        synchronized (object) {
            return this.userSiteDirectory < 0 ? null : Boolean.valueOf(this.userSiteDirectory > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setUserSiteDirectory(boolean userSiteDirectory) {
        Object object = this.lock;
        synchronized (object) {
            super.setUserSiteDirectory(userSiteDirectory);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVerbose() {
        Object object = this.lock;
        synchronized (object) {
            return this.verbose;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setVerbose(int verbose) {
        Object object = this.lock;
        synchronized (object) {
            super.setVerbose(verbose);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getWriteBytecode() {
        Object object = this.lock;
        synchronized (object) {
            return this.writeBytecode < 0 ? null : Boolean.valueOf(this.writeBytecode > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setWriteBytecode(boolean writeBytecode) {
        Object object = this.lock;
        synchronized (object) {
            super.setWriteBytecode(writeBytecode);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonHome pythonHome() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isUsed()) {
                String pythonHome = this.getHome();
                boolean ignoreEnvironment = this.isIgnoreEnvironment();
                if (pythonHome != null || ignoreEnvironment) {
                    return new PythonHome(pythonHome, true, ignoreEnvironment);
                }
            }
            return new PythonHome(GlobalPythonConfiguration.getEnv("PYTHONHOME"), false, false);
        }
    }

    public String pythonHomeDirectory() {
        return this.pythonHome().home();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration loadFromSystemProperties() {
        Object object = this.lock;
        synchronized (object) {
            this.setPrefixedInt("optimizationLevel", this::setOptimizationLevel);
            this.setPrefixedBoolean("siteImport", this::setSiteImport);
            this.setPrefixedBoolean("useEnvironment", this::setUseEnvironment);
            this.setPrefixedBoolean("userSiteDirectory", this::setUserSiteDirectory);
            this.setPrefixedInt("verbose", this::setVerbose);
            this.setPrefixedBoolean("writeBytecode", this::setWriteBytecode);
            this.setHome(GlobalPythonConfiguration.getNonEmptyString("python.home", this.home));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration useForJep() {
        Object object = this.lock;
        synchronized (object) {
            MainInterpreter.setInitParams((PyConfig)this);
            this.used = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed() {
        Object object = this.lock;
        synchronized (object) {
            return this.used;
        }
    }

    private void setPrefixedInt(String propertyName, Consumer<Integer> setter) {
        Integer value = GlobalPythonConfiguration.getPrefixedInt(propertyName);
        if (value != null) {
            setter.accept(value);
        }
    }

    private static Integer getPrefixedInt(String propertyName) {
        try {
            String property = System.getProperty(JEP_CONFIG_PROPERTY_PREFIX + propertyName);
            return property == null ? null : Integer.valueOf(Integer.parseInt(property));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setPrefixedBoolean(String propertyName, Consumer<Boolean> setter) {
        Boolean value = GlobalPythonConfiguration.getPrefixedBoolean(propertyName);
        if (value != null) {
            setter.accept(value);
        }
    }

    private static Boolean getPrefixedBoolean(String propertyName) {
        try {
            String property = System.getProperty(JEP_CONFIG_PROPERTY_PREFIX + propertyName);
            return property == null ? null : Boolean.valueOf("true".equalsIgnoreCase(property));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String getNonEmptyString(String propertyName, String defaultValue) {
        try {
            String property = System.getProperty(propertyName);
            return property == null || property.isEmpty() ? defaultValue : property;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static String getEnv(String envName) {
        try {
            return System.getenv(envName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public record PythonHome(String home, boolean used, boolean systemEnvironmentDisabled) {
        public boolean unknown() {
            return this.home == null;
        }

        public boolean exists() {
            if (this.home == null) {
                return false;
            }
            try {
                return Files.exists(Paths.get(this.home, new String[0]), new LinkOption[0]);
            }
            catch (Exception ignoredExceptionWhileParsingPath) {
                return false;
            }
        }

        public boolean systemEnvironmentUsed() {
            if (!this.used) {
                return true;
            }
            if (this.home == null) {
                assert (this.systemEnvironmentDisabled);
                return true;
            }
            return false;
        }
    }
}

