/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.multimatrix.MultiMatrix;

class SimpleMultiMatrix
implements MultiMatrix {
    final List<Matrix<? extends PArray>> channels;
    private final PArray[] channelArrays;
    private final Class<?> elementType;

    SimpleMultiMatrix(List<? extends Matrix<? extends PArray>> channels) {
        Objects.requireNonNull(channels, "Null channels");
        this.channels = new ArrayList<Matrix<? extends PArray>>(channels);
        SimpleMultiMatrix.checkNumberOfChannels(channels, false);
        Matrices.checkDimensionEquality(this.channels, (boolean)true);
        this.elementType = channels.get(0).elementType();
        this.channelArrays = new PArray[channels.size()];
        for (int k = 0; k < this.channelArrays.length; ++k) {
            this.channelArrays[k] = (PArray)channels.get(k).array();
        }
    }

    @Override
    public Class<?> elementType() {
        return this.elementType;
    }

    @Override
    public int numberOfChannels() {
        return this.channelArrays.length;
    }

    @Override
    public List<Matrix<? extends PArray>> allChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    @Override
    public Matrix<? extends PArray> channel(int channelIndex) {
        return this.channels.get(channelIndex);
    }

    @Override
    public PArray channelArray(int channelIndex) {
        return this.channelArrays[channelIndex];
    }

    @Override
    public long indexInArray(long ... coordinates) {
        return this.channels.get(0).index(coordinates);
    }

    @Override
    public MultiMatrix asPrecision(Class<?> newElementType) {
        if (newElementType == this.elementType()) {
            return this;
        }
        return new SimpleMultiMatrix(SimpleMultiMatrix.asPrecision(this.channels, newElementType));
    }

    @Override
    public MultiMatrix toPrecisionIfNot(Class<?> newElementType) {
        Objects.requireNonNull(newElementType, "Null newElementType");
        if (newElementType == this.elementType()) {
            return this;
        }
        return new SimpleMultiMatrix(SimpleMultiMatrix.toPrecision(this.channels, newElementType));
    }

    @Override
    public MultiMatrix asMono() {
        return this.numberOfChannels() == 1 ? this : new SimpleMultiMatrix(Collections.singletonList(this.intensityChannel()));
    }

    @Override
    public MultiMatrix asOtherNumberOfChannels(int newNumberOfChannels, boolean fillAlphaWithMaxValue) {
        return newNumberOfChannels == this.numberOfChannels() ? this : new SimpleMultiMatrix(this.otherNumberOfChannels(newNumberOfChannels, fillAlphaWithMaxValue));
    }

    @Override
    public MultiMatrix clone() {
        return new SimpleMultiMatrix(MultiMatrix.cloneMatrices(this.channels));
    }

    @Override
    public MultiMatrix actualizeLazy() {
        return new SimpleMultiMatrix(MultiMatrix.actualizeLazyMatrices(this.channels));
    }

    public String toString() {
        long[] dimensions = this.dimensions();
        return "multi-matrix " + String.valueOf(this.elementType()) + " (" + this.numberOfChannels() + " channels, " + (String)(dimensions.length == 1 ? dimensions[0] + "(x1)" : JArrays.toString((long[])dimensions, (String)"x", (int)1000)) + ")";
    }

    List<Matrix<? extends PArray>> otherNumberOfChannels(int newNumberOfChannels, boolean fillAlphaWithMaxValue) {
        return this.otherNumberOfChannels(newNumberOfChannels, fillAlphaWithMaxValue ? 3 : Integer.MAX_VALUE);
    }

    List<Matrix<? extends PArray>> otherNumberOfChannels(int newNumberOfChannels, int firstChannelIndexToFillWithMaxValue) {
        int i;
        if (firstChannelIndexToFillWithMaxValue < 0) {
            throw new IllegalArgumentException("Negative firstChannelIndexToFillWithMaxValue");
        }
        if (newNumberOfChannels == 1 && this.isColor()) {
            return Collections.singletonList(this.intensityChannel());
        }
        if (newNumberOfChannels < this.numberOfChannels()) {
            return this.allChannels().subList(0, newNumberOfChannels);
        }
        assert (newNumberOfChannels > this.numberOfChannels());
        ArrayList<Matrix<? extends PArray>> newChannels = new ArrayList<Matrix<? extends PArray>>(this.channels);
        int n = Math.min(firstChannelIndexToFillWithMaxValue, newNumberOfChannels);
        for (i = newChannels.size(); i < n; ++i) {
            newChannels.add(this.channels.getFirst());
        }
        for (i = newChannels.size(); i < newNumberOfChannels; ++i) {
            newChannels.add(this.constantMatrix(this.maxPossibleValue()));
        }
        return newChannels;
    }

    static void checkNumberOfChannels(List<? extends Matrix<? extends PArray>> channels, boolean illegalState) {
        Objects.requireNonNull(channels, "Null channels");
        int n = channels.size();
        SimpleMultiMatrix.checkNumberOfChannels(n, illegalState);
    }

    static void checkNumberOfChannels(long n, boolean illegalState) {
        if (n <= 0L || n > 512L) {
            String message = "Number of channels must be in range 1..512 (for example, 1 for monochrome, 3 for RGB, 4 for RGB+alpha), but " + n + " channels specified";
            throw illegalState ? new IllegalStateException(message) : new IllegalArgumentException(message);
        }
    }

    static List<Matrix<? extends PArray>> flipRB(List<? extends Matrix<? extends PArray>> channels) {
        ArrayList<? extends Matrix<? extends PArray>> newChannels = new ArrayList<Matrix<? extends PArray>>(channels);
        int n = newChannels.size();
        if (n == 3 || n == 4) {
            Matrix temp = (Matrix)newChannels.get(0);
            newChannels.set(0, (Matrix<? extends PArray>)((Matrix)newChannels.get(2)));
            newChannels.set(2, (Matrix<? extends PArray>)temp);
        }
        return newChannels;
    }

    static List<Matrix<? extends PArray>> asPrecision(List<Matrix<? extends PArray>> channels, Class<?> newElementType) {
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        for (Matrix<? extends PArray> c : channels) {
            result.add((Matrix<? extends PArray>)Matrices.asPrecision(c, newElementType));
        }
        return result;
    }

    static List<Matrix<? extends PArray>> toPrecision(List<Matrix<? extends PArray>> channels, Class<?> newElementType) {
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        for (Matrix<? extends PArray> c : channels) {
            Matrix m = Arrays.SMM.newMatrix(UpdatablePArray.class, newElementType, c.dimensions());
            Matrices.applyPrecision(null, (Matrix)m, c);
            result.add((Matrix<? extends PArray>)m);
        }
        return result;
    }
}

