/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.components.jsoneditor;

import com.siams.javafx.utils.FxPlatform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;
import org.apache.log4j.Logger;

public class JsonEditor {
    private static Logger logger = Logger.getLogger(JsonEditor.class);
    private final JsonEditorEventHandler jsonEditorEventHandler = new JsonEditorEventHandler();
    private final DebugConsole debugConsole = new DebugConsole(this);
    private WebView webView;
    private String initialJson;
    private Consumer<String> onTextChanged = null;

    public JsonEditor(WebView webView) throws IOException, URISyntaxException {
        this.initialize("{}", webView, null);
    }

    public JsonEditor(String json, WebView webView) throws IOException, URISyntaxException {
        this.initialize(json, webView, null);
    }

    public JsonEditor(String json, WebView webView, Consumer<String> onTextChanged) throws IOException, URISyntaxException {
        this.initialize(json, webView, onTextChanged);
    }

    private void initialize(String json, WebView webView, Consumer<String> onTextChanged) throws URISyntaxException, IOException {
        Objects.requireNonNull(webView);
        this.initialJson = json;
        this.webView = webView;
        this.onTextChanged = onTextChanged;
        WebEngine engine = webView.getEngine();
        engine.setJavaScriptEnabled(true);
        engine.setOnAlert(event -> System.out.println((String)event.getData()));
        engine.setOnError(event -> System.out.println(event.getMessage()));
        engine.getLoadWorker().stateProperty().addListener((ob, o, n) -> {
            if (n == Worker.State.SUCCEEDED) {
                JSObject window = (JSObject)engine.executeScript("window");
                window.setMember("jsonEditorEventHandler", this.jsonEditorEventHandler);
                if (json != null && !json.isEmpty()) {
                    JSObject editor = (JSObject)window.getMember("EDITOR");
                    editor.call("setText", json);
                }
            }
        });
        String html = JsonEditor.prepareResources();
        engine.loadContent(html);
    }

    public void setText(String text) {
        FxPlatform.RunFxThread(() -> {
            WebEngine engine = this.webView.getEngine();
            JSObject window = (JSObject)engine.executeScript("window");
            JSObject jsEditor = (JSObject)window.getMember("EDITOR");
            jsEditor.call("setText", text);
        });
    }

    private String getText() {
        WebEngine engine = this.webView.getEngine();
        JSObject window = (JSObject)engine.executeScript("window");
        JSObject jsEditor = (JSObject)window.getMember("EDITOR");
        return (String)jsEditor.call("getText", new Object[0]);
    }

    private static String prepareResources() throws IOException, URISyntaxException {
        try {
            Path tmpdir = new File(System.getProperty("java.io.tmpdir")).toPath().resolve("jsoneditor");
            Path jsonEditorCssPath = tmpdir.resolve("jsoneditor.css");
            Path jsonEditorJsPath = tmpdir.resolve("jsoneditor.js");
            Path resizeObserverJsPath = tmpdir.resolve("resize-observer.js");
            Path jsonEditorHtmlPath = tmpdir.resolve("jsoneditor.html");
            tmpdir.toFile().mkdirs();
            JsonEditor.copyResource("jsoneditor.css", jsonEditorCssPath);
            JsonEditor.copyResource("jsoneditor.js", jsonEditorJsPath);
            JsonEditor.copyResource("resize-observer.js", resizeObserverJsPath);
            JsonEditor.copyResource("img/jsoneditor-icons.svg", tmpdir.resolve("img/jsoneditor-icons.svg"));
            String html = JsonEditor.readResource("jsoneditor.vm");
            String jsonEditorCssContent = new String(Files.readAllBytes(jsonEditorCssPath));
            html = html.replaceAll("\\$\\{jsonEditorCssContent}", jsonEditorCssContent);
            html = html.replaceAll("\\$\\{jsonEditorJsPath}", String.format("file://%s", jsonEditorJsPath.toString().replaceAll("\\\\", "/")));
            html = html.replaceAll("\\$\\{resizeObserverJsPath}", String.format("file://%s", resizeObserverJsPath.toString().replaceAll("\\\\", "/")));
            try (FileWriter writer = new FileWriter(jsonEditorHtmlPath.toFile(), StandardCharsets.UTF_8);){
                writer.write(html);
            }
            return html;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed prepare resources", t);
            throw t;
        }
    }

    private static String readResource(String name) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[1024];
        try (InputStream in = JsonEditor.class.getResourceAsStream(name);){
            int rd = 0;
            while ((rd = in.read(buffer, 0, buffer.length)) != -1) {
                sb.append(new String(buffer, 0, rd));
            }
        }
        return sb.toString();
    }

    private static void copyResource(String name, Path out) throws IOException {
        out.getParent().toFile().mkdirs();
        try (InputStream in = JsonEditor.class.getResourceAsStream(name);
             FileOutputStream ofs = new FileOutputStream(out.toFile());){
            JsonEditor.copyResource(in, ofs);
        }
    }

    private static void copyResource(InputStream in, OutputStream out) throws IOException {
        int rd;
        int size = 1024;
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((rd = in.read(buffer, offset, size)) != -1) {
            out.write(buffer, 0, rd);
        }
    }

    public static String show(String json, int width, int height, String title) throws IOException, URISyntaxException {
        WebView web = new WebView();
        Stage stage = new Stage();
        stage.setScene(new Scene((Parent)web));
        stage.setWidth((double)width);
        stage.setHeight((double)height);
        stage.setTitle(title);
        JsonEditor editor = new JsonEditor(json, web, null);
        stage.showAndWait();
        return editor.getText();
    }

    public static Optional<String> showAsDialog(String json, int width, int height, String title) throws IOException, URISyntaxException {
        WebView web = new WebView();
        web.addEventFilter(KeyEvent.ANY, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
            }
        });
        JsonEditor editor = new JsonEditor(json, web, null);
        DialogPane pane = new DialogPane();
        pane.setContent((Node)web);
        pane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        pane.setMinSize((double)width, (double)height);
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.setDialogPane(pane);
        dialog.setResultConverter(pressed -> pressed != null && pressed == ButtonType.OK ? editor.getText() : null);
        dialog.resizableProperty().setValue(Boolean.valueOf(true));
        return dialog.showAndWait();
    }

    public void release() {
        this.webView.getEngine().getLoadWorker().cancel();
        this.webView = null;
    }

    public class JsonEditorEventHandler {
        public void onTextChanged(String text) {
            if (JsonEditor.this.onTextChanged != null) {
                JsonEditor.this.onTextChanged.accept(text);
            }
        }
    }

    public class DebugConsole {
        public DebugConsole(JsonEditor this$0) {
        }

        public void println(String text) {
            System.out.println(text);
        }
    }
}

