/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SCFile;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.jsoneditor.JsonEditor;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fx.control.UIValueControlFolder;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxTools;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import org.apache.log4j.Logger;

public class UIValueControlFile
extends AnchorPane
implements UIValueControl,
ChangeListener<String> {
    private static final String EXTERNAL_OPEN_HINT = "Open the file (view or edit) in the system\u2019s default application";
    private static final String SHOW_IN_FOLDER_HINT = "Open the folder containing this file in Explorer";
    private static final Logger LOGGER = Logger.getLogger(UIValueControlFile.class);
    private SControl structureControl;
    private UIControlEventHandler eventHandler;
    private File workingDir = null;
    @FXML
    private Button buttonSelectFile;
    @FXML
    private TextField textFieldValue;
    @FXML
    private Button btnShowInExplorer;
    @FXML
    private Button btnOpen;
    @FXML
    private Button btnAbsolute;

    UIValueControlFile() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.textFieldValue.textProperty().addListener((ChangeListener)this);
            this.btnShowInExplorer.setTooltip((Tooltip)new StareTooltip(SHOW_IN_FOLDER_HINT));
            this.btnOpen.setTooltip((Tooltip)new StareTooltip(EXTERNAL_OPEN_HINT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        this.textFieldValue.textProperty().removeListener((ChangeListener)this);
        this.textFieldValue.setText(property.asString(""));
        this.textFieldValue.textProperty().addListener((ChangeListener)this);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            this.textFieldValue.setTooltip((Tooltip)new StareTooltip(hint));
        }
        this.buttonSelectFile.setOnAction(event -> {
            File file;
            FileChooser chooser = new FileChooser();
            try {
                Preferences preferences = Preferences.userNodeForPackage(UIValueControlFolder.class);
                String folder = preferences.get("file.selector.folder", "");
                if (!folder.isEmpty() && new File(folder).exists()) {
                    chooser.setInitialDirectory(new File(folder));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File file2 = file = this.isSaveDialog() ? chooser.showSaveDialog(null) : chooser.showOpenDialog(null);
            if (file != null) {
                String path = UIValueControl.convertToForwardSlash(file.getAbsolutePath());
                if (this.workingDir != null && Paths.get(path, new String[0]).startsWith(this.workingDir.toPath())) {
                    Path relativize = this.workingDir.toPath().relativize(Paths.get(path, new String[0]));
                    path = UIValueControl.convertToForwardSlash(relativize.toString());
                }
                this.textFieldValue.setText(path);
                try {
                    Preferences preferences = Preferences.userNodeForPackage(UIValueControlFolder.class);
                    preferences.put("file.selector.folder", file.getParentFile().getAbsolutePath());
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        });
        this.btnShowInExplorer.setOnAction(event -> this.resolveAbsolutePath(this.textFieldValue.getText()).ifPresent(file -> FxTools.browseFileDirectory((Path)file.toPath())));
        this.btnOpen.setOnAction(event -> this.resolveAbsolutePath(this.textFieldValue.getText()).ifPresent(file -> {
            boolean runExternalApp = true;
            if (file.getName().endsWith(".json")) {
                try {
                    String text = JsonEditor.show(Files.readString(file.toPath()), 640, 480, structureControl.getName());
                    try (FileWriter writer = new FileWriter((File)file);){
                        writer.write(text);
                    }
                    runExternalApp = false;
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.error((Object)"Failed run JsonEditor", (Throwable)e);
                }
            }
            if (runExternalApp) {
                try {
                    Desktop.getDesktop().open((File)file);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }));
        Tooltip.install((Node)this.btnAbsolute, (Tooltip)new StareTooltip("Switch absolute/relative path"));
        this.btnAbsolute.setOnAction(event -> UIValueControlFile.switchAbsoluteRelativePath(event, this.workingDir, this.textFieldValue));
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    @Override
    public void setWorkingDir(File workDir) {
        this.workingDir = workDir;
    }

    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        String path = UIValueControl.convertToForwardSlash(newValue);
        this.eventHandler.onValueChange(this.structureControl, path);
    }

    private Optional<File> resolveAbsolutePath(String filePath) {
        if (filePath == null) {
            return Optional.empty();
        }
        File file = new File(filePath);
        if (file.isAbsolute()) {
            return Optional.of(file);
        }
        if (this.workingDir == null || !Files.exists(this.workingDir.toPath(), new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(this.workingDir.toPath().resolve(file.toPath()).toFile());
    }

    private boolean isSaveDialog() {
        return this.structureControl instanceof SCFile && ((SCFile)this.structureControl).getDialog() == SCFile.DialogMode.SAVE;
    }

    public static void switchAbsoluteRelativePath(ActionEvent event, File workingDir, TextField textFieldValue) {
        try {
            if (workingDir == null) {
                return;
            }
            Path path = Path.of(textFieldValue.getText(), new String[0]);
            if (path.isAbsolute()) {
                Path relativize = workingDir.toPath().relativize(path);
                textFieldValue.setText(UIValueControl.convertToForwardSlash(relativize.toString()));
            } else {
                Path resolve = workingDir.toPath().resolve(textFieldValue.getText());
                textFieldValue.setText(UIValueControl.convertToForwardSlash(resolve.toString()));
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Failed convert absolute/relative path");
        }
        event.consume();
    }
}

