/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fx.control.UIValueControlDoubleSpinner;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

class UIValueControlTextField
extends AnchorPane
implements UIValueControl,
ChangeListener<String> {
    private final Logger logger = Logger.getLogger(UIValueControlDoubleSpinner.class);
    private SControl structureControl;
    private UIControlEventHandler eventHandler;
    @FXML
    TextField textFieldValue;

    UIValueControlTextField() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.textFieldValue.textProperty().addListener((ChangeListener)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        if (property.getVal() == null) {
            return;
        }
        this.textFieldValue.textProperty().removeListener((ChangeListener)this);
        this.textFieldValue.setText(property.getVal().toString());
        this.textFieldValue.textProperty().addListener((ChangeListener)this);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        switch (structureControl.getValueType()) {
            case STRING: 
            case SCALAR: 
            case SETTINGS: {
                this.textFieldValue.setVisible(true);
                this.textFieldValue.setManaged(true);
                break;
            }
            default: {
                this.logger.error((Object)String.format("Unsupported text field data type: '%s', control: '%s'", structureControl.getValueType().toString(), structureControl.getName()));
            }
        }
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            this.textFieldValue.setTooltip((Tooltip)new StareTooltip(hint));
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        if (this.eventHandler != null) {
            this.eventHandler.onValueChange(this.structureControl, newValue);
        }
    }
}

