/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.RectangularArea;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;

public final class SpherePolyhedraTools {
    private SpherePolyhedraTools() {
    }

    public static GeneratrixSet deserializeGeneratrixSetOrNull(Executor executor, String inputGeneratrixSetPort) {
        SNumbers inputGeneratrixSet = executor.getInputNumbers(inputGeneratrixSetPort, true);
        return inputGeneratrixSet.isInitialized() ? GeneratrixSet.deserialize(new GeneratrixSet.SerializedForm().setData(inputGeneratrixSet.toIntArray())) : null;
    }

    public static SerializedSpherePolyhedra retrieveSpherePolyhedra(Executor executor, String inputXyzrPort, String inputGeneratrixSetsPort, String inputKindsPort) {
        SNumbers xyzr = inputXyzrPort == null ? SNumbers.zeros(Double.TYPE, (int)0, (int)3) : executor.getInputNumbers(inputXyzrPort, true);
        int[] generatrixSets = inputGeneratrixSetsPort == null ? null : executor.getInputNumbers(inputGeneratrixSetsPort, true).toIntArray();
        long[] kinds = inputKindsPort == null ? null : executor.getInputNumbers(inputKindsPort, true).toLongArray();
        return new SerializedSpherePolyhedra().setCoordinates(xyzr.toDoubleArray(), xyzr.getBlockLength()).setSerializedGeneratrixSets(generatrixSets).setKindIds(kinds);
    }

    public static void uploadSpherePolyhedra(Executor executor, SerializedSpherePolyhedra serializedSpherePolyhedra, String outputXyzrPort, String outputGeneratrixSetsPort, String outputKindsPort) {
        long[] kindIds;
        int[] generatrixSets;
        double[] xyzr;
        if (outputXyzrPort != null && (xyzr = serializedSpherePolyhedra.getXyzr()) != null) {
            executor.getNumbers(outputXyzrPort).setTo(xyzr, 4);
        }
        if (outputGeneratrixSetsPort != null && (generatrixSets = serializedSpherePolyhedra.getSerializedGeneratrixSets()) != null) {
            executor.getNumbers(outputGeneratrixSetsPort).setTo(generatrixSets, serializedSpherePolyhedra.serializedGeneratrixSetsBlockLength());
        }
        if (outputKindsPort != null && (kindIds = serializedSpherePolyhedra.getKindIds()) != null) {
            executor.getNumbers(outputKindsPort).setTo(kindIds, 1);
        }
    }

    public static SpherePolyhedra deserializeSpherePolyhedra(Executor executor, String inputXyzrPort, String inputGeneratrixSetsPort, String inputKindsPort) {
        return SpherePolyhedra.deserialize(SpherePolyhedraTools.retrieveSpherePolyhedra(executor, inputXyzrPort, inputGeneratrixSetsPort, inputKindsPort));
    }

    public static void serializeGeneratrixSet(Executor executor, GeneratrixSet generatrixSet, String outputGeneratrixSetPort) {
        executor.getNumbers(outputGeneratrixSetPort).setTo(generatrixSet.serialize().getData(), 3);
    }

    public static void serializeSpherePolyhedra(Executor executor, SpherePolyhedra spherePolyhedra, String outputXyzrPort, String outputGeneratrixSetsPort) {
        SpherePolyhedraTools.serializeSpherePolyhedra(executor, spherePolyhedra, outputXyzrPort, outputGeneratrixSetsPort, null);
    }

    public static void serializeSpherePolyhedra(Executor executor, SpherePolyhedra spherePolyhedra, String outputXyzrPort, String outputGeneratrixSetsPort, String outputKindsPort) {
        SerializedSpherePolyhedra serialized = spherePolyhedra.serialize();
        SpherePolyhedraTools.uploadSpherePolyhedra(executor, serialized, outputXyzrPort, outputGeneratrixSetsPort, outputKindsPort);
    }

    public static void serializeParallelepiped(Executor executor, RectangularArea parallelepiped, String outputParallelepipedPort) {
        if (parallelepiped != null) {
            executor.getNumbers(outputParallelepipedPort).setTo(parallelepiped);
        }
    }
}

