/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.model3d.spherepolyhedra.SpherePolyhedraTools;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;

public final class ReadSpherePolyhedra
extends FileOperation
implements ReadOnlyExecutionInput {
    public ReadSpherePolyhedra() {
        this.addFileOperationPorts();
        this.setDefaultOutputNumbers("xyzr");
        this.addOutputNumbers("generatrix_sets");
        this.addOutputNumbers("kinds");
        this.addOutputScalar("kind_set");
        this.addOutputScalar("packing_geometry");
    }

    public ReadSpherePolyhedra setFile(String file) {
        super.setFile(file);
        return this;
    }

    public void process() {
        Path path = this.completeFilePath();
        try {
            if (this.skipIfMissingFileOrThrow(path)) {
                return;
            }
            AtomicReference<Object> kindSetJson = new AtomicReference<Object>(null);
            AtomicReference<Object> packingGeometryJson = new AtomicReference<Object>(null);
            SerializedSpherePolyhedra serializedSpherePolyhedra = SerializedSpherePolyhedra.read(path, kindSetJson, packingGeometryJson);
            SpherePolyhedraTools.uploadSpherePolyhedra((Executor)this, serializedSpherePolyhedra, "xyzr", "generatrix_sets", "kinds");
            if (kindSetJson.get() != null) {
                this.getScalar("kind_set").setTo((String)kindSetJson.get());
            }
            if (packingGeometryJson.get() != null) {
                this.getScalar("packing_geometry").setTo((String)packingGeometryJson.get());
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        if (this.isVisibleResultDisabled()) {
            return new ExecutionVisibleResultsInformation();
        }
        return new ExecutionVisibleResultsInformation().setModel("spherepolyhedra").setPorts(new Port[]{this.getOutputPort("xyzr"), this.getOutputPort("generatrix_sets"), this.getOutputPort("kinds"), this.getOutputPort("kind_set")});
    }

    public boolean isVisiblePort(Port port) {
        return port.isOutput() && (port.getName().equals("xyzr") || port.getName().equals("generatrix_sets") || port.getName().equals("kinds") || port.getName().equals("kind_set"));
    }
}

