/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.executors.modules.model3d.spherepolyhedra.SpherePolyhedraTools;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;

public final class WriteSpherePolyhedra
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    public WriteSpherePolyhedra() {
        this.setDefaultInputNumbers("xyzr");
        this.addInputNumbers("generatrix_sets");
        this.addInputNumbers("kinds");
        this.addInputScalar("kind_set");
        this.addInputScalar("packing_geometry");
    }

    public WriteSpherePolyhedra setFile(String file) {
        super.setFile(file);
        return this;
    }

    public void process() {
        SerializedSpherePolyhedra serializedSpherePolyhedra = SpherePolyhedraTools.retrieveSpherePolyhedra((Executor)this, "xyzr", "generatrix_sets", "kinds");
        String kindSetJson = this.getInputScalar("kind_set", true).getValue();
        String packingGeometryJson = this.getInputScalar("packing_geometry", true).getValue();
        Path file = this.completeFilePath().toAbsolutePath();
        WriteSpherePolyhedra.logDebug(() -> "Writing " + serializedSpherePolyhedra.numberOfSpherePolyhedra() + " sphere-polyhedra to file " + String.valueOf(file));
        try {
            serializedSpherePolyhedra.write(file, kindSetJson, packingGeometryJson);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        if (this.isVisibleResultDisabled()) {
            return new ExecutionVisibleResultsInformation();
        }
        return new ExecutionVisibleResultsInformation().setModel("spherepolyhedra").setPorts(new Port[]{this.getInputPort("xyzr"), this.getInputPort("generatrix_sets"), this.getInputPort("kinds"), this.getInputPort("kind_set")});
    }
}

