/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.objects;

import java.util.Set;
import net.algart.executors.api.data.Data;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraFilter;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class FilterSpherePolyhedra
extends SpherePolyhedraFilter {
    private int retainedFromIndex = 0;
    private Integer retainedToIndex = null;
    private ObjectStatistics statistics = ObjectStatistics.MAX_RADIUS;
    private Double retainedMin = null;
    private Double retainedMax = null;
    private boolean removeUnknownAndSystemKinds = false;
    private String onlyKinds = "";

    public int getRetainedFromIndex() {
        return this.retainedFromIndex;
    }

    public FilterSpherePolyhedra setRetainedFromIndex(int retainedFromIndex) {
        this.retainedFromIndex = FilterSpherePolyhedra.nonNegative((int)retainedFromIndex);
        return this;
    }

    public Integer getRetainedToIndex() {
        return this.retainedToIndex;
    }

    public FilterSpherePolyhedra setRetainedToIndex(Integer retainedToIndex) {
        this.retainedToIndex = retainedToIndex == null ? null : Integer.valueOf(FilterSpherePolyhedra.nonNegative((int)retainedToIndex));
        return this;
    }

    public FilterSpherePolyhedra setRetainedToIndex(String toIndex) {
        return this.setRetainedToIndex(FilterSpherePolyhedra.intOrNull((String)toIndex));
    }

    public ObjectStatistics getStatistics() {
        return this.statistics;
    }

    public FilterSpherePolyhedra setStatistics(ObjectStatistics statistics) {
        this.statistics = (ObjectStatistics)((Object)FilterSpherePolyhedra.nonNull((Object)((Object)statistics)));
        return this;
    }

    public Double getRetainedMin() {
        return this.retainedMin;
    }

    public FilterSpherePolyhedra setRetainedMin(Double retainedMin) {
        this.retainedMin = retainedMin == null ? null : Double.valueOf(FilterSpherePolyhedra.nonNegative((double)retainedMin));
        return this;
    }

    public FilterSpherePolyhedra setRetainedMin(String minContainingSphereRadius) {
        return this.setRetainedMin(FilterSpherePolyhedra.doubleOrNull((String)minContainingSphereRadius));
    }

    public Double getRetainedMax() {
        return this.retainedMax;
    }

    public FilterSpherePolyhedra setRetainedMax(Double retainedMax) {
        this.retainedMax = retainedMax == null ? null : Double.valueOf(FilterSpherePolyhedra.nonNegative((double)retainedMax));
        return this;
    }

    public FilterSpherePolyhedra setRetainedMax(String maxContainingSphereRadius) {
        return this.setRetainedMax(FilterSpherePolyhedra.doubleOrNull((String)maxContainingSphereRadius));
    }

    public boolean isRemoveUnknownAndSystemKinds() {
        return this.removeUnknownAndSystemKinds;
    }

    public FilterSpherePolyhedra setRemoveUnknownAndSystemKinds(boolean removeUnknownAndSystemKinds) {
        this.removeUnknownAndSystemKinds = removeUnknownAndSystemKinds;
        return this;
    }

    public String getOnlyKinds() {
        return this.onlyKinds;
    }

    public FilterSpherePolyhedra setOnlyKinds(String onlyKinds) {
        this.onlyKinds = (String)FilterSpherePolyhedra.nonNull((Object)onlyKinds);
        return this;
    }

    public void process() {
        final SpherePolyhedra spherePolyhedra = this.deserializeSpherePolyhedra();
        final boolean kindsExist = this.kindsExist();
        final boolean useOnlyKinds = !this.onlyKinds.trim().isEmpty();
        final Set<Long> onlyKindIds = SpherePolyhedronKind.splitKindIds(this.onlyKinds);
        final int toIndex = this.retainedToIndex == null ? spherePolyhedra.numberOfObjects() : this.retainedToIndex.intValue();
        spherePolyhedra.removeObjects(new SpherePolyhedra.RemovingCondition(){

            @Override
            public boolean acceptRemoving(int objectIndex, SpherePolyhedrion objectToRemove) {
                long kindId = spherePolyhedra.getObjectKindId(objectIndex);
                if (kindId <= 0L && !FilterSpherePolyhedra.this.removeUnknownAndSystemKinds) {
                    return false;
                }
                if (objectIndex < FilterSpherePolyhedra.this.retainedFromIndex || objectIndex > toIndex) {
                    return true;
                }
                if (kindsExist && useOnlyKinds && !onlyKindIds.contains(kindId)) {
                    return true;
                }
                if (FilterSpherePolyhedra.this.retainedMin != null || FilterSpherePolyhedra.this.retainedMax != null) {
                    double value = FilterSpherePolyhedra.this.statistics.value(spherePolyhedra, objectIndex, objectToRemove);
                    return FilterSpherePolyhedra.this.retainedMin != null && value <= FilterSpherePolyhedra.this.retainedMin || FilterSpherePolyhedra.this.retainedMax != null && value >= FilterSpherePolyhedra.this.retainedMax;
                }
                return false;
            }

            @Override
            public boolean requiresObjectForDecision() {
                return FilterSpherePolyhedra.this.statistics.requiresObjectForDecision;
            }
        });
        this.serializeSpherePolyhedra(spherePolyhedra);
        this.getScalar("kind_set").exchange((Data)this.getInputScalar("kind_set", true));
    }

    public static enum ObjectStatistics {
        MAX_RADIUS(false){

            @Override
            double value(SpherePolyhedra spherePolyhedra, int objectIndex, SpherePolyhedrion objectToRemove) {
                return spherePolyhedra.maxContainingSphereRadiusForObject(objectIndex);
            }
        }
        ,
        SUMMARY_VOLUME(true){

            @Override
            double value(SpherePolyhedra spherePolyhedra, int objectIndex, SpherePolyhedrion objectToRemove) {
                return objectToRemove.summaryVolume();
            }
        };

        private final boolean requiresObjectForDecision;

        private ObjectStatistics(boolean requiresObjectForDecision) {
            this.requiresObjectForDecision = requiresObjectForDecision;
        }

        abstract double value(SpherePolyhedra var1, int var2, SpherePolyhedrion var3);
    }
}

