/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourKindRequirement;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestriction;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class NeighbourKindSetRequirement
extends SpherePolyhedraNeighbourhoodPackingRestriction {
    private Set<Long> requiredNeighbourKindSet = new LinkedHashSet<Long>();
    private int minimalNumberOfRequiredNeighbours = 1;

    public Set<Long> getRequiredNeighbourKindSet() {
        return Collections.unmodifiableSet(this.requiredNeighbourKindSet);
    }

    public NeighbourKindSetRequirement setRequiredNeighbourKindSet(Collection<Long> requiredNeighbourKindSet) {
        Objects.requireNonNull(requiredNeighbourKindSet, "Null requiredNeighbourKindSet");
        this.requiredNeighbourKindSet = new LinkedHashSet<Long>(requiredNeighbourKindSet);
        return this;
    }

    public int getMinimalNumberOfRequiredNeighbours() {
        return this.minimalNumberOfRequiredNeighbours;
    }

    public NeighbourKindSetRequirement setMinimalNumberOfRequiredNeighbours(int minimalNumberOfRequiredNeighbours) {
        if (minimalNumberOfRequiredNeighbours < 0 || minimalNumberOfRequiredNeighbours > 3) {
            throw new IllegalArgumentException("Illegal minimal number of required neighbours " + minimalNumberOfRequiredNeighbours + " (must be in 0..3 range)");
        }
        this.minimalNumberOfRequiredNeighbours = minimalNumberOfRequiredNeighbours;
        return this;
    }

    @Override
    public boolean allowFirstNeighbour(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex, long neighbourKindId) {
        return this.minimalNumberOfRequiredNeighbours <= 0 || this.requiredNeighbourKindSet.contains(neighbourKindId);
    }

    @Override
    public boolean allowAllNeighbours(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex1, long neighbourKindId1, int neighbourIndex2, long neighbourKindId2, int neighbourIndex3, long neighbourKindId3) {
        int count;
        if (this.minimalNumberOfRequiredNeighbours <= 0) {
            return true;
        }
        int n = count = this.requiredNeighbourKindSet.contains(neighbourKindId1) ? 1 : 0;
        if (count >= this.minimalNumberOfRequiredNeighbours) {
            return true;
        }
        if (this.requiredNeighbourKindSet.contains(neighbourKindId2) && ++count >= this.minimalNumberOfRequiredNeighbours) {
            return true;
        }
        return this.requiredNeighbourKindSet.contains(neighbourKindId3) && ++count >= this.minimalNumberOfRequiredNeighbours;
    }

    @Override
    public String toString() {
        return "require >=" + this.minimalNumberOfRequiredNeighbours + " neighbours of " + this.requiredNeighbourKindSet.size() + " kinds";
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (Long kindId : this.requiredNeighbourKindSet) {
            if (kindId == null) continue;
            arrayBuilder.add(SpherePolyhedronKind.idToFriendlyString(kindId));
        }
        builder.add("kinds", (JsonValue)arrayBuilder.build());
        builder.add("number", this.minimalNumberOfRequiredNeighbours);
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        JsonArray kindsJson = json.getJsonArray("kinds");
        ArrayList<Long> kinds = new ArrayList<Long>();
        if (kindsJson != null) {
            int n = kindsJson.size();
            for (int k = 0; k < n; ++k) {
                kinds.add(SpherePolyhedronKind.friendlyStringToId(kindsJson.getString(k)));
            }
        }
        this.setRequiredNeighbourKindSet(kinds);
        this.setMinimalNumberOfRequiredNeighbours(json.getInt("number", 1));
    }

    @Override
    PackingRestriction optimize() {
        switch (this.requiredNeighbourKindSet.size()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return new NeighbourKindRequirement().setMinimalNumberOfRequiredNeighbours(this.minimalNumberOfRequiredNeighbours).setRequiredNeighbourKindId(this.requiredNeighbourKindSet.iterator().next());
            }
        }
        return this;
    }
}

