/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.kinds.PreferredDirection;
import net.algart.model3d.spherepolyhedra.kinds.RandomAngleDistribution;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestrictionFactory;
import net.algart.model3d.spherepolyhedra.objects.AbstractSpherePolyhedrionModifier;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersection;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraStraightIntersectionsFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionModifier;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionPositionComparator;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionStraightChooser;

public final class BestTouchingPositionFinder {
    private static final boolean MULTITHREADING_OPTIMIZATION = true;
    private final SpherePolyhedra spherePolyhedra;
    private final SpherePolyhedrionPositionComparator comparator;
    private final long randSeed;
    private int numberOfCheckedPositions = 0;
    private SpherePolyhedrionModifier modifier = SpherePolyhedrionModifier.EMPTY;
    private Settings settings = new Settings();
    private SpherePolyhedraPackingGeometry geometry = null;
    private PackingRestrictionFactory restrictionFactory = PackingRestrictionFactory.EMPTY;
    private int neighbourIndex = -1;
    private SpherePolyhedrion touching = null;
    private SpherePolyhedraStraightIntersectionsFinder[] intersectionsFinder = null;
    private PreferredDirection[] straightPreferredDirection = null;
    private StraightLine3D[] probeStraight = null;
    private SpherePolyhedraIntersection[] probePosition = null;
    private SpherePolyhedrion[] workAdded = null;
    private SpherePolyhedrion[] workAddedCopy = null;
    private SpherePolyhedrion[] workDeepest = null;
    private SpherePolyhedraIntersection[] workIntersection = null;
    private StraightLine3D[] workTurnedStraight = null;
    private Random[] randoms = null;
    private volatile SpherePolyhedrion optimalNeighbour = null;
    private volatile double lastMinimizedDistance = Double.POSITIVE_INFINITY;
    private volatile int optimmalNeighbourIndex = -1;
    private volatile int optimalAttempt = -1;
    private final Object lock = new Object();

    public BestTouchingPositionFinder(SpherePolyhedra spherePolyhedra, SpherePolyhedrionPositionComparator comparator, long randSeed) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra, "Null sphere-polyhedra array");
        this.comparator = Objects.requireNonNull(comparator, "Null comparator");
        this.randSeed = randSeed;
        this.setNumberOfCheckedPositions(1);
    }

    public BestTouchingPositionFinder setNumberOfCheckedPositions(int numberOfCheckedPositions) {
        if (numberOfCheckedPositions <= 0) {
            throw new IllegalArgumentException("Zero or negative numberOfCheckedStraights =" + numberOfCheckedPositions);
        }
        if (numberOfCheckedPositions != this.numberOfCheckedPositions) {
            this.intersectionsFinder = new SpherePolyhedraStraightIntersectionsFinder[numberOfCheckedPositions];
            this.straightPreferredDirection = new PreferredDirection[numberOfCheckedPositions];
            this.probeStraight = new StraightLine3D[numberOfCheckedPositions];
            this.probePosition = new SpherePolyhedraIntersection[numberOfCheckedPositions];
            this.workAdded = new SpherePolyhedrion[numberOfCheckedPositions];
            this.workAddedCopy = new SpherePolyhedrion[numberOfCheckedPositions];
            this.workDeepest = new SpherePolyhedrion[numberOfCheckedPositions];
            this.workIntersection = new SpherePolyhedraIntersection[numberOfCheckedPositions];
            this.workTurnedStraight = new StraightLine3D[numberOfCheckedPositions];
            this.randoms = new Random[numberOfCheckedPositions];
            Random random = new Random(this.randSeed);
            for (int k = 0; k < numberOfCheckedPositions; ++k) {
                this.intersectionsFinder[k] = new SpherePolyhedraStraightIntersectionsFinder(this.spherePolyhedra);
                this.straightPreferredDirection[k] = new PreferredDirection();
                this.probeStraight[k] = StraightLine3D.newLine();
                this.probePosition[k] = new SpherePolyhedraIntersection();
                this.workAdded[k] = new SpherePolyhedrion();
                this.workAddedCopy[k] = new SpherePolyhedrion();
                this.workDeepest[k] = new SpherePolyhedrion();
                this.workIntersection[k] = new SpherePolyhedraIntersection();
                this.workTurnedStraight[k] = StraightLine3D.newLine();
                this.randoms[k] = new Random(random.nextLong());
            }
        }
        this.numberOfCheckedPositions = numberOfCheckedPositions;
        return this;
    }

    public SpherePolyhedrionModifier getModifier() {
        return this.modifier;
    }

    public BestTouchingPositionFinder setModifier(SpherePolyhedrionModifier modifier) {
        this.modifier = Objects.requireNonNull(modifier, "Null modifier");
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public BestTouchingPositionFinder setSettings(Settings settings) {
        this.settings = Objects.requireNonNull(settings, "Null turning settings");
        return this;
    }

    public SpherePolyhedraPackingGeometry getGeometry() {
        return this.geometry;
    }

    public BestTouchingPositionFinder setGeometry(SpherePolyhedraPackingGeometry geometry) {
        this.geometry = geometry;
        return this;
    }

    public PackingRestrictionFactory getRestrictionFactory() {
        return this.restrictionFactory;
    }

    public BestTouchingPositionFinder setRestrictionFactory(PackingRestrictionFactory restrictionFactory) {
        this.restrictionFactory = Objects.requireNonNull(restrictionFactory, "Null restriction factory");
        return this;
    }

    public boolean findPosition(SpherePolyhedrion objectToPack, SpherePolyhedrionStraightChooser straightChooser) {
        Objects.requireNonNull(objectToPack, "Null objectToPack");
        Objects.requireNonNull(straightChooser, "Null straightChooser");
        PackingRestriction packingRestriction = this.restrictionFactory.getRecommendedPackingRestriction(objectToPack);
        this.optimalNeighbour = null;
        this.optimmalNeighbourIndex = -1;
        this.optimalAttempt = -1;
        this.lastMinimizedDistance = Double.POSITIVE_INFINITY;
        IntStream loopStream = this.numberOfCheckedPositions > 1 && Arrays.SystemSettings.cpuCount() > 1 ? IntStream.range(0, this.numberOfCheckedPositions).parallel() : IntStream.range(0, this.numberOfCheckedPositions);
        loopStream.forEach(attempt -> {
            StraightLine3D probeStraight = this.probeStraight[attempt];
            SpherePolyhedraIntersection probePosition = this.probePosition[attempt];
            SpherePolyhedrion workAdded = this.workAdded[attempt];
            SpherePolyhedrion workAddedCopy = this.workAddedCopy[attempt];
            Random random = this.randoms[attempt];
            workAdded.setTo(objectToPack);
            workAddedCopy.setTo(objectToPack);
            if (this.modifier instanceof AbstractSpherePolyhedrionModifier) {
                ((AbstractSpherePolyhedrionModifier)this.modifier).modifyInPlace(workAdded, random);
            } else {
                workAdded.setTo(this.modifier.modify(workAdded, random));
            }
            workAdded.setZeroCenter();
            workAdded.setToSymmetry();
            if (!straightChooser.chooseStraight(probeStraight, workAdded, random)) {
                return;
            }
            int index = this.probePosition(probePosition, probeStraight, attempt);
            if (index == -1) {
                return;
            }
            if (!packingRestriction.allowFirstNeighbour(this.spherePolyhedra.numberOfSpherePolyhedra(), objectToPack, index, this.spherePolyhedra.getKindId(index))) {
                return;
            }
            workAdded.setToSymmetry();
            double x = probePosition.x();
            double y = probePosition.y();
            double z = probePosition.z();
            workAdded.setCenter(x, y, z);
            Object object = this.lock;
            synchronized (object) {
                int compare;
                int n = compare = this.optimalNeighbour == null ? -1 : this.comparator.compare(workAdded, this.optimalNeighbour);
                if (compare < 0 || compare == 0 && attempt < this.optimalAttempt) {
                    this.optimmalNeighbourIndex = index;
                    this.optimalAttempt = attempt;
                    if (this.optimalNeighbour == null) {
                        this.optimalNeighbour = new SpherePolyhedrion();
                    }
                    this.optimalNeighbour.setTo(workAdded);
                    this.lastMinimizedDistance = this.comparator.minimizedDistance(x, y, z);
                }
            }
        });
        this.neighbourIndex = this.optimmalNeighbourIndex;
        this.touching = this.optimalNeighbour;
        return this.optimalNeighbour != null;
    }

    public int getNeighbourIndex() {
        return this.neighbourIndex;
    }

    public SpherePolyhedrion getTouching() {
        return this.touching;
    }

    private int probePosition(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, int probeIndex) {
        SpherePolyhedraStraightIntersectionsFinder intersectionsFinder = this.intersectionsFinder[probeIndex];
        PreferredDirection straightPreferredDirection = this.straightPreferredDirection[probeIndex];
        SpherePolyhedrion workAddedSymmetry = this.workAdded[probeIndex];
        SpherePolyhedraIntersection workIntersection = this.workIntersection[probeIndex];
        StraightLine3D workTurnedStraight = this.workTurnedStraight[probeIndex];
        Random random = new Random(this.randoms[probeIndex].nextLong());
        intersectionsFinder.setAddedForDilation(workAddedSymmetry);
        int index = this.settings.firstPositionStrategy.findFirstPosition(resultPosition, straight, this, probeIndex);
        int maxNumberOfTurns = this.settings.getMaxNumberOfTurns();
        double remainingPath = this.settings.getMaxSummaryPath();
        if (index == -1 || remainingPath <= 0.0 || maxNumberOfTurns <= 0) {
            return index;
        }
        if (this.spherePolyhedra.getKindId(index) <= 0L) {
            switch (this.settings.behaviourWhenTouchingSystemObjectOrUnknownObjects.ordinal()) {
                case 2: {
                    return index;
                }
            }
        }
        workTurnedStraight.setDirection(-straight.dx(), -straight.dy(), -straight.dz());
        straightPreferredDirection.setAngleDeviationInDegrees(this.settings.turnAngleDeviationInDegrees);
        straightPreferredDirection.setDistribution(this.settings.turnAngleDistribution);
        double epsilon = workAddedSymmetry.maxContainingSphereRadius() * 1.0E-7;
        intersectionsFinder.setMinimalAlmostZeroPositiveT(epsilon);
        double minNecessaryAdditionalMovement = this.minNecessaryAdditionalMovement(resultPosition, this.lastMinimizedDistance);
        for (int k = 0; k < maxNumberOfTurns; ++k) {
            if (remainingPath < 0.0 || remainingPath < minNecessaryAdditionalMovement - epsilon) {
                return -1;
            }
            workTurnedStraight.setStart(resultPosition.x(), resultPosition.y(), resultPosition.z());
            int newIndex = -1;
            boolean canMove = false;
            boolean surelyGood = false;
            int m = this.settings.getMaxNumberOfAttemptsToTurn();
            block9: for (int i = 0; i < m && !canMove; ++i) {
                straightPreferredDirection.setDirectionAlongStraight(workTurnedStraight);
                workTurnedStraight.setDirectionAlongI(straightPreferredDirection.newRandomBasisAlongDirection(random));
                if (intersectionsFinder.findFirstIntersectionWithSingleSpherePolyhedron(workIntersection, workTurnedStraight, index) && workIntersection.t() > -epsilon) {
                    newIndex = index;
                    continue;
                }
                newIndex = intersectionsFinder.findFirstPositiveIntersection(workIntersection, workTurnedStraight, index);
                if (newIndex == -1 || newIndex == index || !(workIntersection.t() > epsilon)) continue;
                canMove = true;
                if (this.spherePolyhedra.getKindId(newIndex) > 0L) continue;
                switch (this.settings.behaviourWhenTouchingSystemObjectOrUnknownObjects.ordinal()) {
                    case 2: {
                        surelyGood = true;
                        continue block9;
                    }
                    case 1: {
                        canMove = false;
                        continue block9;
                    }
                    case 3: {
                        return -1;
                    }
                }
            }
            if (!canMove) continue;
            if (workIntersection.t() > remainingPath) break;
            index = newIndex;
            resultPosition.setTo(workIntersection);
            minNecessaryAdditionalMovement = this.minNecessaryAdditionalMovement(resultPosition, this.lastMinimizedDistance);
            remainingPath -= resultPosition.t();
            if (surelyGood) break;
        }
        return index;
    }

    private int findLast(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, int probeIndex) {
        SpherePolyhedraStraightIntersectionsFinder intersectionsFinder = this.intersectionsFinder[probeIndex];
        return intersectionsFinder.findLastIntersection(resultPosition, straight);
    }

    private int findDeepestOrRandom(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, boolean randomPosition, int probeIndex) {
        SpherePolyhedraStraightIntersectionsFinder intersectionsFinder = this.intersectionsFinder[probeIndex];
        SpherePolyhedrion workAddedCopy = this.workAddedCopy[probeIndex];
        SpherePolyhedrion workDeepest = this.workDeepest[probeIndex];
        intersectionsFinder.findAllIntersections(straight);
        int n = intersectionsFinder.numberOfPoints();
        if (n == 0) {
            return -1;
        }
        intersectionsFinder.sortByT();
        int numberOfFirstSkippedPositions = 2 * workAddedCopy.numberOfElements() - 1;
        boolean useGeometry = this.settings.useGeometry && this.geometry != null;
        int numberOfValidPositions = 0;
        int nestingLevel = 0;
        for (int k = 0; k < n; ++k) {
            boolean valid;
            boolean openingBracket = intersectionsFinder.entryFlags[k];
            double t = intersectionsFinder.t[k];
            int spherePolyhedronIndex = intersectionsFinder.spherePolyhedronIndexes[k];
            if (openingBracket) {
                boolean bl = valid = nestingLevel == 0;
                if (!useGeometry && k < numberOfFirstSkippedPositions && this.spherePolyhedra.getKindId(spherePolyhedronIndex) == 0L) {
                    valid = false;
                }
                ++nestingLevel;
            } else {
                boolean bl = valid = --nestingLevel == 0;
            }
            if (valid && useGeometry) {
                workAddedCopy.setCenter(straight.x(t), straight.y(t), straight.z(t));
                if (!this.geometry.isPositionAllowed(workAddedCopy)) {
                    valid = false;
                }
            }
            if (!valid) continue;
            intersectionsFinder.t[numberOfValidPositions] = t;
            intersectionsFinder.spherePolyhedronIndexes[numberOfValidPositions] = spherePolyhedronIndex;
            ++numberOfValidPositions;
        }
        if (numberOfValidPositions == 0) {
            return -1;
        }
        int from = 0;
        int to = numberOfValidPositions;
        if (randomPosition) {
            Random random = this.randoms[probeIndex];
            from = random.nextInt(numberOfValidPositions);
            to = from + 1;
        }
        SpherePolyhedrion deepest = null;
        double deepestT = Double.NaN;
        int resultIndex = -1;
        for (int i = from; i < to; ++i) {
            int compare;
            double t = intersectionsFinder.t[i];
            workAddedCopy.setCenter(straight.x(t), straight.y(t), straight.z(t));
            int n2 = compare = deepest == null ? -1 : this.comparator.compare(workAddedCopy, deepest);
            if (compare >= 0) continue;
            deepestT = t;
            resultIndex = intersectionsFinder.spherePolyhedronIndexes[i];
            if (deepest == null) {
                deepest = workDeepest;
            }
            deepest.setTo(workAddedCopy);
        }
        if (nestingLevel != 0) {
            throw new AssertionError((Object)("Non-balanced brackets: " + nestingLevel));
        }
        if (deepest == null) {
            throw new AssertionError((Object)("At least one from " + n + " positions must be closing bracket with zero nesting level"));
        }
        resultPosition.setT(SpherePolyhedraIntersection.SurfaceType.COMMON_INTERSECTION, deepestT);
        resultPosition.setXYZ(straight);
        return resultIndex;
    }

    private double minNecessaryAdditionalMovement(SpherePolyhedraIntersection probePosition, double lastMinimizedDistance) {
        if (this.comparator.isMinimizedDistanceSupported()) {
            return this.comparator.minimizedDistance(probePosition.x(), probePosition.y(), probePosition.z()) - lastMinimizedDistance;
        }
        return 0.0;
    }

    public static final class Settings {
        private FirstPositionStrategy firstPositionStrategy = FirstPositionStrategy.LAST;
        private boolean useGeometry = true;
        private double maxSummaryPath = 0.0;
        private int maxNumberOfTurns = 1;
        private int maxNumberOfAttemptsToTurn = 4;
        double turnAngleDeviationInDegrees = 0.0;
        RandomAngleDistribution turnAngleDistribution = RandomAngleDistribution.NORMAL;
        BehaviourWhenTouchingSystemObject behaviourWhenTouchingSystemObjectOrUnknownObjects = BehaviourWhenTouchingSystemObject.REJECT_AND_TRY_ANOTHER;

        public FirstPositionStrategy getFirstPositionStrategy() {
            return this.firstPositionStrategy;
        }

        public Settings setFirstPositionStrategy(FirstPositionStrategy firstPositionStrategy) {
            this.firstPositionStrategy = Objects.requireNonNull(firstPositionStrategy, "Null firstPositionStrategy");
            return this;
        }

        public boolean isUseGeometry() {
            return this.useGeometry;
        }

        public Settings setUseGeometry(boolean useGeometry) {
            this.useGeometry = useGeometry;
            return this;
        }

        public double getMaxSummaryPath() {
            return this.maxSummaryPath;
        }

        public Settings setMaxSummaryPath(double maxSummaryPath) {
            if (maxSummaryPath < 0.0) {
                throw new IllegalArgumentException("Negative maxSummaryPath");
            }
            this.maxSummaryPath = maxSummaryPath;
            return this;
        }

        public int getMaxNumberOfTurns() {
            return this.maxNumberOfTurns;
        }

        public Settings setMaxNumberOfTurns(int maxNumberOfTurns) {
            if (maxNumberOfTurns < 0) {
                throw new IllegalArgumentException("Negative maxNumberOfTurns");
            }
            this.maxNumberOfTurns = maxNumberOfTurns;
            return this;
        }

        public int getMaxNumberOfAttemptsToTurn() {
            return this.maxNumberOfAttemptsToTurn;
        }

        public Settings setMaxNumberOfAttemptsToTurn(int maxNumberOfAttemptsToTurn) {
            if (maxNumberOfAttemptsToTurn <= 0) {
                throw new IllegalArgumentException("Zero or negative maxNumberOfAttemptsToTurn");
            }
            this.maxNumberOfAttemptsToTurn = maxNumberOfAttemptsToTurn;
            return this;
        }

        public double getTurnAngleDeviationInDegrees() {
            return this.turnAngleDeviationInDegrees;
        }

        public Settings setTurnAngleDeviationInDegrees(double turnAngleDeviationInDegrees) {
            this.turnAngleDeviationInDegrees = turnAngleDeviationInDegrees;
            return this;
        }

        public RandomAngleDistribution getTurnAngleDistribution() {
            return this.turnAngleDistribution;
        }

        public Settings setTurnAngleDistribution(RandomAngleDistribution turnAngleDistribution) {
            this.turnAngleDistribution = Objects.requireNonNull(turnAngleDistribution, "Null angles distribution");
            return this;
        }

        public BehaviourWhenTouchingSystemObject getBehaviourWhenTouchingSystemObjectOrUnknownObjects() {
            return this.behaviourWhenTouchingSystemObjectOrUnknownObjects;
        }

        public Settings setBehaviourWhenTouchingSystemObjectOrUnknownObjects(BehaviourWhenTouchingSystemObject behaviourWhenTouchingSystemObjectOrUnknownObjects) {
            this.behaviourWhenTouchingSystemObjectOrUnknownObjects = Objects.requireNonNull(behaviourWhenTouchingSystemObjectOrUnknownObjects, "Null behaviourWhenTouchingSystemOrUnknownObjects");
            return this;
        }

        public static enum FirstPositionStrategy {
            LAST{

                @Override
                int findFirstPosition(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, BestTouchingPositionFinder finder, int probeIndex) {
                    return finder.findLast(resultPosition, straight, probeIndex);
                }
            }
            ,
            RANDOM{

                @Override
                int findFirstPosition(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, BestTouchingPositionFinder finder, int probeIndex) {
                    return finder.findDeepestOrRandom(resultPosition, straight, true, probeIndex);
                }
            }
            ,
            DEEPEST{

                @Override
                int findFirstPosition(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, BestTouchingPositionFinder finder, int probeIndex) {
                    return finder.findDeepestOrRandom(resultPosition, straight, false, probeIndex);
                }
            };


            abstract int findFirstPosition(SpherePolyhedraIntersection var1, StraightLine3D var2, BestTouchingPositionFinder var3, int var4);
        }

        public static enum BehaviourWhenTouchingSystemObject {
            DEFAULT,
            REJECT_AND_TRY_ANOTHER,
            ACCEPT_AND_STOP,
            REJECT_AND_STOP;

        }
    }
}

