/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Random;
import java.util.random.RandomGenerator;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.objects.AbstractSpherePolyhedrionModifier;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionModifier;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class SpherePolyhedrionRandomRotator
extends AbstractSpherePolyhedrionModifier
implements SpherePolyhedrionModifier {
    @Override
    void modifyInPlace(SpherePolyhedrion spherePolyhedrion, Random random) {
        if (spherePolyhedrion.isSphere()) {
            return;
        }
        Orthonormal3DBasis basis = Orthonormal3DBasis.newRandomBasis((RandomGenerator)random);
        SpherePolyhedron firstElement = spherePolyhedrion.elements[0];
        firstElement.setGeneratrixSet(firstElement.generatrixSet().rotate(basis));
        double centerX = firstElement.centerX();
        double centerY = firstElement.centerY();
        double centerZ = firstElement.centerZ();
        for (int k = 1; k < spherePolyhedrion.n; ++k) {
            SpherePolyhedron element = spherePolyhedrion.elements[k];
            double x = element.centerX() - centerX;
            double y = element.centerY() - centerY;
            double z = element.centerZ() - centerZ;
            element.setGeneratrixSet(element.generatrixSet().rotate(basis));
            element.setCenter(centerX + basis.x(x, y, z), centerY + basis.y(x, y, z), centerZ + basis.z(x, y, z));
        }
    }
}

